/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.convert;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.ReadWritableInterval;
import com.google.appengine.repackaged.org.joda.time.ReadWritablePeriod;
import com.google.appengine.repackaged.org.joda.time.ReadableInterval;
import com.google.appengine.repackaged.org.joda.time.convert.AbstractConverter;
import com.google.appengine.repackaged.org.joda.time.convert.DurationConverter;
import com.google.appengine.repackaged.org.joda.time.convert.IntervalConverter;
import com.google.appengine.repackaged.org.joda.time.convert.PeriodConverter;

class ReadableIntervalConverter
extends AbstractConverter
implements IntervalConverter,
DurationConverter,
PeriodConverter {
    static final ReadableIntervalConverter INSTANCE = new ReadableIntervalConverter();

    protected ReadableIntervalConverter() {
    }

    @Override
    public long getDurationMillis(Object object) {
        return ((ReadableInterval)object).toDurationMillis();
    }

    @Override
    public void setInto(ReadWritablePeriod writablePeriod, Object object, Chronology chrono) {
        ReadableInterval interval = (ReadableInterval)object;
        chrono = chrono != null ? chrono : DateTimeUtils.getIntervalChronology(interval);
        long start = interval.getStartMillis();
        long end = interval.getEndMillis();
        int[] values = chrono.get(writablePeriod, start, end);
        for (int i = 0; i < values.length; ++i) {
            writablePeriod.setValue(i, values[i]);
        }
    }

    @Override
    public boolean isReadableInterval(Object object, Chronology chrono) {
        return true;
    }

    @Override
    public void setInto(ReadWritableInterval writableInterval, Object object, Chronology chrono) {
        ReadableInterval input = (ReadableInterval)object;
        writableInterval.setInterval(input);
        if (chrono != null) {
            writableInterval.setChronology(chrono);
        } else {
            writableInterval.setChronology(input.getChronology());
        }
    }

    @Override
    public Class<?> getSupportedType() {
        return ReadableInterval.class;
    }
}

