/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.serviceapp;

import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.org.joda.time.Instant;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.client.serviceapp.Clock;

public class Utils {
    private Utils() {
    }

    public static boolean isDevelopmentEnvironment() {
        return SystemProperty.environment.value() == SystemProperty.Environment.Value.Development;
    }

    public static Double getRemainingDeadlineInSeconds(Clock clock, Instant deadline) {
        if (deadline == null) {
            return null;
        }
        long remainingMillis = deadline.getMillis() - clock.now().getMillis();
        return new Double((double)remainingMillis / 1000.0);
    }

    public static String getHostedProjectId() {
        return AppIdentityServiceFactory.getAppIdentityService().parseFullAppId(ApiProxy.getCurrentEnvironment().getAppId()).getId();
    }
}

