/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ja" locale.
 */
public class LocalizedNamesImpl_ja extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "JP",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "IS",
        "IE",
        "AZ",
        "AC",
        "AF",
        "US",
        "AE",
        "DZ",
        "AR",
        "AW",
        "AL",
        "AM",
        "AI",
        "AO",
        "AG",
        "AD",
        "YE",
        "GB",
        "IL",
        "IT",
        "IQ",
        "IR",
        "IN",
        "ID",
        "WF",
        "UG",
        "UA",
        "UZ",
        "UY",
        "EC",
        "EG",
        "EE",
        "ET",
        "ER",
        "SV",
        "AU",
        "AT",
        "AX",
        "QO",
        "OM",
        "NL",
        "AN",
        "BQ",
        "CV",
        "GY",
        "KZ",
        "QA",
        "CA",
        "IC",
        "GA",
        "CM",
        "GM",
        "KH",
        "GH",
        "GG",
        "GN",
        "GW",
        "CY",
        "CU",
        "CW",
        "GR",
        "KI",
        "KG",
        "GT",
        "GP",
        "GU",
        "KW",
        "CK",
        "GL",
        "CX",
        "CP",
        "GE",
        "GD",
        "HR",
        "KY",
        "KE",
        "CI",
        "CC",
        "CR",
        "XK",
        "KM",
        "CO",
        "CG",
        "CD",
        "SA",
        "WS",
        "ST",
        "ZM",
        "PM",
        "SM",
        "BL",
        "MF",
        "SL",
        "DJ",
        "GI",
        "JE",
        "JM",
        "SY",
        "SG",
        "SX",
        "ZW",
        "CH",
        "SE",
        "SD",
        "SJ",
        "ES",
        "SR",
        "LK",
        "SK",
        "SI",
        "SZ",
        "EA",
        "SC",
        "SN",
        "RS",
        "KN",
        "VC",
        "SH",
        "LC",
        "SO",
        "SB",
        "TC",
        "TH",
        "TJ",
        "TZ",
        "CZ",
        "TD",
        "TN",
        "CL",
        "TV",
        "DG",
        "DK",
        "DE",
        "TG",
        "TK",
        "DO",
        "DM",
        "TA",
        "TT",
        "TM",
        "TR",
        "TO",
        "NG",
        "NR",
        "NA",
        "NU",
        "NI",
        "NE",
        "NC",
        "NZ",
        "NP",
        "NF",
        "NO",
        "HM",
        "HT",
        "PK",
        "VA",
        "PA",
        "VU",
        "BS",
        "PG",
        "BM",
        "PW",
        "PY",
        "BB",
        "PS",
        "HU",
        "BD",
        "BH",
        "PN",
        "FJ",
        "PH",
        "FI",
        "PR",
        "FO",
        "FK",
        "BR",
        "FR",
        "BG",
        "BF",
        "BN",
        "BI",
        "BT",
        "BV",
        "VN",
        "BJ",
        "VE",
        "BY",
        "BZ",
        "PE",
        "BE",
        "BA",
        "BW",
        "BO",
        "PT",
        "HN",
        "PL",
        "MH",
        "MK",
        "MG",
        "YT",
        "MW",
        "ML",
        "MT",
        "MQ",
        "MY",
        "IM",
        "FM",
        "MM",
        "MX",
        "MU",
        "MR",
        "MZ",
        "MC",
        "MV",
        "MD",
        "MA",
        "MN",
        "ME",
        "MS",
        "JO",
        "LA",
        "LV",
        "LT",
        "LY",
        "LI",
        "LR",
        "RO",
        "LU",
        "RW",
        "LS",
        "LB",
        "RE",
        "RU",
        "IO",
        "VG",
        "EU",
        "EH",
        "GQ",
        "TW",
        "KR",
        "CF",
        "MO",
        "HK",
        "CN",
        "KP",
        "TL",
        "ZA",
        "GS",
        "SS",
        "AQ",
        "JP",
        "GF",
        "PF",
        "TF",
        "VI",
        "AS",
        "UM",
        "MP",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "世界");
    namesMap.put("002", "アフリカ");
    namesMap.put("003", "北アメリカ大陸");
    namesMap.put("005", "南アメリカ");
    namesMap.put("009", "オセアニア");
    namesMap.put("011", "西アフリカ");
    namesMap.put("013", "中央アメリカ");
    namesMap.put("014", "東アフリカ");
    namesMap.put("015", "北アフリカ");
    namesMap.put("017", "中部アフリカ");
    namesMap.put("018", "南部アフリカ");
    namesMap.put("019", "アメリカ大陸");
    namesMap.put("021", "北アメリカ");
    namesMap.put("029", "カリブ");
    namesMap.put("030", "東アジア");
    namesMap.put("034", "南アジア");
    namesMap.put("035", "東南アジア");
    namesMap.put("039", "南ヨーロッパ");
    namesMap.put("053", "オーストララシア");
    namesMap.put("054", "メラネシア");
    namesMap.put("057", "ミクロネシア");
    namesMap.put("061", "ポリネシア");
    namesMap.put("142", "アジア");
    namesMap.put("143", "中央アジア");
    namesMap.put("145", "西アジア");
    namesMap.put("150", "ヨーロッパ");
    namesMap.put("151", "東ヨーロッパ");
    namesMap.put("154", "北ヨーロッパ");
    namesMap.put("155", "西ヨーロッパ");
    namesMap.put("419", "ラテンアメリカ");
    namesMap.put("AC", "アセンション島");
    namesMap.put("AD", "アンドラ");
    namesMap.put("AE", "アラブ首長国連邦");
    namesMap.put("AF", "アフガニスタン");
    namesMap.put("AG", "アンティグア・バーブーダ");
    namesMap.put("AI", "アンギラ");
    namesMap.put("AL", "アルバニア");
    namesMap.put("AM", "アルメニア");
    namesMap.put("AN", "オランダ領アンティル");
    namesMap.put("AO", "アンゴラ");
    namesMap.put("AQ", "南極");
    namesMap.put("AR", "アルゼンチン");
    namesMap.put("AS", "米領サモア");
    namesMap.put("AT", "オーストリア");
    namesMap.put("AU", "オーストラリア");
    namesMap.put("AW", "アルバ");
    namesMap.put("AX", "オーランド諸島");
    namesMap.put("AZ", "アゼルバイジャン");
    namesMap.put("BA", "ボスニア・ヘルツェゴビナ");
    namesMap.put("BB", "バルバドス");
    namesMap.put("BD", "バングラデシュ");
    namesMap.put("BE", "ベルギー");
    namesMap.put("BF", "ブルキナファソ");
    namesMap.put("BG", "ブルガリア");
    namesMap.put("BH", "バーレーン");
    namesMap.put("BI", "ブルンジ");
    namesMap.put("BJ", "ベナン");
    namesMap.put("BL", "サン・バルテルミー島");
    namesMap.put("BM", "バミューダ");
    namesMap.put("BN", "ブルネイ");
    namesMap.put("BO", "ボリビア");
    namesMap.put("BQ", "オランダ領カリブ");
    namesMap.put("BR", "ブラジル");
    namesMap.put("BS", "バハマ");
    namesMap.put("BT", "ブータン");
    namesMap.put("BV", "ブーベ島");
    namesMap.put("BW", "ボツワナ");
    namesMap.put("BY", "ベラルーシ");
    namesMap.put("BZ", "ベリーズ");
    namesMap.put("CA", "カナダ");
    namesMap.put("CC", "ココス(キーリング)諸島");
    namesMap.put("CD", "コンゴ民主共和国(キンシャサ)");
    namesMap.put("CF", "中央アフリカ共和国");
    namesMap.put("CG", "コンゴ共和国(ブラザビル)");
    namesMap.put("CH", "スイス");
    namesMap.put("CI", "コートジボワール");
    namesMap.put("CK", "クック諸島");
    namesMap.put("CL", "チリ");
    namesMap.put("CM", "カメルーン");
    namesMap.put("CN", "中国");
    namesMap.put("CO", "コロンビア");
    namesMap.put("CP", "クリッパートン島");
    namesMap.put("CR", "コスタリカ");
    namesMap.put("CU", "キューバ");
    namesMap.put("CV", "カーボベルデ");
    namesMap.put("CW", "キュラソー");
    namesMap.put("CX", "クリスマス島");
    namesMap.put("CY", "キプロス");
    namesMap.put("CZ", "チェコ共和国");
    namesMap.put("DE", "ドイツ");
    namesMap.put("DG", "ディエゴガルシア島");
    namesMap.put("DJ", "ジブチ");
    namesMap.put("DK", "デンマーク");
    namesMap.put("DM", "ドミニカ国");
    namesMap.put("DO", "ドミニカ共和国");
    namesMap.put("DZ", "アルジェリア");
    namesMap.put("EA", "セウタ・メリリャ");
    namesMap.put("EC", "エクアドル");
    namesMap.put("EE", "エストニア");
    namesMap.put("EG", "エジプト");
    namesMap.put("EH", "西サハラ");
    namesMap.put("ER", "エリトリア");
    namesMap.put("ES", "スペイン");
    namesMap.put("ET", "エチオピア");
    namesMap.put("EU", "欧州連合");
    namesMap.put("FI", "フィンランド");
    namesMap.put("FJ", "フィジー");
    namesMap.put("FK", "フォークランド諸島");
    namesMap.put("FM", "ミクロネシア連邦");
    namesMap.put("FO", "フェロー諸島");
    namesMap.put("FR", "フランス");
    namesMap.put("GA", "ガボン");
    namesMap.put("GB", "イギリス");
    namesMap.put("GD", "グレナダ");
    namesMap.put("GE", "グルジア");
    namesMap.put("GF", "仏領ギアナ");
    namesMap.put("GG", "ガーンジー");
    namesMap.put("GH", "ガーナ");
    namesMap.put("GI", "ジブラルタル");
    namesMap.put("GL", "グリーンランド");
    namesMap.put("GM", "ガンビア");
    namesMap.put("GN", "ギニア");
    namesMap.put("GP", "グアドループ");
    namesMap.put("GQ", "赤道ギニア");
    namesMap.put("GR", "ギリシャ");
    namesMap.put("GS", "南ジョージア島・南サンドイッチ諸島");
    namesMap.put("GT", "グアテマラ");
    namesMap.put("GU", "グアム");
    namesMap.put("GW", "ギニアビサウ");
    namesMap.put("GY", "ガイアナ");
    namesMap.put("HK", "中華人民共和国香港特別行政区");
    namesMap.put("HM", "ハード島・マクドナルド諸島");
    namesMap.put("HN", "ホンジュラス");
    namesMap.put("HR", "クロアチア");
    namesMap.put("HT", "ハイチ");
    namesMap.put("HU", "ハンガリー");
    namesMap.put("IC", "カナリア諸島");
    namesMap.put("ID", "インドネシア");
    namesMap.put("IE", "アイルランド");
    namesMap.put("IL", "イスラエル");
    namesMap.put("IM", "マン島");
    namesMap.put("IN", "インド");
    namesMap.put("IO", "英領インド洋地域");
    namesMap.put("IQ", "イラク");
    namesMap.put("IR", "イラン");
    namesMap.put("IS", "アイスランド");
    namesMap.put("IT", "イタリア");
    namesMap.put("JE", "ジャージー");
    namesMap.put("JM", "ジャマイカ");
    namesMap.put("JO", "ヨルダン");
    namesMap.put("JP", "日本");
    namesMap.put("KE", "ケニア");
    namesMap.put("KG", "キルギス");
    namesMap.put("KH", "カンボジア");
    namesMap.put("KI", "キリバス");
    namesMap.put("KM", "コモロ");
    namesMap.put("KN", "セントクリストファー・ネイビス");
    namesMap.put("KP", "朝鮮民主主義人民共和国");
    namesMap.put("KR", "大韓民国");
    namesMap.put("KW", "クウェート");
    namesMap.put("KY", "ケイマン諸島");
    namesMap.put("KZ", "カザフスタン");
    namesMap.put("LA", "ラオス");
    namesMap.put("LB", "レバノン");
    namesMap.put("LC", "セントルシア");
    namesMap.put("LI", "リヒテンシュタイン");
    namesMap.put("LK", "スリランカ");
    namesMap.put("LR", "リベリア");
    namesMap.put("LS", "レソト");
    namesMap.put("LT", "リトアニア");
    namesMap.put("LU", "ルクセンブルグ");
    namesMap.put("LV", "ラトビア");
    namesMap.put("LY", "リビア");
    namesMap.put("MA", "モロッコ");
    namesMap.put("MC", "モナコ");
    namesMap.put("MD", "モルドバ");
    namesMap.put("ME", "モンテネグロ");
    namesMap.put("MF", "サン・マルタン");
    namesMap.put("MG", "マダガスカル");
    namesMap.put("MH", "マーシャル諸島");
    namesMap.put("MK", "マケドニア");
    namesMap.put("ML", "マリ");
    namesMap.put("MM", "ミャンマー");
    namesMap.put("MN", "モンゴル");
    namesMap.put("MO", "中華人民共和国マカオ特別行政区");
    namesMap.put("MP", "北マリアナ諸島");
    namesMap.put("MQ", "マルティニーク");
    namesMap.put("MR", "モーリタニア");
    namesMap.put("MS", "モントセラト");
    namesMap.put("MT", "マルタ");
    namesMap.put("MU", "モーリシャス");
    namesMap.put("MV", "モルジブ");
    namesMap.put("MW", "マラウイ");
    namesMap.put("MX", "メキシコ");
    namesMap.put("MY", "マレーシア");
    namesMap.put("MZ", "モザンビーク");
    namesMap.put("NA", "ナミビア");
    namesMap.put("NC", "ニューカレドニア");
    namesMap.put("NE", "ニジェール");
    namesMap.put("NF", "ノーフォーク島");
    namesMap.put("NG", "ナイジェリア");
    namesMap.put("NI", "ニカラグア");
    namesMap.put("NL", "オランダ");
    namesMap.put("NO", "ノルウェー");
    namesMap.put("NP", "ネパール");
    namesMap.put("NR", "ナウル");
    namesMap.put("NU", "ニウエ島");
    namesMap.put("NZ", "ニュージーランド");
    namesMap.put("OM", "オマーン");
    namesMap.put("PA", "パナマ");
    namesMap.put("PE", "ペルー");
    namesMap.put("PF", "仏領ポリネシア");
    namesMap.put("PG", "パプアニューギニア");
    namesMap.put("PH", "フィリピン");
    namesMap.put("PK", "パキスタン");
    namesMap.put("PL", "ポーランド");
    namesMap.put("PM", "サンピエール島・ミクロン島");
    namesMap.put("PN", "ピトケアン諸島");
    namesMap.put("PR", "プエルトリコ");
    namesMap.put("PS", "パレスチナ");
    namesMap.put("PT", "ポルトガル");
    namesMap.put("PW", "パラオ");
    namesMap.put("PY", "パラグアイ");
    namesMap.put("QA", "カタール");
    namesMap.put("QO", "オセアニア周辺地域");
    namesMap.put("RE", "レユニオン島");
    namesMap.put("RO", "ルーマニア");
    namesMap.put("RS", "セルビア");
    namesMap.put("RU", "ロシア");
    namesMap.put("RW", "ルワンダ");
    namesMap.put("SA", "サウジアラビア");
    namesMap.put("SB", "ソロモン諸島");
    namesMap.put("SC", "セーシェル");
    namesMap.put("SD", "スーダン");
    namesMap.put("SE", "スウェーデン");
    namesMap.put("SG", "シンガポール");
    namesMap.put("SH", "セントヘレナ");
    namesMap.put("SI", "スロベニア");
    namesMap.put("SJ", "スバールバル諸島・ヤンマイエン島");
    namesMap.put("SK", "スロバキア");
    namesMap.put("SL", "シエラレオネ");
    namesMap.put("SM", "サンマリノ");
    namesMap.put("SN", "セネガル");
    namesMap.put("SO", "ソマリア");
    namesMap.put("SR", "スリナム");
    namesMap.put("SS", "南スーダン");
    namesMap.put("ST", "サントメ・プリンシペ");
    namesMap.put("SV", "エルサルバドル");
    namesMap.put("SX", "シント・マールテン");
    namesMap.put("SY", "シリア");
    namesMap.put("SZ", "スワジランド");
    namesMap.put("TA", "トリスタン・ダ・クーニャ");
    namesMap.put("TC", "タークス・カイコス諸島");
    namesMap.put("TD", "チャド");
    namesMap.put("TF", "仏領極南諸島");
    namesMap.put("TG", "トーゴ");
    namesMap.put("TH", "タイ");
    namesMap.put("TJ", "タジキスタン");
    namesMap.put("TK", "トケラウ");
    namesMap.put("TL", "東ティモール");
    namesMap.put("TM", "トルクメニスタン");
    namesMap.put("TN", "チュニジア");
    namesMap.put("TO", "トンガ");
    namesMap.put("TR", "トルコ");
    namesMap.put("TT", "トリニダード・トバゴ");
    namesMap.put("TV", "ツバル");
    namesMap.put("TW", "台湾");
    namesMap.put("TZ", "タンザニア");
    namesMap.put("UA", "ウクライナ");
    namesMap.put("UG", "ウガンダ");
    namesMap.put("UM", "米領太平洋諸島");
    namesMap.put("US", "アメリカ合衆国");
    namesMap.put("UY", "ウルグアイ");
    namesMap.put("UZ", "ウズベキスタン");
    namesMap.put("VA", "バチカン市国");
    namesMap.put("VC", "セントビンセント・グレナディーン諸島");
    namesMap.put("VE", "ベネズエラ");
    namesMap.put("VG", "英領ヴァージン諸島");
    namesMap.put("VI", "米領ヴァージン諸島");
    namesMap.put("VN", "ベトナム");
    namesMap.put("VU", "バヌアツ");
    namesMap.put("WF", "ウォリス・フツナ");
    namesMap.put("WS", "サモア");
    namesMap.put("XK", "コソボ");
    namesMap.put("YE", "イエメン");
    namesMap.put("YT", "マヨット島");
    namesMap.put("ZA", "南アフリカ");
    namesMap.put("ZM", "ザンビア");
    namesMap.put("ZW", "ジンバブエ");
    namesMap.put("ZZ", "不明な地域");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "世界",
        "002": "アフリカ",
        "003": "北アメリカ大陸",
        "005": "南アメリカ",
        "009": "オセアニア",
        "011": "西アフリカ",
        "013": "中央アメリカ",
        "014": "東アフリカ",
        "015": "北アフリカ",
        "017": "中部アフリカ",
        "018": "南部アフリカ",
        "019": "アメリカ大陸",
        "021": "北アメリカ",
        "029": "カリブ",
        "030": "東アジア",
        "034": "南アジア",
        "035": "東南アジア",
        "039": "南ヨーロッパ",
        "053": "オーストララシア",
        "054": "メラネシア",
        "057": "ミクロネシア",
        "061": "ポリネシア",
        "142": "アジア",
        "143": "中央アジア",
        "145": "西アジア",
        "150": "ヨーロッパ",
        "151": "東ヨーロッパ",
        "154": "北ヨーロッパ",
        "155": "西ヨーロッパ",
        "419": "ラテンアメリカ",
        "AC": "アセンション島",
        "AD": "アンドラ",
        "AE": "アラブ首長国連邦",
        "AF": "アフガニスタン",
        "AG": "アンティグア・バーブーダ",
        "AI": "アンギラ",
        "AL": "アルバニア",
        "AM": "アルメニア",
        "AN": "オランダ領アンティル",
        "AO": "アンゴラ",
        "AQ": "南極",
        "AR": "アルゼンチン",
        "AS": "米領サモア",
        "AT": "オーストリア",
        "AU": "オーストラリア",
        "AW": "アルバ",
        "AX": "オーランド諸島",
        "AZ": "アゼルバイジャン",
        "BA": "ボスニア・ヘルツェゴビナ",
        "BB": "バルバドス",
        "BD": "バングラデシュ",
        "BE": "ベルギー",
        "BF": "ブルキナファソ",
        "BG": "ブルガリア",
        "BH": "バーレーン",
        "BI": "ブルンジ",
        "BJ": "ベナン",
        "BL": "サン・バルテルミー島",
        "BM": "バミューダ",
        "BN": "ブルネイ",
        "BO": "ボリビア",
        "BQ": "オランダ領カリブ",
        "BR": "ブラジル",
        "BS": "バハマ",
        "BT": "ブータン",
        "BV": "ブーベ島",
        "BW": "ボツワナ",
        "BY": "ベラルーシ",
        "BZ": "ベリーズ",
        "CA": "カナダ",
        "CC": "ココス(キーリング)諸島",
        "CD": "コンゴ民主共和国(キンシャサ)",
        "CF": "中央アフリカ共和国",
        "CG": "コンゴ共和国(ブラザビル)",
        "CH": "スイス",
        "CI": "コートジボワール",
        "CK": "クック諸島",
        "CL": "チリ",
        "CM": "カメルーン",
        "CN": "中国",
        "CO": "コロンビア",
        "CP": "クリッパートン島",
        "CR": "コスタリカ",
        "CU": "キューバ",
        "CV": "カーボベルデ",
        "CW": "キュラソー",
        "CX": "クリスマス島",
        "CY": "キプロス",
        "CZ": "チェコ共和国",
        "DE": "ドイツ",
        "DG": "ディエゴガルシア島",
        "DJ": "ジブチ",
        "DK": "デンマーク",
        "DM": "ドミニカ国",
        "DO": "ドミニカ共和国",
        "DZ": "アルジェリア",
        "EA": "セウタ・メリリャ",
        "EC": "エクアドル",
        "EE": "エストニア",
        "EG": "エジプト",
        "EH": "西サハラ",
        "ER": "エリトリア",
        "ES": "スペイン",
        "ET": "エチオピア",
        "EU": "欧州連合",
        "FI": "フィンランド",
        "FJ": "フィジー",
        "FK": "フォークランド諸島",
        "FM": "ミクロネシア連邦",
        "FO": "フェロー諸島",
        "FR": "フランス",
        "GA": "ガボン",
        "GB": "イギリス",
        "GD": "グレナダ",
        "GE": "グルジア",
        "GF": "仏領ギアナ",
        "GG": "ガーンジー",
        "GH": "ガーナ",
        "GI": "ジブラルタル",
        "GL": "グリーンランド",
        "GM": "ガンビア",
        "GN": "ギニア",
        "GP": "グアドループ",
        "GQ": "赤道ギニア",
        "GR": "ギリシャ",
        "GS": "南ジョージア島・南サンドイッチ諸島",
        "GT": "グアテマラ",
        "GU": "グアム",
        "GW": "ギニアビサウ",
        "GY": "ガイアナ",
        "HK": "中華人民共和国香港特別行政区",
        "HM": "ハード島・マクドナルド諸島",
        "HN": "ホンジュラス",
        "HR": "クロアチア",
        "HT": "ハイチ",
        "HU": "ハンガリー",
        "IC": "カナリア諸島",
        "ID": "インドネシア",
        "IE": "アイルランド",
        "IL": "イスラエル",
        "IM": "マン島",
        "IN": "インド",
        "IO": "英領インド洋地域",
        "IQ": "イラク",
        "IR": "イラン",
        "IS": "アイスランド",
        "IT": "イタリア",
        "JE": "ジャージー",
        "JM": "ジャマイカ",
        "JO": "ヨルダン",
        "JP": "日本",
        "KE": "ケニア",
        "KG": "キルギス",
        "KH": "カンボジア",
        "KI": "キリバス",
        "KM": "コモロ",
        "KN": "セントクリストファー・ネイビス",
        "KP": "朝鮮民主主義人民共和国",
        "KR": "大韓民国",
        "KW": "クウェート",
        "KY": "ケイマン諸島",
        "KZ": "カザフスタン",
        "LA": "ラオス",
        "LB": "レバノン",
        "LC": "セントルシア",
        "LI": "リヒテンシュタイン",
        "LK": "スリランカ",
        "LR": "リベリア",
        "LS": "レソト",
        "LT": "リトアニア",
        "LU": "ルクセンブルグ",
        "LV": "ラトビア",
        "LY": "リビア",
        "MA": "モロッコ",
        "MC": "モナコ",
        "MD": "モルドバ",
        "ME": "モンテネグロ",
        "MF": "サン・マルタン",
        "MG": "マダガスカル",
        "MH": "マーシャル諸島",
        "MK": "マケドニア",
        "ML": "マリ",
        "MM": "ミャンマー",
        "MN": "モンゴル",
        "MO": "中華人民共和国マカオ特別行政区",
        "MP": "北マリアナ諸島",
        "MQ": "マルティニーク",
        "MR": "モーリタニア",
        "MS": "モントセラト",
        "MT": "マルタ",
        "MU": "モーリシャス",
        "MV": "モルジブ",
        "MW": "マラウイ",
        "MX": "メキシコ",
        "MY": "マレーシア",
        "MZ": "モザンビーク",
        "NA": "ナミビア",
        "NC": "ニューカレドニア",
        "NE": "ニジェール",
        "NF": "ノーフォーク島",
        "NG": "ナイジェリア",
        "NI": "ニカラグア",
        "NL": "オランダ",
        "NO": "ノルウェー",
        "NP": "ネパール",
        "NR": "ナウル",
        "NU": "ニウエ島",
        "NZ": "ニュージーランド",
        "OM": "オマーン",
        "PA": "パナマ",
        "PE": "ペルー",
        "PF": "仏領ポリネシア",
        "PG": "パプアニューギニア",
        "PH": "フィリピン",
        "PK": "パキスタン",
        "PL": "ポーランド",
        "PM": "サンピエール島・ミクロン島",
        "PN": "ピトケアン諸島",
        "PR": "プエルトリコ",
        "PS": "パレスチナ",
        "PT": "ポルトガル",
        "PW": "パラオ",
        "PY": "パラグアイ",
        "QA": "カタール",
        "QO": "オセアニア周辺地域",
        "RE": "レユニオン島",
        "RO": "ルーマニア",
        "RS": "セルビア",
        "RU": "ロシア",
        "RW": "ルワンダ",
        "SA": "サウジアラビア",
        "SB": "ソロモン諸島",
        "SC": "セーシェル",
        "SD": "スーダン",
        "SE": "スウェーデン",
        "SG": "シンガポール",
        "SH": "セントヘレナ",
        "SI": "スロベニア",
        "SJ": "スバールバル諸島・ヤンマイエン島",
        "SK": "スロバキア",
        "SL": "シエラレオネ",
        "SM": "サンマリノ",
        "SN": "セネガル",
        "SO": "ソマリア",
        "SR": "スリナム",
        "SS": "南スーダン",
        "ST": "サントメ・プリンシペ",
        "SV": "エルサルバドル",
        "SX": "シント・マールテン",
        "SY": "シリア",
        "SZ": "スワジランド",
        "TA": "トリスタン・ダ・クーニャ",
        "TC": "タークス・カイコス諸島",
        "TD": "チャド",
        "TF": "仏領極南諸島",
        "TG": "トーゴ",
        "TH": "タイ",
        "TJ": "タジキスタン",
        "TK": "トケラウ",
        "TL": "東ティモール",
        "TM": "トルクメニスタン",
        "TN": "チュニジア",
        "TO": "トンガ",
        "TR": "トルコ",
        "TT": "トリニダード・トバゴ",
        "TV": "ツバル",
        "TW": "台湾",
        "TZ": "タンザニア",
        "UA": "ウクライナ",
        "UG": "ウガンダ",
        "UM": "米領太平洋諸島",
        "US": "アメリカ合衆国",
        "UY": "ウルグアイ",
        "UZ": "ウズベキスタン",
        "VA": "バチカン市国",
        "VC": "セントビンセント・グレナディーン諸島",
        "VE": "ベネズエラ",
        "VG": "英領ヴァージン諸島",
        "VI": "米領ヴァージン諸島",
        "VN": "ベトナム",
        "VU": "バヌアツ",
        "WF": "ウォリス・フツナ",
        "WS": "サモア",
        "XK": "コソボ",
        "YE": "イエメン",
        "YT": "マヨット島",
        "ZA": "南アフリカ",
        "ZM": "ザンビア",
        "ZW": "ジンバブエ",
        "ZZ": "不明な地域"
    };
  }-*/;
}
