/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.mojo.javacc.UrlUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ForkedJvm {
    private StreamConsumer systemOut;
    private StreamConsumer systemErr;
    private final String executable;
    private File workingDirectory;
    private final Set<String> classPathEntries = new LinkedHashSet<String>();
    private String mainClass;
    private final List<String> cmdLineArgs = new ArrayList<String>();

    public ForkedJvm() {
        this.executable = ForkedJvm.getDefaultExecutable();
    }

    private static String getDefaultExecutable() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file;
    }

    public void setSystemOut(StreamConsumer streamConsumer) {
        this.systemOut = streamConsumer;
    }

    public void setSystemErr(StreamConsumer streamConsumer) {
        this.systemErr = streamConsumer;
    }

    private String getClassPath() {
        return StringUtils.join(this.classPathEntries.iterator(), (String)File.pathSeparator);
    }

    public void addClassPathEntry(String string) {
        if (string != null) {
            this.classPathEntries.add(string);
        }
    }

    public void addClassPathEntry(File file) {
        if (file != null) {
            this.classPathEntries.add(file.getAbsolutePath());
        }
    }

    public void addClassPathEntry(Class<?> clazz) {
        this.addClassPathEntry(ForkedJvm.getClassSource(clazz));
    }

    private static File getClassSource(Class<?> clazz) {
        if (clazz != null) {
            String string = clazz.getName().replace('.', '/') + ".class";
            return ForkedJvm.getResourceSource(string, clazz.getClassLoader());
        }
        return null;
    }

    private static File getClassSource(String string) {
        if (string != null) {
            String string2 = string.replace('.', '/') + ".class";
            return ForkedJvm.getResourceSource(string2, Thread.currentThread().getContextClassLoader());
        }
        return null;
    }

    private static File getResourceSource(String string, ClassLoader classLoader) {
        if (string != null) {
            URL uRL = classLoader != null ? classLoader.getResource(string) : ClassLoader.getSystemResource(string);
            return UrlUtils.getResourceRoot(uRL, string);
        }
        return null;
    }

    public void setMainClass(String string) {
        this.mainClass = string;
        this.addClassPathEntry(ForkedJvm.getClassSource(string));
    }

    public void setMainClass(Class<?> clazz) {
        this.mainClass = clazz != null ? clazz.getName() : null;
        this.addClassPathEntry(clazz);
    }

    private String[] getArguments() {
        return this.cmdLineArgs.toArray(new String[this.cmdLineArgs.size()]);
    }

    public void addArgument(String string) {
        if (string != null) {
            this.cmdLineArgs.add(string);
        }
    }

    public void addArgument(File file) {
        if (file != null) {
            this.cmdLineArgs.add(file.getAbsolutePath());
        }
    }

    public void addArguments(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addArgument(string);
            }
        }
    }

    private Commandline createCommandLine() {
        String string;
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.executable);
        if (this.workingDirectory != null) {
            commandline.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        }
        if ((string = this.getClassPath()) != null && string.length() > 0) {
            commandline.addArguments(new String[]{"-cp", string});
        }
        if (this.mainClass != null && this.mainClass.length() > 0) {
            commandline.addArguments(new String[]{this.mainClass});
        }
        commandline.addArguments(this.getArguments());
        return commandline;
    }

    public int run() throws Exception {
        return CommandLineUtils.executeCommandLine((Commandline)this.createCommandLine(), (StreamConsumer)this.systemOut, (StreamConsumer)this.systemErr);
    }

    public String toString() {
        return String.valueOf(this.createCommandLine());
    }
}

