/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.mojo.javacc.ForkedJvm;
import org.codehaus.mojo.javacc.ToolFacade;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.javacc.jjdoc.JJDocMain;

class JJDoc
extends ToolFacade {
    private File inputFile;
    private File outputFile;
    private String grammarEncoding;
    private String cssHref;
    private Boolean text;
    private Boolean bnf;
    private Boolean oneTable;

    JJDoc() {
    }

    public void setInputFile(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.inputFile = file;
    }

    public void setOutputFile(File file) {
        if (file != null && !file.isAbsolute()) {
            throw new IllegalArgumentException("path is not absolute: " + file);
        }
        this.outputFile = file;
    }

    public void setGrammarEncoding(String string) {
        this.grammarEncoding = string;
    }

    public void setCssHref(String string) {
        this.cssHref = string;
    }

    public void setText(Boolean bl) {
        this.text = bl;
    }

    public void setBnf(Boolean bl) {
        this.bnf = bl;
    }

    public void setOneTable(Boolean bl) {
        this.oneTable = bl;
    }

    protected int execute() throws Exception {
        File file;
        String[] stringArray = this.generateArguments();
        File file2 = file = this.outputFile != null ? this.outputFile.getParentFile() : null;
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        ForkedJvm forkedJvm = new ForkedJvm();
        forkedJvm.setMainClass(JJDocMain.class);
        forkedJvm.addArguments(stringArray);
        forkedJvm.setSystemOut(new MojoLogStreamConsumer(false));
        forkedJvm.setSystemErr(new MojoLogStreamConsumer(true));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Forking: " + forkedJvm));
        }
        return forkedJvm.run();
    }

    private String[] generateArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.grammarEncoding)) {
            arrayList.add("-GRAMMAR_ENCODING=" + this.grammarEncoding);
        }
        if (this.text != null) {
            arrayList.add("-TEXT=" + this.text);
        }
        if (this.bnf != null) {
            arrayList.add("-BNF=" + this.bnf);
        }
        if (this.oneTable != null) {
            arrayList.add("-ONE_TABLE=" + this.oneTable);
        }
        if (this.outputFile != null) {
            arrayList.add("-OUTPUT_FILE=" + this.outputFile.getAbsolutePath());
        }
        if (StringUtils.isNotEmpty((String)this.cssHref)) {
            arrayList.add("-CSS=" + this.cssHref);
        }
        if (this.inputFile != null) {
            arrayList.add(this.inputFile.getAbsolutePath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String toString() {
        return Arrays.asList(this.generateArguments()).toString();
    }

    class MojoLogStreamConsumer
    implements StreamConsumer {
        private static final String ERROR_PREFIX = "Error: ";
        private static final String WARN_PREFIX = "Warning: ";
        private final boolean err;

        public MojoLogStreamConsumer(boolean bl) {
            this.err = bl;
        }

        public void consumeLine(String string) {
            if (string.startsWith(ERROR_PREFIX)) {
                JJDoc.this.getLog().error((CharSequence)string.substring(ERROR_PREFIX.length()));
            } else if (string.startsWith(WARN_PREFIX)) {
                JJDoc.this.getLog().warn((CharSequence)string.substring(WARN_PREFIX.length()));
            } else if (this.err) {
                JJDoc.this.getLog().error((CharSequence)string);
            } else {
                JJDoc.this.getLog().debug((CharSequence)string);
            }
        }
    }
}

