/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javacc.Version;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.parser.Options;
import org.javacc.parser.OtherFilesGenCPP;
import org.javacc.parser.OutputFile;
import org.javacc.utils.JavaFileGenerator;

final class CPPNodeFiles {
    private static List headersForJJTreeH = new ArrayList();
    static final String nodeVersion = Version.majorDotMinor;
    static Set nodesToGenerate = new HashSet();

    private CPPNodeFiles() {
    }

    static void addType(String string) {
        if (!string.equals("Node") && !string.equals("SimpleNode")) {
            nodesToGenerate.add(string);
        }
    }

    public static String nodeIncludeFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), "Node.h").getAbsolutePath();
    }

    public static String jjtreeIncludeFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), JJTreeGlobals.parserName + "Tree.h").getAbsolutePath();
    }

    public static String jjtreeImplFile() {
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), JJTreeGlobals.parserName + "Tree.cc").getAbsolutePath();
    }

    private static String visitorIncludeFile() {
        String string = CPPNodeFiles.visitorClass();
        return new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".h").getAbsolutePath();
    }

    static void generateTreeClasses() {
        CPPNodeFiles.generateNodeHeader();
        CPPNodeFiles.generateTreeInterface();
        CPPNodeFiles.generateTreeImpl();
    }

    private static void generateNodeHeader() {
        File file = new File(CPPNodeFiles.nodeIncludeFile());
        OutputFile outputFile = null;
        try {
            String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
            outputFile = new OutputFile(file, nodeVersion, stringArray);
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(Options.getOptions());
            hashMap.put("PARSER_NAME", JJTreeGlobals.parserName);
            hashMap.put("VISITOR_RETURN_TYPE", CPPNodeFiles.getVisitorReturnType());
            hashMap.put("VISITOR_DATA_TYPE", CPPNodeFiles.getVisitorArgumentType());
            hashMap.put("VISITOR_RETURN_TYPE_VOID", CPPNodeFiles.getVisitorReturnType().equals("void"));
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/Node.h.template", hashMap, false);
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
        finally {
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void generateTreeInterface() {
        File file = new File(CPPNodeFiles.jjtreeIncludeFile());
        OutputFile outputFile = null;
        try {
            boolean bl;
            String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
            outputFile = new OutputFile(file, nodeVersion, stringArray);
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(Options.getOptions());
            hashMap.put("PARSER_NAME", JJTreeGlobals.parserName);
            hashMap.put("VISITOR_RETURN_TYPE", CPPNodeFiles.getVisitorReturnType());
            hashMap.put("VISITOR_DATA_TYPE", CPPNodeFiles.getVisitorArgumentType());
            hashMap.put("VISITOR_RETURN_TYPE_VOID", CPPNodeFiles.getVisitorReturnType().equals("void"));
            PrintWriter printWriter = outputFile.getPrintWriter();
            printWriter.println("#ifndef " + file.getName().replace('.', '_').toUpperCase());
            printWriter.println("#define " + file.getName().replace('.', '_').toUpperCase());
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/TreeIncludeHeader.template", hashMap, false);
            boolean bl2 = bl = Options.stringValue("NAMESPACE").length() > 0;
            if (bl) {
                printWriter.println("namespace " + Options.stringValue("NAMESPACE_OPEN"));
            }
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/SimpleNodeInterface.template", hashMap, false);
            for (String string : nodesToGenerate) {
                hashMap.put("NODE_TYPE", string);
                CPPNodeFiles.generateFile(outputFile, "/templates/cpp/MultiNodeInterface.template", hashMap, false);
            }
            if (bl) {
                printWriter.println(Options.stringValue("NAMESPACE_CLOSE"));
            }
            printWriter.println("#endif ");
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
        finally {
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void generateTreeImpl() {
        File file = new File(CPPNodeFiles.jjtreeImplFile());
        OutputFile outputFile = null;
        try {
            boolean bl;
            String[] stringArray = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
            outputFile = new OutputFile(file, nodeVersion, stringArray);
            outputFile.setToolName("JJTree");
            if (file.exists() && !outputFile.needToWrite) {
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(Options.getOptions());
            hashMap.put("PARSER_NAME", JJTreeGlobals.parserName);
            hashMap.put("VISITOR_RETURN_TYPE", CPPNodeFiles.getVisitorReturnType());
            hashMap.put("VISITOR_DATA_TYPE", CPPNodeFiles.getVisitorArgumentType());
            hashMap.put("VISITOR_RETURN_TYPE_VOID", CPPNodeFiles.getVisitorReturnType().equals("void"));
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/TreeImplHeader.template", hashMap, false);
            boolean bl2 = bl = Options.stringValue("NAMESPACE").length() > 0;
            if (bl) {
                outputFile.getPrintWriter().println("namespace " + Options.stringValue("NAMESPACE_OPEN"));
            }
            CPPNodeFiles.generateFile(outputFile, "/templates/cpp/SimpleNodeImpl.template", hashMap, false);
            for (String string : nodesToGenerate) {
                hashMap.put("NODE_TYPE", string);
                CPPNodeFiles.generateFile(outputFile, "/templates/cpp/MultiNodeImpl.template", hashMap, false);
            }
            if (bl) {
                outputFile.getPrintWriter().println(Options.stringValue("NAMESPACE_CLOSE"));
            }
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
        finally {
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void generatePrologue(PrintWriter printWriter) {
    }

    static String nodeConstants() {
        return JJTreeGlobals.parserName + "TreeConstants";
    }

    static void generateTreeConstants() {
        String string = CPPNodeFiles.nodeConstants();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), string + ".h");
        headersForJJTreeH.add(file.getName());
        try {
            String string2;
            int n;
            boolean bl;
            OutputFile outputFile = new OutputFile(file);
            PrintWriter printWriter = outputFile.getPrintWriter();
            List list = ASTNodeDescriptor.getNodeIds();
            List list2 = ASTNodeDescriptor.getNodeNames();
            CPPNodeFiles.generatePrologue(printWriter);
            printWriter.println("#ifndef " + file.getName().replace('.', '_').toUpperCase());
            printWriter.println("#define " + file.getName().replace('.', '_').toUpperCase());
            printWriter.println("\n#include \"JavaCC.h\"");
            boolean bl2 = bl = Options.stringValue("NAMESPACE").length() > 0;
            if (bl) {
                printWriter.println("namespace " + Options.stringValue("NAMESPACE_OPEN"));
            }
            printWriter.println("  enum {");
            for (n = 0; n < list.size(); ++n) {
                string2 = (String)list.get(n);
                printWriter.println("  " + string2 + " = " + n + ",");
            }
            printWriter.println("};");
            printWriter.println();
            for (n = 0; n < list2.size(); ++n) {
                printWriter.println("  static JAVACC_CHAR_TYPE jjtNodeName_arr_" + n + "[] = ");
                string2 = (String)list2.get(n);
                OtherFilesGenCPP.printCharArray(printWriter, string2);
                printWriter.println(";");
            }
            printWriter.println("  static JAVACC_STRING_TYPE jjtNodeName[] = {");
            for (n = 0; n < list2.size(); ++n) {
                printWriter.println("jjtNodeName_arr_" + n + ", ");
            }
            printWriter.println("  };");
            if (bl) {
                printWriter.println(Options.stringValue("NAMESPACE_CLOSE"));
            }
            printWriter.println("#endif");
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    static String visitorClass() {
        return JJTreeGlobals.parserName + "Visitor";
    }

    private static String getVisitMethodName(String string) {
        StringBuffer stringBuffer = new StringBuffer("visit");
        if (Options.booleanValue("VISITOR_METHOD_NAME_INCLUDES_TYPE_NAME")) {
            stringBuffer.append(Character.toUpperCase(string.charAt(0)));
            for (int i = 1; i < string.length(); ++i) {
                stringBuffer.append(string.charAt(i));
            }
        }
        return stringBuffer.toString();
    }

    private static String getVisitorArgumentType() {
        String string = Options.stringValue("VISITOR_DATA_TYPE");
        return string == null || string.equals("") || string.equals("Object") ? "void *" : string;
    }

    private static String getVisitorReturnType() {
        String string = Options.stringValue("VISITOR_RETURN_TYPE");
        return string == null || string.equals("") || string.equals("Object") ? "void " : string;
    }

    static void generateVisitors() {
        if (!JJTreeOptions.getVisitor()) {
            return;
        }
        try {
            boolean bl;
            String string = CPPNodeFiles.visitorClass();
            File file = new File(CPPNodeFiles.visitorIncludeFile());
            OutputFile outputFile = new OutputFile(file);
            PrintWriter printWriter = outputFile.getPrintWriter();
            CPPNodeFiles.generatePrologue(printWriter);
            printWriter.println("#ifndef " + file.getName().replace('.', '_').toUpperCase().toUpperCase());
            printWriter.println("#define " + file.getName().replace('.', '_').toUpperCase().toUpperCase());
            printWriter.println("\n#include \"JavaCC.h\"");
            printWriter.println("#include \"" + JJTreeGlobals.parserName + "Tree.h" + "\"");
            boolean bl2 = bl = Options.stringValue("NAMESPACE").length() > 0;
            if (bl) {
                printWriter.println("namespace " + Options.stringValue("NAMESPACE_OPEN"));
            }
            CPPNodeFiles.generateVisitorInterface(printWriter);
            CPPNodeFiles.generateDefaultVisitor(printWriter);
            if (bl) {
                printWriter.println(Options.stringValue("NAMESPACE_CLOSE"));
            }
            printWriter.println("#endif");
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    private static void generateVisitorInterface(PrintWriter printWriter) {
        String string = CPPNodeFiles.visitorClass();
        List list = ASTNodeDescriptor.getNodeNames();
        printWriter.println("class " + string);
        printWriter.println("{");
        String string2 = CPPNodeFiles.getVisitorArgumentType();
        String string3 = CPPNodeFiles.getVisitorReturnType();
        if (!JJTreeOptions.getVisitorDataType().equals("")) {
            string2 = JJTreeOptions.getVisitorDataType();
        }
        printWriter.println("  public: virtual " + string3 + " visit(const SimpleNode *node, " + string2 + " data) = 0;");
        if (JJTreeOptions.getMulti()) {
            for (int i = 0; i < list.size(); ++i) {
                String string4 = (String)list.get(i);
                if (string4.equals("void")) continue;
                String string5 = JJTreeOptions.getNodePrefix() + string4;
                printWriter.println("  public: virtual " + string3 + " " + CPPNodeFiles.getVisitMethodName(string5) + "(const " + string5 + " *node, " + string2 + " data) = 0;");
            }
        }
        printWriter.println("  public: virtual ~" + string + "() { }");
        printWriter.println("};");
    }

    static String defaultVisitorClass() {
        return JJTreeGlobals.parserName + "DefaultVisitor";
    }

    private static void generateDefaultVisitor(PrintWriter printWriter) {
        String string = CPPNodeFiles.defaultVisitorClass();
        List list = ASTNodeDescriptor.getNodeNames();
        printWriter.println("class " + string + " : public " + CPPNodeFiles.visitorClass() + " {");
        String string2 = CPPNodeFiles.getVisitorArgumentType();
        String string3 = CPPNodeFiles.getVisitorReturnType();
        printWriter.println("  public:");
        printWriter.println("  virtual " + string3 + " defaultVisit(const SimpleNode *node, " + string2 + " data) = 0;");
        printWriter.println("  virtual " + string3 + " visit(const SimpleNode *node, " + string2 + " data) {");
        printWriter.println("    " + (string3.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
        printWriter.println("  }");
        if (JJTreeOptions.getMulti()) {
            for (int i = 0; i < list.size(); ++i) {
                String string4 = (String)list.get(i);
                if (string4.equals("void")) continue;
                String string5 = JJTreeOptions.getNodePrefix() + string4;
                printWriter.println("  virtual " + string3 + " " + CPPNodeFiles.getVisitMethodName(string5) + "(const " + string5 + " *node, " + string2 + " data) {");
                printWriter.println("    " + (string3.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
                printWriter.println("  }");
            }
        }
        printWriter.println("  public: ~" + string + "() { }");
        printWriter.println("};");
    }

    public static void generateFile(OutputFile outputFile, String string, Map map) throws IOException {
        CPPNodeFiles.generateFile(outputFile, string, map, true);
    }

    public static void generateFile(OutputFile outputFile, String string, Map map, boolean bl) throws IOException {
        PrintWriter printWriter = outputFile.getPrintWriter();
        CPPNodeFiles.generatePrologue(printWriter);
        JavaFileGenerator javaFileGenerator = new JavaFileGenerator(string, map);
        javaFileGenerator.generate(printWriter);
        if (bl) {
            printWriter.close();
        }
    }
}

