/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.javacc.jjtree.ASTBNFAction;
import org.javacc.jjtree.ASTBNFDeclaration;
import org.javacc.jjtree.ASTBNFNodeScope;
import org.javacc.jjtree.ASTBNFNonTerminal;
import org.javacc.jjtree.ASTBNFOneOrMore;
import org.javacc.jjtree.ASTBNFSequence;
import org.javacc.jjtree.ASTBNFTryBlock;
import org.javacc.jjtree.ASTBNFZeroOrMore;
import org.javacc.jjtree.ASTBNFZeroOrOne;
import org.javacc.jjtree.ASTCompilationUnit;
import org.javacc.jjtree.ASTExpansionNodeScope;
import org.javacc.jjtree.ASTGrammar;
import org.javacc.jjtree.ASTJavacodeBody;
import org.javacc.jjtree.ASTLHS;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.ASTProduction;
import org.javacc.jjtree.DefaultJJTreeVisitor;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.JJTreeNode;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.jjtree.JJTreeState;
import org.javacc.jjtree.Node;
import org.javacc.jjtree.NodeFiles;
import org.javacc.jjtree.NodeScope;
import org.javacc.jjtree.SimpleNode;
import org.javacc.jjtree.Token;
import org.javacc.jjtree.TokenUtils;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Options;

public class JavaCodeGenerator
extends DefaultJJTreeVisitor {
    public Object defaultVisit(SimpleNode simpleNode, Object object) {
        this.visit((JJTreeNode)simpleNode, object);
        return null;
    }

    public Object visit(ASTGrammar aSTGrammar, Object object) {
        IO iO = (IO)object;
        iO.println("/*@bgen(jjtree) " + JavaCCGlobals.getIdString(JJTreeGlobals.toolList, new File(iO.getOutputFileName()).getName()) + " */");
        iO.print("/*@egen*/");
        return aSTGrammar.childrenAccept(this, iO);
    }

    public Object visit(ASTBNFAction aSTBNFAction, Object object) {
        IO iO = (IO)object;
        NodeScope nodeScope = NodeScope.getEnclosingNodeScope(aSTBNFAction);
        if (nodeScope != null && !nodeScope.isVoid()) {
            boolean bl = true;
            Node node = aSTBNFAction.getScopingParent(nodeScope);
            JJTreeNode jJTreeNode = aSTBNFAction;
            while (true) {
                Node node2;
                if ((node2 = jJTreeNode.jjtGetParent()) instanceof ASTBNFSequence || node2 instanceof ASTBNFTryBlock) {
                    if (jJTreeNode.getOrdinal() != node2.jjtGetNumChildren() - 1) {
                        bl = false;
                        break;
                    }
                } else if (node2 instanceof ASTBNFZeroOrOne || node2 instanceof ASTBNFZeroOrMore || node2 instanceof ASTBNFOneOrMore) {
                    bl = false;
                    break;
                }
                if (node2 == node) break;
                jJTreeNode = (JJTreeNode)node2;
            }
            if (bl) {
                JavaCodeGenerator.openJJTreeComment(iO, null);
                iO.println();
                this.insertCloseNodeAction(nodeScope, iO, this.getIndentation(aSTBNFAction));
                JavaCodeGenerator.closeJJTreeComment(iO);
            }
        }
        return this.visit((JJTreeNode)aSTBNFAction, (Object)iO);
    }

    public Object visit(ASTBNFDeclaration aSTBNFDeclaration, Object object) {
        IO iO = (IO)object;
        if (!aSTBNFDeclaration.node_scope.isVoid()) {
            String string = "";
            if (TokenUtils.hasTokens(aSTBNFDeclaration)) {
                for (int i = 1; i < aSTBNFDeclaration.getFirstToken().beginColumn; ++i) {
                    string = string + " ";
                }
            } else {
                string = "  ";
            }
            JavaCodeGenerator.openJJTreeComment(iO, aSTBNFDeclaration.node_scope.getNodeDescriptorText());
            iO.println();
            this.insertOpenNodeCode(aSTBNFDeclaration.node_scope, iO, string);
            JavaCodeGenerator.closeJJTreeComment(iO);
        }
        return this.visit((JJTreeNode)aSTBNFDeclaration, (Object)iO);
    }

    public Object visit(ASTBNFNodeScope aSTBNFNodeScope, Object object) {
        IO iO = (IO)object;
        if (aSTBNFNodeScope.node_scope.isVoid()) {
            return this.visit((JJTreeNode)aSTBNFNodeScope, (Object)iO);
        }
        String string = this.getIndentation(aSTBNFNodeScope.expansion_unit);
        JavaCodeGenerator.openJJTreeComment(iO, aSTBNFNodeScope.node_scope.getNodeDescriptor().getDescriptor());
        iO.println();
        this.tryExpansionUnit(aSTBNFNodeScope.node_scope, iO, string, aSTBNFNodeScope.expansion_unit);
        return null;
    }

    public Object visit(ASTCompilationUnit aSTCompilationUnit, Object object) {
        IO iO = (IO)object;
        Token token = aSTCompilationUnit.getFirstToken();
        while (true) {
            if (token == JJTreeGlobals.parserImports && !JJTreeGlobals.nodePackageName.equals("") && !JJTreeGlobals.nodePackageName.equals(JJTreeGlobals.packageName)) {
                iO.getOut().println("");
                iO.getOut().println("import " + JJTreeGlobals.nodePackageName + ".*;");
            }
            if (token == JJTreeGlobals.parserImplements) {
                if (token.image.equals("implements")) {
                    aSTCompilationUnit.print(token, iO);
                    JavaCodeGenerator.openJJTreeComment(iO, null);
                    iO.getOut().print(" " + NodeFiles.nodeConstants() + ", ");
                    JavaCodeGenerator.closeJJTreeComment(iO);
                } else {
                    JavaCodeGenerator.openJJTreeComment(iO, null);
                    iO.getOut().print("implements " + NodeFiles.nodeConstants());
                    JavaCodeGenerator.closeJJTreeComment(iO);
                    aSTCompilationUnit.print(token, iO);
                }
            } else {
                aSTCompilationUnit.print(token, iO);
            }
            if (token == JJTreeGlobals.parserClassBodyStart) {
                JavaCodeGenerator.openJJTreeComment(iO, null);
                JJTreeState.insertParserMembers(iO);
                JavaCodeGenerator.closeJJTreeComment(iO);
            }
            if (token == aSTCompilationUnit.getLastToken()) {
                return null;
            }
            token = token.next;
        }
    }

    public Object visit(ASTExpansionNodeScope aSTExpansionNodeScope, Object object) {
        IO iO = (IO)object;
        String string = this.getIndentation(aSTExpansionNodeScope.expansion_unit);
        JavaCodeGenerator.openJJTreeComment(iO, aSTExpansionNodeScope.node_scope.getNodeDescriptor().getDescriptor());
        iO.println();
        this.insertOpenNodeAction(aSTExpansionNodeScope.node_scope, iO, string);
        this.tryExpansionUnit(aSTExpansionNodeScope.node_scope, iO, string, aSTExpansionNodeScope.expansion_unit);
        ((ASTNodeDescriptor)aSTExpansionNodeScope.jjtGetChild(1)).jjtAccept(this, iO);
        return null;
    }

    public Object visit(ASTJavacodeBody aSTJavacodeBody, Object object) {
        IO iO = (IO)object;
        if (aSTJavacodeBody.node_scope.isVoid()) {
            return this.visit((JJTreeNode)aSTJavacodeBody, (Object)iO);
        }
        Token token = aSTJavacodeBody.getFirstToken();
        String string = "";
        for (int i = 4; i < token.beginColumn; ++i) {
            string = string + " ";
        }
        JavaCodeGenerator.openJJTreeComment(iO, aSTJavacodeBody.node_scope.getNodeDescriptorText());
        iO.println();
        this.insertOpenNodeCode(aSTJavacodeBody.node_scope, iO, string);
        this.tryTokenSequence(aSTJavacodeBody.node_scope, iO, string, token, aSTJavacodeBody.getLastToken());
        return null;
    }

    public Object visit(ASTLHS aSTLHS, Object object) {
        IO iO = (IO)object;
        NodeScope nodeScope = NodeScope.getEnclosingNodeScope(aSTLHS);
        Token token = aSTLHS.getFirstToken();
        Token token2 = aSTLHS.getLastToken();
        Token token3 = token;
        while (token3 != token2.next) {
            TokenUtils.print(token3, iO, "jjtThis", nodeScope.getNodeVariable());
            token3 = token3.next;
        }
        return null;
    }

    public Object visit(JJTreeNode jJTreeNode, Object object) {
        IO iO = (IO)object;
        if (jJTreeNode.getLastToken().next == jJTreeNode.getFirstToken()) {
            return null;
        }
        Token token = jJTreeNode.getFirstToken();
        Token token2 = new Token();
        token2.next = token;
        for (int i = 0; i < jJTreeNode.jjtGetNumChildren(); ++i) {
            JJTreeNode jJTreeNode2 = (JJTreeNode)jJTreeNode.jjtGetChild(i);
            while ((token2 = token2.next) != jJTreeNode2.getFirstToken()) {
                jJTreeNode.print(token2, iO);
            }
            jJTreeNode2.jjtAccept(this, iO);
            token2 = jJTreeNode2.getLastToken();
        }
        while (token2 != jJTreeNode.getLastToken()) {
            token2 = token2.next;
            jJTreeNode.print(token2, iO);
        }
        return null;
    }

    static void openJJTreeComment(IO iO, String string) {
        if (string != null) {
            iO.print("/*@bgen(jjtree) " + string + " */");
        } else {
            iO.print("/*@bgen(jjtree)*/");
        }
    }

    static void closeJJTreeComment(IO iO) {
        iO.print("/*@egen*/");
    }

    String getIndentation(JJTreeNode jJTreeNode) {
        return this.getIndentation(jJTreeNode, 0);
    }

    String getIndentation(JJTreeNode jJTreeNode, int n) {
        String string = "";
        for (int i = n + 1; i < jJTreeNode.getFirstToken().beginColumn; ++i) {
            string = string + " ";
        }
        return string;
    }

    void insertOpenNodeDeclaration(NodeScope nodeScope, IO iO, String string) {
        this.insertOpenNodeCode(nodeScope, iO, string);
    }

    void insertOpenNodeCode(NodeScope nodeScope, IO iO, String string) {
        String string2;
        String string3 = nodeScope.node_descriptor.getNodeType();
        String string4 = JJTreeOptions.getNodeClass().length() > 0 && !JJTreeOptions.getMulti() ? JJTreeOptions.getNodeClass() : string3;
        NodeFiles.ensure(iO, string3);
        iO.print(string + string4 + " " + nodeScope.nodeVar + " = ");
        String string5 = Options.getStatic() ? "null" : "this";
        String string6 = string2 = JJTreeOptions.getNodeUsesParser() ? string5 + ", " : "";
        if (JJTreeOptions.getNodeFactory().equals("*")) {
            iO.println("(" + string4 + ")" + string4 + ".jjtCreate(" + string2 + nodeScope.node_descriptor.getNodeId() + ");");
        } else if (JJTreeOptions.getNodeFactory().length() > 0) {
            iO.println("(" + string4 + ")" + JJTreeOptions.getNodeFactory() + ".jjtCreate(" + string2 + nodeScope.node_descriptor.getNodeId() + ");");
        } else {
            iO.println("new " + string4 + "(" + string2 + nodeScope.node_descriptor.getNodeId() + ");");
        }
        if (nodeScope.usesCloseNodeVar()) {
            iO.println(string + "boolean " + nodeScope.closedVar + " = true;");
        }
        iO.println(string + nodeScope.node_descriptor.openNode(nodeScope.nodeVar));
        if (JJTreeOptions.getNodeScopeHook()) {
            iO.println(string + "jjtreeOpenNodeScope(" + nodeScope.nodeVar + ");");
        }
        if (JJTreeOptions.getTrackTokens()) {
            iO.println(string + nodeScope.nodeVar + ".jjtSetFirstToken(getToken(1));");
        }
    }

    void insertCloseNodeCode(NodeScope nodeScope, IO iO, String string, boolean bl) {
        String string2 = nodeScope.node_descriptor.closeNode(nodeScope.nodeVar);
        iO.println(string + string2);
        if (nodeScope.usesCloseNodeVar() && !bl) {
            iO.println(string + nodeScope.closedVar + " = false;");
        }
        if (JJTreeOptions.getNodeScopeHook()) {
            int n = string2.lastIndexOf(",");
            iO.println(string + "if (jjtree.nodeCreated()) {");
            iO.println(string + " jjtreeCloseNodeScope(" + nodeScope.nodeVar + ");");
            iO.println(string + "}");
        }
        if (JJTreeOptions.getTrackTokens()) {
            iO.println(string + nodeScope.nodeVar + ".jjtSetLastToken(getToken(0));");
        }
    }

    void insertOpenNodeAction(NodeScope nodeScope, IO iO, String string) {
        iO.println(string + "{");
        this.insertOpenNodeCode(nodeScope, iO, string + "  ");
        iO.println(string + "}");
    }

    void insertCloseNodeAction(NodeScope nodeScope, IO iO, String string) {
        iO.println(string + "{");
        this.insertCloseNodeCode(nodeScope, iO, string + "  ", false);
        iO.println(string + "}");
    }

    private void insertCatchBlocks(NodeScope nodeScope, IO iO, Enumeration enumeration, String string) {
        if (enumeration.hasMoreElements()) {
            iO.println(string + "} catch (Throwable " + nodeScope.exceptionVar + ") {");
            if (nodeScope.usesCloseNodeVar()) {
                iO.println(string + "  if (" + nodeScope.closedVar + ") {");
                iO.println(string + "    jjtree.clearNodeScope(" + nodeScope.nodeVar + ");");
                iO.println(string + "    " + nodeScope.closedVar + " = false;");
                iO.println(string + "  } else {");
                iO.println(string + "    jjtree.popNode();");
                iO.println(string + "  }");
            }
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                iO.println(string + "  if (" + nodeScope.exceptionVar + " instanceof " + string2 + ") {");
                iO.println(string + "    throw (" + string2 + ")" + nodeScope.exceptionVar + ";");
                iO.println(string + "  }");
            }
            iO.println(string + "  throw (Error)" + nodeScope.exceptionVar + ";");
        }
    }

    void tryTokenSequence(NodeScope nodeScope, IO iO, String string, Token token, Token token2) {
        iO.println(string + "try {");
        JavaCodeGenerator.closeJJTreeComment(iO);
        Object object = token;
        while (object != token2.next) {
            TokenUtils.print((Token)object, iO, "jjtThis", nodeScope.nodeVar);
            object = ((Token)object).next;
        }
        JavaCodeGenerator.openJJTreeComment(iO, null);
        iO.println();
        object = nodeScope.production.throws_list.elements();
        this.insertCatchBlocks(nodeScope, iO, (Enumeration)object, string);
        iO.println(string + "} finally {");
        if (nodeScope.usesCloseNodeVar()) {
            iO.println(string + "  if (" + nodeScope.closedVar + ") {");
            this.insertCloseNodeCode(nodeScope, iO, string + "    ", true);
            iO.println(string + "  }");
        }
        iO.println(string + "}");
        JavaCodeGenerator.closeJJTreeComment(iO);
    }

    private static void findThrown(NodeScope nodeScope, Hashtable hashtable, JJTreeNode jJTreeNode) {
        String string;
        JJTreeNode jJTreeNode2;
        if (jJTreeNode instanceof ASTBNFNonTerminal && (jJTreeNode2 = (ASTProduction)JJTreeGlobals.productions.get(string = jJTreeNode.getFirstToken().image)) != null) {
            Enumeration enumeration = jJTreeNode2.throws_list.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                hashtable.put(string2, string2);
            }
        }
        for (int i = 0; i < jJTreeNode.jjtGetNumChildren(); ++i) {
            jJTreeNode2 = (JJTreeNode)jJTreeNode.jjtGetChild(i);
            JavaCodeGenerator.findThrown(nodeScope, hashtable, jJTreeNode2);
        }
    }

    void tryExpansionUnit(NodeScope nodeScope, IO iO, String string, JJTreeNode jJTreeNode) {
        iO.println(string + "try {");
        JavaCodeGenerator.closeJJTreeComment(iO);
        jJTreeNode.jjtAccept(this, iO);
        JavaCodeGenerator.openJJTreeComment(iO, null);
        iO.println();
        Hashtable hashtable = new Hashtable();
        JavaCodeGenerator.findThrown(nodeScope, hashtable, jJTreeNode);
        Enumeration enumeration = hashtable.elements();
        this.insertCatchBlocks(nodeScope, iO, enumeration, string);
        iO.println(string + "} finally {");
        if (nodeScope.usesCloseNodeVar()) {
            iO.println(string + "  if (" + nodeScope.closedVar + ") {");
            this.insertCloseNodeCode(nodeScope, iO, string + "    ", true);
            iO.println(string + "  }");
        }
        iO.println(string + "}");
        JavaCodeGenerator.closeJJTreeComment(iO);
    }
}

