/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.javacc.parser.JavaCCErrors;
import org.javacc.utils.OptionInfo;
import org.javacc.utils.OptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    public static final String NONUSER_OPTION__NAMESPACE_CLOSE = "NAMESPACE_CLOSE";
    public static final String NONUSER_OPTION__HAS_NAMESPACE = "HAS_NAMESPACE";
    public static final String NONUSER_OPTION__NAMESPACE_OPEN = "NAMESPACE_OPEN";
    public static final String NONUSER_OPTION__PARSER_NAME = "PARSER_NAME";
    public static final String NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING = "LEGACY_EXCEPTION_HANDLING";
    public static final String USEROPTION__PARSER_SUPER_CLASS = "PARSER_SUPER_CLASS";
    public static final String USEROPTION__JAVA_TEMPLATE_TYPE = "JAVA_TEMPLATE_TYPE";
    public static final String USEROPTION__GENERATE_BOILERPLATE = "GENERATE_BOILERPLATE";
    public static final String USEROPTION__OUTPUT_LANGUAGE = "OUTPUT_LANGUAGE";
    public static final String USEROPTION__STATIC = "STATIC";
    public static final String USEROPTION__TOKEN_MANAGER_SUPER_CLASS = "TOKEN_MANAGER_SUPER_CLASS";
    public static final String USEROPTION__LOOKAHEAD = "LOOKAHEAD";
    public static final String USEROPTION__IGNORE_CASE = "IGNORE_CASE";
    public static final String USEROPTION__UNICODE_INPUT = "UNICODE_INPUT";
    public static final String USEROPTION__JAVA_UNICODE_ESCAPE = "JAVA_UNICODE_ESCAPE";
    public static final String USEROPTION__ERROR_REPORTING = "ERROR_REPORTING";
    public static final String USEROPTION__DEBUG_TOKEN_MANAGER = "DEBUG_TOKEN_MANAGER";
    public static final String USEROPTION__DEBUG_LOOKAHEAD = "DEBUG_LOOKAHEAD";
    public static final String USEROPTION__DEBUG_PARSER = "DEBUG_PARSER";
    public static final String USEROPTION__OTHER_AMBIGUITY_CHECK = "OTHER_AMBIGUITY_CHECK";
    public static final String USEROPTION__CHOICE_AMBIGUITY_CHECK = "CHOICE_AMBIGUITY_CHECK";
    public static final String USEROPTION__CACHE_TOKENS = "CACHE_TOKENS";
    public static final String USEROPTION__COMMON_TOKEN_ACTION = "COMMON_TOKEN_ACTION";
    public static final String USEROPTION__FORCE_LA_CHECK = "FORCE_LA_CHECK";
    public static final String USEROPTION__SANITY_CHECK = "SANITY_CHECK";
    public static final String USEROPTION__TOKEN_MANAGER_USES_PARSER = "TOKEN_MANAGER_USES_PARSER";
    public static final String USEROPTION__BUILD_TOKEN_MANAGER = "BUILD_TOKEN_MANAGER";
    public static final String USEROPTION__BUILD_PARSER = "BUILD_PARSER";
    public static final String USEROPTION__USER_CHAR_STREAM = "USER_CHAR_STREAM";
    public static final String USEROPTION__USER_TOKEN_MANAGER = "USER_TOKEN_MANAGER";
    public static final String USEROPTION__JDK_VERSION = "JDK_VERSION";
    public static final String USEROPTION__SUPPORT_CLASS_VISIBILITY_PUBLIC = "SUPPORT_CLASS_VISIBILITY_PUBLIC";
    public static final String USEROPTION__GENERATE_ANNOTATIONS = "GENERATE_ANNOTATIONS";
    public static final String USEROPTION__GENERATE_STRING_BUILDER = "GENERATE_STRING_BUILDER";
    public static final String USEROPTION__GENERATE_GENERICS = "GENERATE_GENERICS";
    public static final String USEROPTION__GENERATE_CHAINED_EXCEPTION = "GENERATE_CHAINED_EXCEPTION";
    public static final String USEROPTION__OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    public static final String USEROPTION__KEEP_LINE_COLUMN = "KEEP_LINE_COLUMN";
    public static final String USEROPTION__GRAMMAR_ENCODING = "GRAMMAR_ENCODING";
    public static final String USEROPTION__TOKEN_FACTORY = "TOKEN_FACTORY";
    public static final String USEROPTION__TOKEN_EXTENDS = "TOKEN_EXTENDS";
    public static final String USEROPTION_CPP_NAMESPACE = "NAMESPACE";
    public static final String USEROPTION__CPP_TOKEN_INCLUDES = "TOKEN_INCLUDES";
    public static final String USEROPTION__CPP_PARSER_INCLUDES = "PARSER_INCLUDES";
    public static final String USEROPTION__CPP_IGNORE_ACTIONS = "IGNORE_ACTIONS";
    public static final String USEROPTION__CPP_TOKEN_MANAGER_INCLUDES = "TOKEN_MANAGER_INCLUDES";
    public static final String USEROPTION__CPP_TOKEN_MANAGER_SUPERCLASS = "TOKEN_MANAGER_SUPERCLASS";
    public static final String USEROPTION__CPP_STOP_ON_FIRST_ERROR = "STOP_ON_FIRST_ERROR";
    public static final String OUTPUT_LANGUAGE__CPP = "c++";
    public static final String OUTPUT_LANGUAGE__JAVA = "java";
    public static final String JAVA_TEMPLATE_TYPE_MODERN = "modern";
    public static final String JAVA_TEMPLATE_TYPE_CLASSIC = "classic";
    static final Set<OptionInfo> userOptions;
    protected static Map<String, Object> optionValues;
    private static Set<String> cmdLineSetting;
    private static Set<String> inputFileSetting;
    private static final Set<String> supportedJavaTemplateTypes;
    private static final Set<String> supportedLanguages;

    protected Options() {
    }

    public static void init() {
        optionValues = new HashMap<String, Object>();
        cmdLineSetting = new HashSet<String>();
        inputFileSetting = new HashSet<String>();
        for (OptionInfo optionInfo : userOptions) {
            optionValues.put(optionInfo.getName(), optionInfo.getDefault());
        }
        Object object = optionValues.get(USEROPTION__JAVA_TEMPLATE_TYPE);
        boolean bl = JAVA_TEMPLATE_TYPE_CLASSIC.equals(object);
        optionValues.put(NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING, bl);
    }

    public static int intValue(String string) {
        return (Integer)optionValues.get(string);
    }

    public static boolean booleanValue(String string) {
        return (Boolean)optionValues.get(string);
    }

    public static String stringValue(String string) {
        return (String)optionValues.get(string);
    }

    public static Map<String, Object> getOptions() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(optionValues);
        return hashMap;
    }

    public static String getOptionsString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(optionValues.get(string));
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public static String getTokenMgrErrorClass() {
        return Options.isOutputLanguageJava() ? (Options.isLegacyExceptionHandling() ? "TokenMgrError" : "TokenMgrException") : "TokenMgrError";
    }

    public static boolean isOption(String string) {
        return string != null && string.length() > 1 && string.charAt(0) == '-';
    }

    public static Object upgradeValue(String string, Object object) {
        if (string.equalsIgnoreCase("NODE_FACTORY") && object.getClass() == Boolean.class) {
            object = (Boolean)object != false ? "*" : "";
        }
        return object;
    }

    public static void setInputFileOption(Object object, Object object2, String string, Object object3) {
        String string2 = string.toUpperCase();
        if (!optionValues.containsKey(string2)) {
            JavaCCErrors.warning(object, "Bad option name \"" + string + "\".  Option setting will be ignored.");
            return;
        }
        Object object4 = optionValues.get(string2);
        object3 = Options.upgradeValue(string, object3);
        if (object4 != null) {
            boolean bl = string2.equalsIgnoreCase(NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING);
            if (bl || object4.getClass() != object3.getClass() || object3 instanceof Integer && (Integer)object3 <= 0) {
                JavaCCErrors.warning(object2, "Bad option value \"" + object3 + "\" for \"" + string + "\".  Option setting will be ignored.");
                return;
            }
            if (inputFileSetting.contains(string2)) {
                JavaCCErrors.warning(object, "Duplicate option setting for \"" + string + "\" will be ignored.");
                return;
            }
            if (cmdLineSetting.contains(string2)) {
                if (!object4.equals(object3)) {
                    JavaCCErrors.warning(object, "Command line setting of \"" + string + "\" modifies option value in file.");
                }
                return;
            }
        }
        optionValues.put(string2, object3);
        inputFileSetting.add(string2);
        if (string2.equalsIgnoreCase(USEROPTION__JAVA_TEMPLATE_TYPE)) {
            String string3 = (String)object3;
            if (!Options.isValidJavaTemplateType(string3)) {
                JavaCCErrors.warning(object2, "Bad option value \"" + object3 + "\" for \"" + string + "\".  Option setting will be ignored. Valid options : " + Options.getAllValidJavaTemplateTypes());
                return;
            }
            boolean bl = JAVA_TEMPLATE_TYPE_CLASSIC.equals(string3);
            optionValues.put(NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING, bl);
        } else if (string2.equalsIgnoreCase(USEROPTION__OUTPUT_LANGUAGE)) {
            String string4 = (String)object3;
            if (!Options.isValidOutputLanguage(string4)) {
                JavaCCErrors.warning(object2, "Bad option value \"" + object3 + "\" for \"" + string + "\".  Option setting will be ignored. Valid options : " + Options.getAllValidLanguages());
                return;
            }
        } else if (string2.equalsIgnoreCase(USEROPTION_CPP_NAMESPACE)) {
            Options.processCPPNamespaceOption((String)object3);
        }
    }

    private static String getAllValidJavaTemplateTypes() {
        return Arrays.toString(supportedJavaTemplateTypes.toArray(new String[supportedJavaTemplateTypes.size()]));
    }

    private static String getAllValidLanguages() {
        return Arrays.toString(supportedLanguages.toArray(new String[supportedLanguages.size()]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setCmdLineOption(String string) {
        Object object;
        String string2;
        block15: {
            int n;
            String string3;
            block16: {
                string3 = string.charAt(0) == '-' ? string.substring(1) : string;
                int n2 = string3.indexOf(61);
                int n3 = string3.indexOf(58);
                n = n2 < 0 ? n3 : (n3 < 0 ? n2 : (n2 < n3 ? n2 : n3));
                if (n >= 0) break block16;
                string2 = string3.toUpperCase();
                if (optionValues.containsKey(string2)) {
                    object = Boolean.TRUE;
                    break block15;
                } else if (string2.length() > 2 && string2.charAt(0) == 'N' && string2.charAt(1) == 'O') {
                    object = Boolean.FALSE;
                    string2 = string2.substring(2);
                    break block15;
                } else {
                    System.out.println("Warning: Bad option \"" + string + "\" will be ignored.");
                    return;
                }
            }
            string2 = string3.substring(0, n).toUpperCase();
            if (string3.substring(n + 1).equalsIgnoreCase("TRUE")) {
                object = Boolean.TRUE;
            } else if (string3.substring(n + 1).equalsIgnoreCase("FALSE")) {
                object = Boolean.FALSE;
            } else {
                try {
                    int n4 = Integer.parseInt(string3.substring(n + 1));
                    if (n4 <= 0) {
                        System.out.println("Warning: Bad option value in \"" + string + "\" will be ignored.");
                        return;
                    }
                    object = new Integer(n4);
                }
                catch (NumberFormatException numberFormatException) {
                    object = string3.substring(n + 1);
                    if (string3.length() <= n + 2 || string3.charAt(n + 1) != '\"' || string3.charAt(string3.length() - 1) != '\"') break block15;
                    object = string3.substring(n + 2, string3.length() - 1);
                }
            }
        }
        if (!optionValues.containsKey(string2)) {
            System.out.println("Warning: Bad option \"" + string + "\" will be ignored.");
            return;
        }
        Object object2 = optionValues.get(string2);
        if (object.getClass() != object2.getClass()) {
            System.out.println("Warning: Bad option value in \"" + string + "\" will be ignored.");
            return;
        }
        if (cmdLineSetting.contains(string2)) {
            System.out.println("Warning: Duplicate option setting \"" + string + "\" will be ignored.");
            return;
        }
        object = Options.upgradeValue(string2, object);
        optionValues.put(string2, object);
        cmdLineSetting.add(string2);
        if (string2.equalsIgnoreCase(USEROPTION_CPP_NAMESPACE)) {
            Options.processCPPNamespaceOption((String)object);
        }
    }

    public static void normalize() {
        if (Options.getDebugLookahead() && !Options.getDebugParser()) {
            if (cmdLineSetting.contains(USEROPTION__DEBUG_PARSER) || inputFileSetting.contains(USEROPTION__DEBUG_PARSER)) {
                JavaCCErrors.warning("True setting of option DEBUG_LOOKAHEAD overrides false setting of option DEBUG_PARSER.");
            }
            optionValues.put(USEROPTION__DEBUG_PARSER, Boolean.TRUE);
        }
        optionValues.put(USEROPTION__GENERATE_CHAINED_EXCEPTION, Options.jdkVersionAtLeast(1.4));
        optionValues.put(USEROPTION__GENERATE_GENERICS, Options.jdkVersionAtLeast(1.5));
        optionValues.put(USEROPTION__GENERATE_STRING_BUILDER, Options.jdkVersionAtLeast(1.5));
        optionValues.put(USEROPTION__GENERATE_ANNOTATIONS, Options.jdkVersionAtLeast(1.5));
    }

    public static int getLookahead() {
        return Options.intValue(USEROPTION__LOOKAHEAD);
    }

    public static int getChoiceAmbiguityCheck() {
        return Options.intValue(USEROPTION__CHOICE_AMBIGUITY_CHECK);
    }

    public static int getOtherAmbiguityCheck() {
        return Options.intValue(USEROPTION__OTHER_AMBIGUITY_CHECK);
    }

    public static boolean getStatic() {
        return Options.booleanValue(USEROPTION__STATIC);
    }

    public static boolean getDebugParser() {
        return Options.booleanValue(USEROPTION__DEBUG_PARSER);
    }

    public static boolean getDebugLookahead() {
        return Options.booleanValue(USEROPTION__DEBUG_LOOKAHEAD);
    }

    public static boolean getDebugTokenManager() {
        return Options.booleanValue(USEROPTION__DEBUG_TOKEN_MANAGER);
    }

    public static boolean getErrorReporting() {
        return Options.booleanValue(USEROPTION__ERROR_REPORTING);
    }

    public static boolean getJavaUnicodeEscape() {
        return Options.booleanValue(USEROPTION__JAVA_UNICODE_ESCAPE);
    }

    public static boolean getUnicodeInput() {
        return Options.booleanValue(USEROPTION__UNICODE_INPUT);
    }

    public static boolean getIgnoreCase() {
        return Options.booleanValue(USEROPTION__IGNORE_CASE);
    }

    public static boolean getUserTokenManager() {
        return Options.booleanValue(USEROPTION__USER_TOKEN_MANAGER);
    }

    public static boolean getUserCharStream() {
        return Options.booleanValue(USEROPTION__USER_CHAR_STREAM);
    }

    public static boolean getBuildParser() {
        return Options.booleanValue(USEROPTION__BUILD_PARSER);
    }

    public static boolean getBuildTokenManager() {
        return Options.booleanValue(USEROPTION__BUILD_TOKEN_MANAGER);
    }

    public static boolean getTokenManagerUsesParser() {
        return Options.booleanValue(USEROPTION__TOKEN_MANAGER_USES_PARSER);
    }

    public static boolean getSanityCheck() {
        return Options.booleanValue(USEROPTION__SANITY_CHECK);
    }

    public static boolean getForceLaCheck() {
        return Options.booleanValue(USEROPTION__FORCE_LA_CHECK);
    }

    public static boolean getCommonTokenAction() {
        return Options.booleanValue(USEROPTION__COMMON_TOKEN_ACTION);
    }

    public static boolean getCacheTokens() {
        return Options.booleanValue(USEROPTION__CACHE_TOKENS);
    }

    public static boolean getKeepLineColumn() {
        return Options.booleanValue(USEROPTION__KEEP_LINE_COLUMN);
    }

    public static String getJdkVersion() {
        return Options.stringValue(USEROPTION__JDK_VERSION);
    }

    public static boolean getGenerateChainedException() {
        return Options.booleanValue(USEROPTION__GENERATE_CHAINED_EXCEPTION);
    }

    public static boolean isGenerateBoilerplateCode() {
        return Options.booleanValue(USEROPTION__GENERATE_BOILERPLATE);
    }

    public static boolean isLegacyExceptionHandling() {
        boolean bl = Options.booleanValue(NONUSER_OPTION__LEGACY_EXCEPTION_HANDLING);
        return bl;
    }

    public static boolean getGenerateGenerics() {
        return Options.booleanValue(USEROPTION__GENERATE_GENERICS);
    }

    public static boolean getGenerateStringBuilder() {
        return Options.booleanValue(USEROPTION__GENERATE_STRING_BUILDER);
    }

    public static boolean getGenerateAnnotations() {
        return Options.booleanValue(USEROPTION__GENERATE_ANNOTATIONS);
    }

    public static boolean getSupportClassVisibilityPublic() {
        return Options.booleanValue(USEROPTION__SUPPORT_CLASS_VISIBILITY_PUBLIC);
    }

    public static boolean jdkVersionAtLeast(double d) {
        double d2 = Double.parseDouble(Options.getJdkVersion());
        return d2 >= d;
    }

    public static String getTokenExtends() {
        return Options.stringValue(USEROPTION__TOKEN_EXTENDS);
    }

    public static String getTokenFactory() {
        return Options.stringValue(USEROPTION__TOKEN_FACTORY);
    }

    public static String getGrammarEncoding() {
        if (Options.stringValue(USEROPTION__GRAMMAR_ENCODING).equals("")) {
            return System.getProperties().getProperty("file.encoding");
        }
        return Options.stringValue(USEROPTION__GRAMMAR_ENCODING);
    }

    public static File getOutputDirectory() {
        return new File(Options.stringValue(USEROPTION__OUTPUT_DIRECTORY));
    }

    public static String stringBufOrBuild() {
        if (Options.isOutputLanguageJava() && Options.getGenerateStringBuilder()) {
            return Options.getGenerateStringBuilder() ? "StringBuilder" : "StringBuffer";
        }
        if (Options.getOutputLanguage().equals(OUTPUT_LANGUAGE__CPP)) {
            return "StringBuffer";
        }
        throw new RuntimeException("Output language type not fully implemented : " + Options.getOutputLanguage());
    }

    public static boolean isValidOutputLanguage(String string) {
        return string == null ? false : supportedLanguages.contains(string.toLowerCase());
    }

    public static boolean isValidJavaTemplateType(String string) {
        return string == null ? false : supportedJavaTemplateTypes.contains(string.toLowerCase());
    }

    public static String getOutputLanguage() {
        return Options.stringValue(USEROPTION__OUTPUT_LANGUAGE);
    }

    public static String getJavaTemplateType() {
        return Options.stringValue(USEROPTION__JAVA_TEMPLATE_TYPE);
    }

    public static void setStringOption(String string, String string2) {
        optionValues.put(string, string2);
        if (string.equalsIgnoreCase(USEROPTION_CPP_NAMESPACE)) {
            Options.processCPPNamespaceOption(string2);
        }
    }

    public static void processCPPNamespaceOption(String string) {
        String string2 = string;
        if (string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "::");
            String string3 = stringTokenizer.nextToken() + " {";
            String string4 = "}";
            while (stringTokenizer.hasMoreTokens()) {
                string3 = string3 + "\nnamespace " + stringTokenizer.nextToken() + " {";
                string4 = string4 + "\n}";
            }
            optionValues.put(NONUSER_OPTION__NAMESPACE_OPEN, string3);
            optionValues.put(NONUSER_OPTION__HAS_NAMESPACE, Boolean.TRUE);
            optionValues.put(NONUSER_OPTION__NAMESPACE_CLOSE, string4);
        }
    }

    public static String getLongType() {
        if (Options.isOutputLanguageJava()) {
            return "long";
        }
        if (Options.getOutputLanguage().equals(OUTPUT_LANGUAGE__CPP)) {
            return "unsigned long long";
        }
        throw new RuntimeException("Language type not fully supported : " + Options.getOutputLanguage());
    }

    public static String getBooleanType() {
        if (Options.isOutputLanguageJava()) {
            return "boolean";
        }
        if (Options.getOutputLanguage().equals(OUTPUT_LANGUAGE__CPP)) {
            return "bool";
        }
        throw new RuntimeException("Language type not fully supported : " + Options.getOutputLanguage());
    }

    public static boolean isOutputLanguageJava() {
        return Options.getOutputLanguage().equalsIgnoreCase(OUTPUT_LANGUAGE__JAVA);
    }

    public static boolean isOutputLanguageCPP() {
        return Options.getOutputLanguage().equalsIgnoreCase(OUTPUT_LANGUAGE__CPP);
    }

    public static boolean isTokenManagerRequiresParserAccess() {
        return Options.getTokenManagerUsesParser();
    }

    public static Set<OptionInfo> getUserOptions() {
        return userOptions;
    }

    static {
        TreeSet<OptionInfo> treeSet = new TreeSet<OptionInfo>();
        treeSet.add(new OptionInfo(USEROPTION__PARSER_SUPER_CLASS, OptionType.STRING, null));
        treeSet.add(new OptionInfo(USEROPTION__TOKEN_MANAGER_SUPER_CLASS, OptionType.STRING, null));
        treeSet.add(new OptionInfo(USEROPTION__LOOKAHEAD, OptionType.INTEGER, new Integer(1)));
        treeSet.add(new OptionInfo(USEROPTION__CHOICE_AMBIGUITY_CHECK, OptionType.INTEGER, new Integer(2)));
        treeSet.add(new OptionInfo(USEROPTION__OTHER_AMBIGUITY_CHECK, OptionType.INTEGER, new Integer(1)));
        treeSet.add(new OptionInfo(USEROPTION__STATIC, OptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__DEBUG_PARSER, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__DEBUG_LOOKAHEAD, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__DEBUG_TOKEN_MANAGER, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__ERROR_REPORTING, OptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__JAVA_UNICODE_ESCAPE, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__UNICODE_INPUT, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__IGNORE_CASE, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__USER_TOKEN_MANAGER, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__USER_CHAR_STREAM, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__BUILD_PARSER, OptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__BUILD_TOKEN_MANAGER, OptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__TOKEN_MANAGER_USES_PARSER, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__SANITY_CHECK, OptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__FORCE_LA_CHECK, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__COMMON_TOKEN_ACTION, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__CACHE_TOKENS, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__KEEP_LINE_COLUMN, OptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__GENERATE_CHAINED_EXCEPTION, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__GENERATE_GENERICS, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__GENERATE_BOILERPLATE, OptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__GENERATE_STRING_BUILDER, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__GENERATE_ANNOTATIONS, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__SUPPORT_CLASS_VISIBILITY_PUBLIC, OptionType.BOOLEAN, Boolean.TRUE));
        treeSet.add(new OptionInfo(USEROPTION__OUTPUT_DIRECTORY, OptionType.STRING, "."));
        treeSet.add(new OptionInfo(USEROPTION__JDK_VERSION, OptionType.STRING, "1.5"));
        treeSet.add(new OptionInfo(USEROPTION__TOKEN_EXTENDS, OptionType.STRING, ""));
        treeSet.add(new OptionInfo(USEROPTION__TOKEN_FACTORY, OptionType.STRING, ""));
        treeSet.add(new OptionInfo(USEROPTION__GRAMMAR_ENCODING, OptionType.STRING, ""));
        treeSet.add(new OptionInfo(USEROPTION__OUTPUT_LANGUAGE, OptionType.STRING, OUTPUT_LANGUAGE__JAVA));
        treeSet.add(new OptionInfo(USEROPTION__JAVA_TEMPLATE_TYPE, OptionType.STRING, JAVA_TEMPLATE_TYPE_CLASSIC));
        treeSet.add(new OptionInfo(USEROPTION_CPP_NAMESPACE, OptionType.STRING, ""));
        treeSet.add(new OptionInfo(USEROPTION__CPP_TOKEN_INCLUDES, OptionType.STRING, ""));
        treeSet.add(new OptionInfo(USEROPTION__CPP_PARSER_INCLUDES, OptionType.STRING, ""));
        treeSet.add(new OptionInfo(USEROPTION__CPP_TOKEN_MANAGER_INCLUDES, OptionType.STRING, ""));
        treeSet.add(new OptionInfo(USEROPTION__CPP_IGNORE_ACTIONS, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__CPP_STOP_ON_FIRST_ERROR, OptionType.BOOLEAN, Boolean.FALSE));
        treeSet.add(new OptionInfo(USEROPTION__CPP_TOKEN_MANAGER_SUPERCLASS, OptionType.STRING, ""));
        userOptions = Collections.unmodifiableSet(treeSet);
        optionValues = null;
        cmdLineSetting = null;
        inputFileSetting = null;
        supportedJavaTemplateTypes = new HashSet<String>();
        supportedJavaTemplateTypes.add(JAVA_TEMPLATE_TYPE_CLASSIC);
        supportedJavaTemplateTypes.add(JAVA_TEMPLATE_TYPE_MODERN);
        supportedLanguages = new HashSet<String>();
        supportedLanguages.add(OUTPUT_LANGUAGE__JAVA);
        supportedLanguages.add(OUTPUT_LANGUAGE__CPP);
    }
}

