/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.IObsCredentialsProvider;
import com.obs.services.internal.security.EcsSecurityUtils;
import com.obs.services.internal.security.LimitedTimeSecurityKey;
import com.obs.services.internal.security.SecurityKey;
import com.obs.services.internal.security.SecurityKeyBean;
import com.obs.services.model.ISecurityKey;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class EcsObsCredentialsProvider
implements IObsCredentialsProvider {
    private volatile LimitedTimeSecurityKey securityKey;
    private AtomicBoolean getNewKeyFlag = new AtomicBoolean(false);

    public void setSecurityKey(ISecurityKey securityKey) {
        throw new UnsupportedOperationException("EcsObsCredentialsProvider class does not support this method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISecurityKey getSecurityKey() {
        if (this.securityKey == null || this.securityKey.willSoonExpire()) {
            EcsObsCredentialsProvider ecsObsCredentialsProvider = this;
            synchronized (ecsObsCredentialsProvider) {
                if (this.securityKey == null || this.securityKey.willSoonExpire()) {
                    this.securityKey = this.getNewSecurityKey();
                }
            }
        } else if (this.securityKey.aboutToExpire()) {
            this.refresh();
        }
        return this.securityKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (this.getNewKeyFlag.compareAndSet(false, true)) {
            try {
                this.securityKey = this.getNewSecurityKey();
                Object var2_1 = null;
                this.getNewKeyFlag.set(false);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.getNewKeyFlag.set(false);
                throw throwable;
            }
        }
    }

    private LimitedTimeSecurityKey getNewSecurityKey() {
        SecurityKey securityInfo = null;
        try {
            securityInfo = EcsSecurityUtils.getSecurityKey();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Get securityKey form ECS failed :" + e.getMessage());
        }
        if (securityInfo == null) {
            throw new IllegalArgumentException("Invalid securityKey");
        }
        Date expiryDate = new Date();
        SecurityKeyBean bean = securityInfo.getBean();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
            expiryDate = df.parse(bean.getExpiresDate());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Date parse failed :" + e.getMessage());
        }
        return new LimitedTimeSecurityKey(bean.getAccessKey(), bean.getSecretKey(), bean.getSecurityToken(), expiryDate);
    }
}

