/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import com.obs.services.internal.security.BasicSecurityKey;
import java.util.Calendar;
import java.util.Date;

public class LimitedTimeSecurityKey
extends BasicSecurityKey {
    protected String accessKey;
    protected String secretKey;
    protected String securityToken;
    protected Date expiryDate;
    private final long expirySeconds = 300L;
    private final long willSoonExpireSeconds = 60L;

    public LimitedTimeSecurityKey(String accessKey, String secretKey, String securityToken) {
        super(accessKey, secretKey, securityToken);
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.securityToken = securityToken;
        this.expiryDate = LimitedTimeSecurityKey.getUtcTime();
    }

    public LimitedTimeSecurityKey(String accessKey, String secretKey, String securityToken, Date expiryDate) {
        super(accessKey, secretKey, securityToken);
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.securityToken = securityToken;
        this.expiryDate = expiryDate;
    }

    public boolean aboutToExpire() {
        return this.expiryDate.getTime() - LimitedTimeSecurityKey.getUtcTime().getTime() >= 60000L && this.expiryDate.getTime() - LimitedTimeSecurityKey.getUtcTime().getTime() < 300000L;
    }

    public boolean willSoonExpire() {
        return this.expiryDate.before(LimitedTimeSecurityKey.getUtcTime()) || this.expiryDate.getTime() - LimitedTimeSecurityKey.getUtcTime().getTime() < 60000L;
    }

    private static Date getUtcTime() {
        Calendar calendar = Calendar.getInstance();
        int offset = calendar.get(15);
        calendar.add(14, -offset);
        return calendar.getTime();
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }
}

