/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.BasicObsCredentialsProvider;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.model.AuthTypeEnum;

public class ProviderCredentials {
    protected static final ILogger log = LoggerBuilder.getLogger(ProviderCredentials.class);
    protected AuthTypeEnum authType;
    private ThreadLocal<AuthTypeEnum> threadLocalAuthType;
    private IObsCredentialsProvider obsCredentialsProvider;

    public String getRegion() {
        return "region";
    }

    public ProviderCredentials(String accessKey, String secretKey) {
        this.setObsCredentialsProvider(new BasicObsCredentialsProvider(accessKey, secretKey));
    }

    public ProviderCredentials(String accessKey, String secretKey, String securityToken) {
        this.setObsCredentialsProvider(new BasicObsCredentialsProvider(accessKey, secretKey, securityToken));
    }

    public AuthTypeEnum getAuthType() {
        return this.threadLocalAuthType == null ? this.authType : this.threadLocalAuthType.get();
    }

    public void setAuthType(AuthTypeEnum authType) {
        this.authType = authType;
    }

    public void setObsCredentialsProvider(IObsCredentialsProvider ObsCredentialsProvider) {
        this.obsCredentialsProvider = ObsCredentialsProvider;
    }

    public IObsCredentialsProvider getObsCredentialsProvider() {
        return this.obsCredentialsProvider;
    }

    public BasicSecurityKey getSecurityKey() {
        return (BasicSecurityKey)this.obsCredentialsProvider.getSecurityKey();
    }

    public void setThreadLocalAuthType(AuthTypeEnum authType) {
        if (this.threadLocalAuthType != null) {
            this.threadLocalAuthType.set(authType);
        }
    }

    public void removeThreadLocalAuthType() {
        if (this.threadLocalAuthType != null) {
            this.threadLocalAuthType.remove();
        }
    }

    public void initThreadLocalAuthType() {
        if (this.threadLocalAuthType == null) {
            this.threadLocalAuthType = new ThreadLocal<AuthTypeEnum>(){

                @Override
                protected AuthTypeEnum initialValue() {
                    return ProviderCredentials.this.authType;
                }
            };
        }
    }
}

