/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.security.ProviderCredentialThreadContext;
import com.obs.services.internal.security.ProviderCredentials;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketLocationResponse;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketPolicyResponse;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.OptionsInfoRequest;
import com.obs.services.model.OptionsInfoResult;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.WebsiteConfiguration;
import java.util.List;

public abstract class SecretFlexibleBucketObsClient
extends ObsClient {
    public SecretFlexibleBucketObsClient(ObsConfiguration config) {
        this("", "", config);
    }

    public SecretFlexibleBucketObsClient(String endPoint) {
        this("", "", endPoint);
    }

    public SecretFlexibleBucketObsClient(String accessKey, String secretKey, ObsConfiguration config) {
        super(accessKey, secretKey, config);
    }

    public SecretFlexibleBucketObsClient(String accessKey, String secretKey, String endPoint) {
        super(accessKey, secretKey, endPoint);
    }

    public SecretFlexibleBucketObsClient(String accessKey, String secretKey, String securityToken, ObsConfiguration config) {
        super(accessKey, secretKey, securityToken, config);
    }

    public SecretFlexibleBucketObsClient(String accessKey, String secretKey, String securityToken, String endPoint) {
        super(accessKey, secretKey, securityToken, endPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObsBucket createBucket(ObsBucket bucket, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucket.getBucketName(), accessKey, secretKey);
        try {
            ObsBucket obsBucket = super.createBucket(bucket);
            return obsBucket;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObsBucket createBucket(ObsBucket bucket, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucket.getBucketName(), accessKey, secretKey, securityToken);
        try {
            ObsBucket obsBucket = super.createBucket(bucket);
            return obsBucket;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObsBucket createBucket(CreateBucketRequest createBucketRequest, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(createBucketRequest.getBucketName(), accessKey, secretKey);
        try {
            ObsBucket obsBucket = super.createBucket(createBucketRequest);
            return obsBucket;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObsBucket createBucket(CreateBucketRequest createBucketRequest, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(createBucketRequest.getBucketName(), accessKey, secretKey, securityToken);
        try {
            ObsBucket obsBucket = super.createBucket(createBucketRequest);
            return obsBucket;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObsBucket> listBuckets(String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials("", accessKey, secretKey);
        try {
            List<ObsBucket> list = super.listBuckets(null);
            return list;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObsBucket> listBuckets(String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials("", accessKey, secretKey, securityToken);
        try {
            List<ObsBucket> list = super.listBuckets(null);
            return list;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObsBucket> listBuckets(ListBucketsRequest request, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials("", accessKey, secretKey);
        try {
            List<ObsBucket> list = super.listBuckets(request);
            return list;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObsBucket> listBuckets(ListBucketsRequest request, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials("", accessKey, secretKey, securityToken);
        try {
            List<ObsBucket> list = super.listBuckets(request);
            return list;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucket(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucket(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucket(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucket(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean headBucket(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            boolean bl = super.headBucket(bucketName);
            return bl;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean headBucket(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            boolean bl = super.headBucket(bucketName);
            return bl;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketMetadataInfoResult getBucketMetadata(BucketMetadataInfoRequest bucketMetadataInfoRequest, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketMetadataInfoRequest.getBucketName(), accessKey, secretKey);
        try {
            BucketMetadataInfoResult bucketMetadataInfoResult = super.getBucketMetadata(bucketMetadataInfoRequest);
            return bucketMetadataInfoResult;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketMetadataInfoResult getBucketMetadata(BucketMetadataInfoRequest bucketMetadataInfoRequest, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketMetadataInfoRequest.getBucketName(), accessKey, secretKey, securityToken);
        try {
            BucketMetadataInfoResult bucketMetadataInfoResult = super.getBucketMetadata(bucketMetadataInfoRequest);
            return bucketMetadataInfoResult;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlList getBucketAcl(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            AccessControlList accessControlList = super.getBucketAcl(bucketName);
            return accessControlList;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlList getBucketAcl(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            AccessControlList accessControlList = super.getBucketAcl(bucketName);
            return accessControlList;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketAcl(String bucketName, String cannedACL, AccessControlList acl, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketAcl(bucketName, cannedACL, acl);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketAcl(String bucketName, String cannedACL, AccessControlList acl, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketAcl(bucketName, cannedACL, acl);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketAcl(String bucketName, AccessControlList acl, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketAcl(bucketName, acl);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketAcl(String bucketName, AccessControlList acl, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketAcl(bucketName, acl);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketLocationResponse getBucketLocation(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketLocationResponse bucketLocationResponse = super.getBucketLocationV2(bucketName);
            return bucketLocationResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketLocationResponse getBucketLocation(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketLocationResponse bucketLocationResponse = super.getBucketLocationV2(bucketName);
            return bucketLocationResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketStorageInfo getBucketStorageInfo(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketStorageInfo bucketStorageInfo = super.getBucketStorageInfo(bucketName);
            return bucketStorageInfo;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketStorageInfo getBucketStorageInfo(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketStorageInfo bucketStorageInfo = super.getBucketStorageInfo(bucketName);
            return bucketStorageInfo;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketQuota getBucketQuota(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketQuota bucketQuota = super.getBucketQuota(bucketName);
            return bucketQuota;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketQuota getBucketQuota(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketQuota bucketQuota = super.getBucketQuota(bucketName);
            return bucketQuota;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketQuota(String bucketName, BucketQuota bucketQuota, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketQuota(bucketName, bucketQuota);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketQuota(String bucketName, BucketQuota bucketQuota, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketQuota(bucketName, bucketQuota);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketCors(String bucketName, BucketCors bucketCors, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketCors(bucketName, bucketCors);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketCors(String bucketName, BucketCors bucketCors, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketCors(bucketName, bucketCors);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketCors getBucketCors(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketCors bucketCors = super.getBucketCors(bucketName);
            return bucketCors;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketCors getBucketCors(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketCors bucketCors = super.getBucketCors(bucketName);
            return bucketCors;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketCors(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucketCors(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketCors(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucketCors(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public OptionsInfoResult optionsBucket(String bucketName, OptionsInfoRequest optionInfo, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            OptionsInfoResult optionsInfoResult = super.optionsBucket(bucketName, optionInfo);
            return optionsInfoResult;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public OptionsInfoResult optionsBucket(String bucketName, OptionsInfoRequest optionInfo, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            OptionsInfoResult optionsInfoResult = super.optionsBucket(bucketName, optionInfo);
            return optionsInfoResult;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketLoggingConfiguration bucketLoggingConfiguration = super.getBucketLoggingConfiguration(bucketName);
            return bucketLoggingConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketLoggingConfiguration getBucketLogging(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketLoggingConfiguration bucketLoggingConfiguration = super.getBucketLogging(bucketName);
            return bucketLoggingConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketLoggingConfiguration bucketLoggingConfiguration = super.getBucketLoggingConfiguration(bucketName);
            return bucketLoggingConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketLoggingConfiguration getBucketLogging(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketLoggingConfiguration bucketLoggingConfiguration = super.getBucketLogging(bucketName);
            return bucketLoggingConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration loggingConfiguration, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketLoggingConfiguration(bucketName, loggingConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketLogging(String bucketName, BucketLoggingConfiguration loggingConfiguration, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketLogging(bucketName, loggingConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration loggingConfiguration, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketLoggingConfiguration(bucketName, loggingConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketLogging(String bucketName, BucketLoggingConfiguration loggingConfiguration, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketLogging(bucketName, loggingConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration loggingConfiguration, boolean updateTargetACLifRequired, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketLoggingConfiguration(bucketName, loggingConfiguration, updateTargetACLifRequired);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration loggingConfiguration, boolean updateTargetACLifRequired, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketLoggingConfiguration(bucketName, loggingConfiguration, updateTargetACLifRequired);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketVersioning(String bucketName, BucketVersioningConfiguration versioningConfiguration, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketVersioning(bucketName, versioningConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketVersioning(String bucketName, BucketVersioningConfiguration versioningConfiguration, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketVersioning(bucketName, versioningConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketVersioningConfiguration getBucketVersioning(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketVersioningConfiguration bucketVersioningConfiguration = super.getBucketVersioning(bucketName);
            return bucketVersioningConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketVersioningConfiguration getBucketVersioning(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketVersioningConfiguration bucketVersioningConfiguration = super.getBucketVersioning(bucketName);
            return bucketVersioningConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public LifecycleConfiguration getBucketLifecycleConfiguration(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            LifecycleConfiguration lifecycleConfiguration = super.getBucketLifecycleConfiguration(bucketName);
            return lifecycleConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LifecycleConfiguration getBucketLifecycle(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            LifecycleConfiguration lifecycleConfiguration = super.getBucketLifecycle(bucketName);
            return lifecycleConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public LifecycleConfiguration getBucketLifecycleConfiguration(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            LifecycleConfiguration lifecycleConfiguration = super.getBucketLifecycleConfiguration(bucketName);
            return lifecycleConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LifecycleConfiguration getBucketLifecycle(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            LifecycleConfiguration lifecycleConfiguration = super.getBucketLifecycle(bucketName);
            return lifecycleConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketLifecycleConfiguration(String bucketName, LifecycleConfiguration lifecycleConfig, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketLifecycleConfiguration(bucketName, lifecycleConfig);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketLifecycle(String bucketName, LifecycleConfiguration lifecycleConfig, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketLifecycle(bucketName, lifecycleConfig);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketLifecycleConfiguration(String bucketName, LifecycleConfiguration lifecycleConfig, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketLifecycleConfiguration(bucketName, lifecycleConfig);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketLifecycle(String bucketName, LifecycleConfiguration lifecycleConfig, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketLifecycle(bucketName, lifecycleConfig);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse deleteBucketLifecycleConfiguration(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucketLifecycleConfiguration(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketLifecycle(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucketLifecycle(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse deleteBucketLifecycleConfiguration(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucketLifecycleConfiguration(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketLifecycle(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucketLifecycle(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketPolicyResponse getBucketPolicy(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketPolicyResponse bucketPolicyResponse = super.getBucketPolicyV2(bucketName);
            return bucketPolicyResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketPolicyResponse getBucketPolicy(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketPolicyResponse bucketPolicyResponse = super.getBucketPolicyV2(bucketName);
            return bucketPolicyResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketPolicy(String bucketName, String policy, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketPolicy(bucketName, policy);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketPolicy(String bucketName, String policy, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketPolicy(bucketName, policy);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketPolicy(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucketPolicy(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketPolicy(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucketPolicy(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public WebsiteConfiguration getBucketWebsiteConfiguration(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            WebsiteConfiguration websiteConfiguration = super.getBucketWebsiteConfiguration(bucketName);
            return websiteConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebsiteConfiguration getBucketWebsite(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            WebsiteConfiguration websiteConfiguration = super.getBucketWebsite(bucketName);
            return websiteConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public WebsiteConfiguration getBucketWebsiteConfiguration(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            WebsiteConfiguration websiteConfiguration = super.getBucketWebsiteConfiguration(bucketName);
            return websiteConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebsiteConfiguration getBucketWebsite(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            WebsiteConfiguration websiteConfiguration = super.getBucketWebsite(bucketName);
            return websiteConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketWebsiteConfiguration(String bucketName, WebsiteConfiguration websiteConfig, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketWebsiteConfiguration(bucketName, websiteConfig);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketWebsite(String bucketName, WebsiteConfiguration websiteConfig, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketWebsite(bucketName, websiteConfig);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketWebsiteConfiguration(String bucketName, WebsiteConfiguration websiteConfig, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketWebsiteConfiguration(bucketName, websiteConfig);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketWebsite(String bucketName, WebsiteConfiguration websiteConfig, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketWebsite(bucketName, websiteConfig);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse deleteBucketWebsiteConfiguration(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucketWebsiteConfiguration(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketWebsite(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucketWebsite(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse deleteBucketWebsiteConfiguration(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucketWebsiteConfiguration(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketWebsite(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucketWebsite(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketTagging(String bucketName, BucketTagInfo bucketTagInfo, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketTagging(bucketName, bucketTagInfo);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketTagging(String bucketName, BucketTagInfo bucketTagInfo, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketTagging(bucketName, bucketTagInfo);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketTagInfo getBucketTagging(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketTagInfo bucketTagInfo = super.getBucketTagging(bucketName);
            return bucketTagInfo;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketTagInfo getBucketTagging(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketTagInfo bucketTagInfo = super.getBucketTagging(bucketName);
            return bucketTagInfo;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketTagging(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucketTagging(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketTagging(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucketTagging(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketReplicationConfiguration(String bucketName, ReplicationConfiguration replicationConfiguration, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketReplicationConfiguration(bucketName, replicationConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketReplication(String bucketName, ReplicationConfiguration replicationConfiguration, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketReplication(bucketName, replicationConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse setBucketReplicationConfiguration(String bucketName, ReplicationConfiguration replicationConfiguration, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketReplicationConfiguration(bucketName, replicationConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketReplication(String bucketName, ReplicationConfiguration replicationConfiguration, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketReplication(bucketName, replicationConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ReplicationConfiguration getBucketReplicationConfiguration(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            ReplicationConfiguration replicationConfiguration = super.getBucketReplicationConfiguration(bucketName);
            return replicationConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationConfiguration getBucketReplication(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            ReplicationConfiguration replicationConfiguration = super.getBucketReplication(bucketName);
            return replicationConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ReplicationConfiguration getBucketReplicationConfiguration(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            ReplicationConfiguration replicationConfiguration = super.getBucketReplicationConfiguration(bucketName);
            return replicationConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationConfiguration getBucketReplication(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            ReplicationConfiguration replicationConfiguration = super.getBucketReplication(bucketName);
            return replicationConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse deleteBucketReplicationConfiguration(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucketReplicationConfiguration(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketReplication(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.deleteBucketReplication(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HeaderResponse deleteBucketReplicationConfiguration(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucketReplicationConfiguration(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse deleteBucketReplication(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.deleteBucketReplication(bucketName);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketNotificationConfiguration getBucketNotification(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketNotificationConfiguration bucketNotificationConfiguration = super.getBucketNotification(bucketName);
            return bucketNotificationConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketNotificationConfiguration getBucketNotification(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketNotificationConfiguration bucketNotificationConfiguration = super.getBucketNotification(bucketName);
            return bucketNotificationConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketNotification(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketNotification(bucketName, bucketNotificationConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketNotification(String bucketName, BucketNotificationConfiguration bucketNotificationConfiguration, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketNotification(bucketName, bucketNotificationConfiguration);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketStoragePolicy(String bucketName, BucketStoragePolicyConfiguration bucketStorage, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            HeaderResponse headerResponse = super.setBucketStoragePolicy(bucketName, bucketStorage);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderResponse setBucketStoragePolicy(String bucketName, BucketStoragePolicyConfiguration bucketStorage, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            HeaderResponse headerResponse = super.setBucketStoragePolicy(bucketName, bucketStorage);
            return headerResponse;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketStoragePolicyConfiguration getBucketStoragePolicy(String bucketName, String accessKey, String secretKey) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey);
        try {
            BucketStoragePolicyConfiguration bucketStoragePolicyConfiguration = super.getBucketStoragePolicy(bucketName);
            return bucketStoragePolicyConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketStoragePolicyConfiguration getBucketStoragePolicy(String bucketName, String accessKey, String secretKey, String securityToken) throws ObsException {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, securityToken);
        try {
            BucketStoragePolicyConfiguration bucketStoragePolicyConfiguration = super.getBucketStoragePolicy(bucketName);
            return bucketStoragePolicyConfiguration;
        }
        finally {
            this.clearContextProviderCredentials();
        }
    }

    protected void setContextProviderCredentials(String bucketName, String accessKey, String secretKey, String securityToken) {
        ProviderCredentials providerCredentials = new ProviderCredentials(accessKey, secretKey, securityToken);
        providerCredentials.setIsAuthTypeNegotiation(this.getProviderCredentials().getIsAuthTypeNegotiation());
        providerCredentials.setAuthType(this.getProviderCredentials().getLocalAuthType(bucketName));
        ProviderCredentialThreadContext.getInstance().setProviderCredentials(providerCredentials);
    }

    protected void setContextProviderCredentials(String bucketName, String accessKey, String secretKey) {
        this.setContextProviderCredentials(bucketName, accessKey, secretKey, null);
    }

    protected void clearContextProviderCredentials() {
        ProviderCredentialThreadContext.getInstance().clearProviderCredentials();
    }
}

