/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.task;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.AbstractClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.task.AbstractTaskCallable;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.UploadFileRequest;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class UploadFileTask
extends AbstractTaskCallable<CompleteMultipartUploadResult> {
    private UploadFileRequest taskRequest;
    private TaskCallback<CompleteMultipartUploadResult, UploadFileRequest> completeCallback;
    private Future<?> resultFuture;
    private static final ILogger log = LoggerBuilder.getLogger(UploadFileTask.class);

    public UploadFileTask(AbstractClient obsClient, String bucketName, UploadFileRequest taskRequest, TaskCallback<CompleteMultipartUploadResult, UploadFileRequest> completeCallback) {
        super(obsClient, bucketName);
        this.taskRequest = taskRequest;
        this.completeCallback = completeCallback;
    }

    public Optional<CompleteMultipartUploadResult> getResult() {
        try {
            Object result = this.resultFuture.get();
            if (result instanceof CompleteMultipartUploadResult) {
                return Optional.of((CompleteMultipartUploadResult)result);
            }
            String errorMsg = "UploadFileTask Error, result is " + (result != null ? "not instance of CompleteMultipartUploadResult!" : "null");
            errorMsg = errorMsg + (this.taskRequest.getCancelHandler() != null && this.taskRequest.getCancelHandler().isCancelled() ? ", uploadFileRequest is canceled." : "");
            log.error(errorMsg);
            return Optional.empty();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("UploadFileTask Error:", e);
            return Optional.empty();
        }
    }

    public void setResultFuture(Future<?> future) {
        this.resultFuture = future;
    }

    public boolean cancel() {
        if (this.taskRequest.getCancelHandler() != null) {
            this.taskRequest.getCancelHandler().cancel();
            return true;
        }
        String errorInfo = "UploadFileTask Cancel Error: CancelHandler is null, can not cancel!";
        log.error(errorInfo);
        return false;
    }

    protected CompleteMultipartUploadResult uploadFileWithCallBack() {
        try {
            CompleteMultipartUploadResult uploadFileResult = this.getObsClient().uploadFile(this.taskRequest);
            this.completeCallback.onSuccess(uploadFileResult);
            return uploadFileResult;
        }
        catch (ObsException e) {
            this.completeCallback.onException(e, this.taskRequest);
        }
        catch (Throwable t) {
            this.completeCallback.onException(ServiceUtils.changeFromThrowable(t), this.taskRequest);
        }
        return null;
    }

    public boolean isTaskFinished() {
        return this.resultFuture.isDone();
    }

    public void waitUntilFinished() {
        try {
            this.resultFuture.get();
        }
        catch (Throwable t) {
            log.warn("UploadFileTask waitUntilFinished Error:", t);
        }
    }

    public Object call() throws Exception {
        return this.uploadFileWithCallBack();
    }
}

