/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.Checksum;

public class CRC64
implements Checksum,
Serializable {
    private static final long serialVersionUID = 5684087791018577616L;
    private static final ILogger log;
    private static final long POLY = -3932672073523589310L;
    private static final long[][] CRC64_TABLE;
    private long value;
    private static final int GF2_DIM = 64;
    private static final long[] EVEN_SQUARE;
    private static final long[] ODD_SQUARE;

    public CRC64(CRC64 origin) {
        this.value = origin.value;
    }

    public CRC64() {
        this.value = 0L;
    }

    public CRC64(long value) {
        this.value = value;
    }

    public CRC64(byte[] b, int len) {
        this.value = 0L;
        this.update(b, len);
    }

    public CRC64(byte[] b, int off, int len) {
        this.value = 0L;
        this.update(b, off, len);
    }

    public static CRC64 fromFile(File f) throws IOException {
        return CRC64.fromInputStream(new FileInputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CRC64 fromInputStream(InputStream in) throws IOException {
        try {
            int l;
            CRC64 crc = new CRC64();
            byte[] b = new byte[4096];
            while ((l = in.read(b)) != -1) {
                crc.update(b, l);
            }
            CRC64 cRC64 = crc;
            return cRC64;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CRC64 fromInputStream(InputStream in, long offset, long sizeToReadTotal) throws IOException {
        try {
            int l;
            long skippedSize = in.skip(offset);
            if (skippedSize != offset) {
                String errorInfo = "Failed to skip the input stream to the specified offset:" + offset + ". actual skip size is " + skippedSize;
                log.error(errorInfo);
                throw new IOException(errorInfo);
            }
            CRC64 crc = new CRC64();
            int bufferSize = 4096;
            byte[] b = new byte[bufferSize];
            long sizeToRead = Long.min(sizeToReadTotal, bufferSize);
            while (sizeToRead > 0L && (l = in.read(b, 0, (int)sizeToRead)) != -1) {
                crc.update(b, l);
                sizeToRead = Long.min(sizeToReadTotal -= (long)l, bufferSize);
            }
            CRC64 cRC64 = crc;
            return cRC64;
        }
        finally {
            in.close();
        }
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public void update(byte[] b, int len) {
        this.update(b, 0, len);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        int idx = off;
        while (len >= 8) {
            this.value = CRC64_TABLE[7][(int)(this.value & 0xFFL ^ (long)(b[idx] & 0xFF))] ^ CRC64_TABLE[6][(int)(this.value >>> 8 & 0xFFL ^ (long)(b[idx + 1] & 0xFF))] ^ CRC64_TABLE[5][(int)(this.value >>> 16 & 0xFFL ^ (long)(b[idx + 2] & 0xFF))] ^ CRC64_TABLE[4][(int)(this.value >>> 24 & 0xFFL ^ (long)(b[idx + 3] & 0xFF))] ^ CRC64_TABLE[3][(int)(this.value >>> 32 & 0xFFL ^ (long)(b[idx + 4] & 0xFF))] ^ CRC64_TABLE[2][(int)(this.value >>> 40 & 0xFFL ^ (long)(b[idx + 5] & 0xFF))] ^ CRC64_TABLE[1][(int)(this.value >>> 48 & 0xFFL ^ (long)(b[idx + 6] & 0xFF))] ^ CRC64_TABLE[0][(int)(this.value >>> 56 ^ (long)(b[idx + 7] & 0xFF))];
            idx += 8;
            len -= 8;
        }
        while (len > 0) {
            this.value = CRC64_TABLE[0][(int)((this.value ^ (long)b[idx]) & 0xFFL)] ^ this.value >>> 8;
            ++idx;
            --len;
        }
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void update(int b) {
        this.update(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void reset() {
        this.value = 0L;
    }

    private static long gf2MatrixTimes(long[] mat, long vec) {
        long sum = 0L;
        int idx = 0;
        while (vec != 0L) {
            if ((vec & 1L) == 1L) {
                sum ^= mat[idx];
            }
            vec >>>= 1;
            ++idx;
        }
        return sum;
    }

    private static void gf2MatrixSquare(long[] square, long[] mat) {
        for (int n = 0; n < 64; ++n) {
            square[n] = CRC64.gf2MatrixTimes(mat, mat[n]);
        }
    }

    public void combineWithAnotherCRC64(CRC64 anotherCRC64, long len2) {
        this.value = CRC64.combine(this.value, anotherCRC64.value, len2);
    }

    public static long combine(long crc1, long crc2, long len2) {
        if (len2 == 0L) {
            return crc1;
        }
        long[] even = Arrays.copyOf(EVEN_SQUARE, EVEN_SQUARE.length);
        long[] odd = Arrays.copyOf(ODD_SQUARE, ODD_SQUARE.length);
        do {
            CRC64.gf2MatrixSquare(even, odd);
            if ((len2 & 1L) == 1L) {
                crc1 = CRC64.gf2MatrixTimes(even, crc1);
            }
            if ((len2 >>>= 1) == 0L) break;
            CRC64.gf2MatrixSquare(odd, even);
            if ((len2 & 1L) != 1L) continue;
            crc1 = CRC64.gf2MatrixTimes(odd, crc1);
        } while ((len2 >>>= 1) != 0L);
        return crc1 ^= crc2;
    }

    public String toString() {
        return Long.toUnsignedString(this.value);
    }

    public static String toString(long value) {
        return Long.toUnsignedString(value);
    }

    public static long fromString(String crcString) throws NumberFormatException {
        return Long.parseUnsignedLong(crcString);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CRC64) {
            return ((CRC64)obj).value == this.value;
        }
        return false;
    }

    static {
        int k;
        long crc;
        int n;
        log = LoggerBuilder.getLogger(CRC64.class);
        CRC64_TABLE = new long[8][256];
        for (n = 0; n < 256; ++n) {
            crc = n;
            for (k = 0; k < 8; ++k) {
                if ((crc & 1L) == 1L) {
                    crc = crc >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                crc >>>= 1;
            }
            CRC64.CRC64_TABLE[0][n] = crc;
        }
        for (n = 0; n < 256; ++n) {
            crc = CRC64_TABLE[0][n];
            for (k = 1; k < 8; ++k) {
                CRC64.CRC64_TABLE[k][n] = crc = CRC64_TABLE[0][(int)(crc & 0xFFL)] ^ crc >>> 8;
            }
        }
        EVEN_SQUARE = new long[64];
        ODD_SQUARE = new long[64];
        CRC64.ODD_SQUARE[0] = -3932672073523589310L;
        long row = 1L;
        for (n = 1; n < 64; ++n) {
            CRC64.ODD_SQUARE[n] = row;
            row <<= 1;
        }
        CRC64.gf2MatrixSquare(EVEN_SQUARE, ODD_SQUARE);
        CRC64.gf2MatrixSquare(ODD_SQUARE, EVEN_SQUARE);
    }
}

