/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public class OkhttpCallProfiler
extends EventListener {
    private final Consumer<StringBuilder> profiler;
    private final HashMap<String, Long> progressStartTime;
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");
    private static final String ProFileTimeUnit = "ms";
    protected static boolean isEnabled = true;

    public OkhttpCallProfiler(Consumer<StringBuilder> profiler) {
        this.profiler = profiler;
        this.progressStartTime = new HashMap();
    }

    public OkhttpCallProfiler() {
        this.profiler = log::debug;
        this.progressStartTime = new HashMap();
    }

    public void callEnd(Call call) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" callEnd ");
        this.appendProgressTime("call", stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void callFailed(Call call, IOException ioe) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" callFailed ");
        this.appendProgressTime("call", stringBuilder);
        this.appendDetailIOException(ioe, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void callStart(Call call) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" callStart ");
        this.appendProgressTime("call", stringBuilder);
        this.appendDetailForCall(call, stringBuilder, true);
        this.profiler.accept(stringBuilder);
    }

    public void canceled(Call call) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" call canceled.");
        this.appendProgressTime("call", stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" connectEnd ");
        this.appendProgressTime("connect", stringBuilder);
        this.appendDetailInetSocketAddress(inetSocketAddress, stringBuilder);
        this.appendDetailProxy(proxy, stringBuilder);
        this.appendDetailProtocol(protocol, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" connectFailed ");
        this.appendProgressTime("connect", stringBuilder);
        this.appendDetailInetSocketAddress(inetSocketAddress, stringBuilder);
        this.appendDetailProxy(proxy, stringBuilder);
        this.appendDetailProtocol(protocol, stringBuilder);
        this.appendDetailIOException(ioe, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" connectStart ");
        this.appendProgressTime("connect", stringBuilder);
        this.appendDetailInetSocketAddress(inetSocketAddress, stringBuilder);
        this.appendDetailProxy(proxy, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void connectionAcquired(Call call, Connection connection) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" connectionAcquired ");
        this.appendProgressTime("connection", stringBuilder);
        this.appendDetailConnection(connection, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void connectionReleased(Call call, Connection connection) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" connectionReleased ");
        this.appendProgressTime("connection", stringBuilder);
        this.appendDetailConnection(connection, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" dnsEnd ");
        this.appendProgressTime("dns", stringBuilder);
        this.appendDetailDns(domainName, inetAddressList, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void dnsStart(Call call, String domainName) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" dnsStart ");
        this.appendProgressTime("dns", stringBuilder);
        this.appendDetailDns(domainName, null, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void proxySelectEnd(Call call, HttpUrl url, List<Proxy> proxies) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" proxySelectEnd ");
        this.appendProgressTime("proxySelect", stringBuilder);
        stringBuilder.append(" url{");
        stringBuilder.append(url);
        stringBuilder.append("} ");
        stringBuilder.append(" proxies{");
        stringBuilder.append(proxies);
        stringBuilder.append("} ");
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void proxySelectStart(Call call, HttpUrl url) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" proxySelectStart ");
        this.appendProgressTime("proxySelect", stringBuilder);
        stringBuilder.append(" url{");
        stringBuilder.append(url);
        stringBuilder.append("} ");
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void requestBodyEnd(Call call, long byteCount) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" requestBodyEnd ");
        this.appendProgressTime("requestBody", stringBuilder);
        this.appendProgressTime("request", stringBuilder);
        stringBuilder.append(" byteCount{");
        stringBuilder.append(byteCount);
        stringBuilder.append("} ");
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void requestBodyStart(Call call) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" requestBodyStart ");
        this.appendProgressTime("requestBody", stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void requestFailed(Call call, IOException ioe) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" requestFailed ");
        this.appendProgressTime("request", stringBuilder);
        this.appendDetailIOException(ioe, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void requestHeadersEnd(Call call, Request request) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" requestHeadersEnd ");
        this.appendProgressTime("requestHeaders", stringBuilder);
        this.appendDetailRequestHeaders(request, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void requestHeadersStart(Call call) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" requestHeadersStart ");
        this.appendProgressTime("request", stringBuilder);
        this.appendProgressTime("requestHeaders", stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void responseBodyEnd(Call call, long byteCount) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" responseBodyEnd ");
        this.appendProgressTime("responseBody", stringBuilder);
        this.appendProgressTime("response", stringBuilder);
        stringBuilder.append(" byteCount{");
        stringBuilder.append(byteCount);
        stringBuilder.append("} ");
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void responseBodyStart(Call call) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" responseBodyStart ");
        this.appendProgressTime("responseBody", stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void responseFailed(Call call, IOException ioe) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" responseFailed ");
        this.appendProgressTime("response", stringBuilder);
        this.appendDetailIOException(ioe, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void responseHeadersEnd(Call call, Response response) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" responseHeadersEnd ");
        this.appendProgressTime("responseHeaders", stringBuilder);
        this.appendDetailResponseHeaders(response, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void responseHeadersStart(Call call) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" responseHeadersStart ");
        this.appendProgressTime("response", stringBuilder);
        this.appendProgressTime("responseHeaders", stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" secureConnectEnd ");
        this.appendProgressTime("secureConnect", stringBuilder);
        this.appendDetailHandshake(handshake, stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    public void secureConnectStart(Call call) {
        if (!isEnabled) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" secureConnectStart ");
        this.appendProgressTime("secureConnect", stringBuilder);
        this.appendDetailForCall(call, stringBuilder);
        this.profiler.accept(stringBuilder);
    }

    protected void appendProgressTime(String progressName, StringBuilder stringBuilder) {
        Long startTime = this.progressStartTime.get(progressName);
        if (startTime == null) {
            startTime = System.currentTimeMillis();
            this.progressStartTime.put(progressName, startTime);
            stringBuilder.append(progressName);
            stringBuilder.append(" start time: ");
            stringBuilder.append(startTime);
            stringBuilder.append(ProFileTimeUnit);
            stringBuilder.append(" ");
        } else {
            long currentTime = System.currentTimeMillis();
            long costTime = currentTime - startTime;
            this.progressStartTime.remove(progressName, startTime);
            stringBuilder.append(progressName);
            stringBuilder.append(" cost time: ");
            stringBuilder.append(costTime);
            stringBuilder.append(ProFileTimeUnit);
            stringBuilder.append(" end time: ");
            stringBuilder.append(currentTime);
            stringBuilder.append(ProFileTimeUnit);
            stringBuilder.append(" ");
        }
    }

    protected void appendDetailForCall(Call call, StringBuilder stringBuilder) {
        this.appendDetailForCall(call, stringBuilder, false);
    }

    protected void appendDetailForCall(Call call, StringBuilder stringBuilder, boolean needDetail) {
        stringBuilder.append("call {");
        if (needDetail) {
            stringBuilder.append("url:");
            stringBuilder.append(call.request().url());
            stringBuilder.append(" method:");
            stringBuilder.append(call.request().method());
            stringBuilder.append(" ");
        }
        stringBuilder.append("hash:");
        stringBuilder.append(System.identityHashCode(call));
        stringBuilder.append("} ");
    }

    protected void appendDetailInetSocketAddress(InetSocketAddress inetSocketAddress, StringBuilder stringBuilder) {
        stringBuilder.append(" InetSocketAddress {");
        stringBuilder.append(inetSocketAddress);
        stringBuilder.append("} ");
    }

    protected void appendDetailProxy(Proxy proxy, StringBuilder stringBuilder) {
        stringBuilder.append(" Proxy {type:");
        stringBuilder.append((Object)proxy.type());
        stringBuilder.append(" address:");
        stringBuilder.append(proxy.address());
        stringBuilder.append("} ");
    }

    protected void appendDetailProtocol(Protocol protocol, StringBuilder stringBuilder) {
        stringBuilder.append(" Protocol{");
        stringBuilder.append(protocol);
        stringBuilder.append("} ");
    }

    protected void appendDetailConnection(Connection connection, StringBuilder stringBuilder) {
        stringBuilder.append(" ");
        stringBuilder.append(connection);
        stringBuilder.append(" ");
    }

    protected void appendDetailDns(String domainName, List<InetAddress> inetAddressList, StringBuilder stringBuilder) {
        stringBuilder.append(" domainName:");
        stringBuilder.append(domainName);
        stringBuilder.append(" inetAddressList{");
        stringBuilder.append(inetAddressList);
        stringBuilder.append("} ");
    }

    protected void appendDetailRequestHeaders(Request request, StringBuilder stringBuilder) {
        stringBuilder.append(" requestHeaders{");
        stringBuilder.append(request.headers());
        stringBuilder.append("} ");
    }

    protected void appendDetailResponseHeaders(Response response, StringBuilder stringBuilder) {
        stringBuilder.append(" responseHeaders{");
        stringBuilder.append(response.headers());
        stringBuilder.append("} ");
    }

    protected void appendDetailHandshake(Handshake handshake, StringBuilder stringBuilder) {
        stringBuilder.append(" handshake{");
        stringBuilder.append(handshake);
        stringBuilder.append("} ");
    }

    protected void appendDetailIOException(IOException ioe, StringBuilder stringBuilder) {
        try (StringWriter stringWriter = new StringWriter();
             PrintWriter printWriter = new PrintWriter(stringWriter);){
            ioe.printStackTrace(printWriter);
            stringBuilder.append(stringWriter);
        }
        catch (IOException ignore) {
            stringBuilder.append("appendDetailIOException failed");
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void setEnabled(boolean enabled) {
        isEnabled = enabled;
    }
}

