/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.transport;

import org.apache.servicecomb.service.center.client.model.DataCenterInfo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.servicecomb.discovery")
public class DiscoveryBootstrapProperties {
    private boolean enabled = true;
    private boolean watch = false;
    private boolean enableZoneAware = false;
    private String address;
    private String appName = "default";
    @Value(value="${spring.cloud.servicecomb.discovery.serviceName:${spring.application.name:}}")
    private String serviceName;
    @Value(value="${server.env:}")
    private String environment;
    private String version;
    private String hostname;
    private boolean preferIpAddress;
    private boolean healthCheck = true;
    private int healthCheckInterval = 15000;
    private int healthCheckRequestTimeout = 5000;
    private int pollInterval = 15000;
    private int refreshInterval = 30000;
    private boolean autoDiscovery = false;
    @Value(value="${spring.cloud.servicecomb.discovery.allowCrossApp:false}")
    private boolean allowCrossApp;
    @Value(value="${server.publishAddress:}")
    private String serverAddress;
    @Value(value="${spring.cloud.servicecomb.discovery.ignoreSwaggerDifferent:false}")
    private boolean ignoreSwaggerDifferent;
    private DataCenterInfo datacenter;
    private static final int HEALTH_CHECK_MAX_INTERVAL = 600;
    private static final int HEALTH_CHECK_MIN_INTERVAL = 1;

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public DataCenterInfo getDatacenter() {
        return this.datacenter;
    }

    public void setDatacenter(DataCenterInfo datacenter) {
        this.datacenter = datacenter;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnableZoneAware() {
        return this.enableZoneAware;
    }

    public void setEnableZoneAware(boolean enableZoneAware) {
        this.enableZoneAware = enableZoneAware;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public boolean isPreferIpAddress() {
        return this.preferIpAddress;
    }

    public void setPreferIpAddress(boolean preferIpAddress) {
        this.preferIpAddress = preferIpAddress;
    }

    public boolean isHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(boolean healthCheck) {
        this.healthCheck = healthCheck;
    }

    public int getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    public void setHealthCheckInterval(int healthCheckInterval) {
        if (healthCheckInterval <= 600 && healthCheckInterval >= 1) {
            this.healthCheckInterval = healthCheckInterval;
        }
    }

    public int getHealthCheckRequestTimeout() {
        return this.healthCheckRequestTimeout;
    }

    public void setHealthCheckRequestTimeout(int healthCheckRequestTimeout) {
        this.healthCheckRequestTimeout = healthCheckRequestTimeout;
    }

    public int getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public boolean isAutoDiscovery() {
        return this.autoDiscovery;
    }

    public void setAutoDiscovery(boolean autoDiscovery) {
        this.autoDiscovery = autoDiscovery;
    }

    public boolean isAllowCrossApp() {
        return this.allowCrossApp;
    }

    public void setAllowCrossApp(boolean allowCrossApp) {
        this.allowCrossApp = allowCrossApp;
    }

    public boolean isIgnoreSwaggerDifferent() {
        return this.ignoreSwaggerDifferent;
    }

    public void setIgnoreSwaggerDifferent(boolean ignoreSwaggerDifferent) {
        this.ignoreSwaggerDifferent = ignoreSwaggerDifferent;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public String toString() {
        return "ServiceCombDiscoveryProperties{enabled=" + this.enabled + ", watch=" + this.watch + ", address='" + this.address + '\'' + ", appName='" + this.appName + '\'' + ", serviceName='" + this.serviceName + '\'' + ", environment='" + this.environment + '\'' + ", version='" + this.version + '\'' + ", hostname='" + this.hostname + '\'' + ", preferIpAddress=" + this.preferIpAddress + ", healthCheck=" + this.healthCheck + ", healthCheckInterval=" + this.healthCheckInterval + ", autoDiscovery=" + this.autoDiscovery + ", allowCrossApp=" + this.allowCrossApp + ", dataCenter=" + this.datacenter + '}';
    }
}

