/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.transport;

import com.huaweicloud.common.util.Cipher;
import com.huaweicloud.common.util.DefaultCipher;
import com.huaweicloud.common.util.SecretUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.servicecomb.credentials")
public class ServiceCombAkSkProperties {
    private List<Cipher> ciphers;
    private boolean enabled = false;
    private String accessKey;
    private String secretKey;
    @Value(value="#{'${spring.cloud.servicecomb.credentials.cipher:${spring.cloud.servicecomb.credentials.akskCustomCipher:default}}'}")
    private String cipher;
    private String project = "default";

    @Autowired
    public void setCiphers(List<Cipher> ciphers) {
        this.ciphers = ciphers;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        String decodedSecretKey = new String(DefaultCipher.findCipher(this.ciphers, this.cipher).decrypt(this.secretKey.toCharArray()));
        if ("ShaAKSKCipher".equalsIgnoreCase(this.cipher)) {
            return decodedSecretKey;
        }
        return SecretUtil.sha256Encode(decodedSecretKey, this.accessKey);
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getCipher() {
        return this.cipher;
    }

    public void setCipher(String cipher) {
        this.cipher = cipher;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAkSkEmpty() {
        return StringUtils.isEmpty((CharSequence)this.accessKey) || StringUtils.isEmpty((CharSequence)this.secretKey);
    }

    public boolean isProjectEmpty() {
        return StringUtils.isEmpty((CharSequence)this.project);
    }

    public boolean isEmpty() {
        return this.getAccessKey() == null || this.getSecretKey() == null;
    }
}

