/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.common.transport;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huaweicloud.common.util.Cipher;
import com.huaweicloud.common.util.DefaultCipher;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.servicecomb.credentials.account")
public class ServiceCombRBACProperties {
    @JsonIgnore
    private List<Cipher> ciphers;
    @Value(value="#{'${spring.cloud.servicecomb.credentials.account.cipher:${spring.cloud.servicecomb.credentials.account.akskCustomCipher:default}}'}")
    @JsonIgnore
    private String cipher;
    private String name;
    private String password;

    @Autowired
    public void setCiphers(List<Cipher> ciphers) {
        this.ciphers = ciphers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        String decodedPassWord = new String(DefaultCipher.findCipher(this.ciphers, this.cipher).decrypt(this.password.toCharArray()));
        return decodedPassWord;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCipher() {
        return this.cipher;
    }

    public void setCipher(String cipher) {
        this.cipher = cipher;
    }
}

