/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.servicecomb.discovery.registry;

import com.huaweicloud.common.transport.DiscoveryBootstrapProperties;
import com.huaweicloud.servicecomb.discovery.ConditionalOnServiceCombEnabled;
import com.huaweicloud.servicecomb.discovery.DiscoveryAutoConfiguration;
import com.huaweicloud.servicecomb.discovery.discovery.DiscoveryProperties;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombAutoServiceRegistration;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombRegistration;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombServiceRegistry;
import com.huaweicloud.servicecomb.discovery.registry.TagsProperties;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.service.center.client.ServiceCenterWatch;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationAutoConfiguration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationConfiguration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.servicecomb.discovery.enabled"}, matchIfMissing=true)
@ConditionalOnServiceCombEnabled
@EnableConfigurationProperties
@AutoConfigureBefore(value={ServiceRegistryAutoConfiguration.class})
@AutoConfigureAfter(value={AutoServiceRegistrationConfiguration.class, AutoServiceRegistrationAutoConfiguration.class, DiscoveryAutoConfiguration.class})
public class ServiceCombRegistryAutoConfiguration {
    @Bean
    public ServiceCombServiceRegistry serviceCombServiceRegistry(DiscoveryBootstrapProperties discoveryBootstrapProperties, ServiceCenterClient serviceCenterClient, ServiceCenterWatch serviceCenterWatch) {
        return new ServiceCombServiceRegistry(discoveryBootstrapProperties, serviceCenterClient, serviceCenterWatch);
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    public ServiceCombRegistration serviceCombRegistration(DiscoveryProperties discoveryProperties, DiscoveryBootstrapProperties discoveryBootstrapProperties, TagsProperties tagsProperties) {
        return new ServiceCombRegistration(discoveryBootstrapProperties, discoveryProperties, tagsProperties);
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    public ServiceCombAutoServiceRegistration serviceCombAutoServiceRegistration(ServiceCombServiceRegistry registry, AutoServiceRegistrationProperties autoServiceRegistrationProperties, ServiceCombRegistration registration) {
        return new ServiceCombAutoServiceRegistration(registry, autoServiceRegistrationProperties, registration);
    }
}

