/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.router.client.loabalancer;

import com.huaweicloud.router.client.loabalancer.ServiceInstanceFilter;
import com.huaweicloud.servicecomb.discovery.client.model.ServiceCombServiceInstance;
import com.huaweicloud.servicecomb.discovery.registry.ServiceCombRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;

public class ZoneAwareServiceInstanceFilter
implements ServiceInstanceFilter {
    private ServiceCombRegistration serviceCombRegistration;
    @Value(value="${spring.cloud.servicecomb.discovery.denyCrossZoneLoadBalancing:false}")
    private boolean denyCrossZoneLoadBalancing;

    @Autowired
    public void setServiceCombRegistration(ServiceCombRegistration serviceCombRegistration) {
        this.serviceCombRegistration = serviceCombRegistration;
    }

    @Override
    public List<ServiceInstance> filter(ServiceInstanceListSupplier supplier, List<ServiceInstance> instances, Request<?> request) {
        MicroserviceInstance mySelf = this.serviceCombRegistration.getMicroserviceInstance();
        return this.zoneAwareDiscoveryFilter(mySelf, instances);
    }

    public int getOrder() {
        return -2;
    }

    private List<ServiceInstance> zoneAwareDiscoveryFilter(MicroserviceInstance mySelf, List<ServiceInstance> instances) {
        ArrayList<ServiceInstance> regionAndAZMatchList = new ArrayList<ServiceInstance>();
        ArrayList<ServiceInstance> regionMatchList = new ArrayList<ServiceInstance>();
        instances.forEach(serviceInstance -> {
            ServiceCombServiceInstance instance = (ServiceCombServiceInstance)serviceInstance;
            if (this.regionAndAZMatch(mySelf, instance.getMicroserviceInstance())) {
                regionAndAZMatchList.add((ServiceInstance)serviceInstance);
            } else if (this.regionMatch(mySelf, instance.getMicroserviceInstance())) {
                regionMatchList.add((ServiceInstance)serviceInstance);
            }
        });
        if (!regionAndAZMatchList.isEmpty()) {
            return regionAndAZMatchList;
        }
        if (!regionMatchList.isEmpty()) {
            return regionMatchList;
        }
        if (!this.denyCrossZoneLoadBalancing) {
            return instances;
        }
        return Collections.emptyList();
    }

    private boolean regionAndAZMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (myself.getDataCenterInfo() != null && target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion()) && myself.getDataCenterInfo().getAvailableZone().equals(target.getDataCenterInfo().getAvailableZone());
        }
        return false;
    }

    private boolean regionMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion());
        }
        return false;
    }
}

