/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.hessian;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.hessian2.Hessian2ObjectInput;
import org.apache.dubbo.common.serialize.hessian2.Hessian2ObjectOutput;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.MimeType;

public class HessianHttpMessageConverter
extends AbstractGenericHttpMessageConverter<Object> {
    public static final String HESSIAN_MEDIA_TYPE_VALUE = "x-application/hessian2";
    public static final MediaType HESSIAN_MEDIA_TYPE = MediaType.valueOf((String)"x-application/hessian2");

    public HessianHttpMessageConverter() {
        super(HESSIAN_MEDIA_TYPE);
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected boolean canWrite(MediaType mediaType) {
        return HESSIAN_MEDIA_TYPE.equalsTypeAndSubtype((MimeType)mediaType);
    }

    protected boolean canRead(MediaType mediaType) {
        return HESSIAN_MEDIA_TYPE.equalsTypeAndSubtype((MimeType)mediaType);
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Hessian2ObjectInput input = new Hessian2ObjectInput(inputMessage.getBody());
        try {
            return input.readObject(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    protected void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Hessian2ObjectOutput output = new Hessian2ObjectOutput(outputMessage.getBody());
        output.writeObject(o);
        output.flushBuffer();
    }

    protected void writeInternal(Object o, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Hessian2ObjectOutput output = new Hessian2ObjectOutput(outputMessage.getBody());
        output.writeObject(o);
        output.flushBuffer();
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Hessian2ObjectInput input = new Hessian2ObjectInput(inputMessage.getBody());
        Type updatedType = type;
        try {
            while (updatedType instanceof ParameterizedType) {
                updatedType = ((ParameterizedType)updatedType).getRawType();
            }
            if (updatedType instanceof Class) {
                return input.readObject((Class)updatedType);
            }
            throw new IOException("not supported type " + updatedType.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }
}

