/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.gateway.governance;

import com.huaweicloud.governance.SpringCloudInvocationContext;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.reactor.bulkhead.operator.BulkheadOperator;
import io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator;
import io.github.resilience4j.reactor.ratelimiter.operator.RateLimiterOperator;
import io.github.resilience4j.reactor.retry.RetryOperator;
import io.github.resilience4j.retry.Retry;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.governance.handler.BulkheadHandler;
import org.apache.servicecomb.governance.handler.CircuitBreakerHandler;
import org.apache.servicecomb.governance.handler.RateLimitingHandler;
import org.apache.servicecomb.governance.handler.RetryHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GovernanceGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GovernanceGatewayFilterFactory.class);
    @Autowired
    private RateLimitingHandler rateLimitingHandler;
    @Autowired
    private CircuitBreakerHandler circuitBreakerHandler;
    @Autowired
    private BulkheadHandler bulkheadHandler;
    @Autowired
    private RetryHandler retryHandler;

    public GovernanceGatewayFilterFactory() {
        super(Config.class);
    }

    public GatewayFilter apply(Config config) {
        return new GovernanceGatewayFilter();
    }

    public String name() {
        return "governance";
    }

    public static class RetryException
    extends RuntimeException {
        static final long serialVersionUID = -1L;
    }

    public static class Config
    implements HasRouteId {
        private String routeId;

        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        public String getRouteId() {
            return this.routeId;
        }
    }

    class GovernanceGatewayFilter
    implements GatewayFilter {
        GovernanceGatewayFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            GovernanceRequest governanceRequest = this.createGovernanceRequest(exchange);
            try {
                SpringCloudInvocationContext.setInvocationContext();
                Mono<Void> toRun = chain.filter(exchange);
                toRun = this.addRetry(exchange, governanceRequest, toRun);
                toRun = this.addCircuitBreaker(exchange, governanceRequest, toRun);
                toRun = this.addBulkhead(governanceRequest, toRun);
                Mono<Void> mono = toRun = this.addRateLimiter(governanceRequest, toRun);
                return mono;
            }
            finally {
                SpringCloudInvocationContext.removeInvocationContext();
            }
        }

        private Mono<Void> addRetry(ServerWebExchange exchange, GovernanceRequest governanceRequest, Mono<Void> toRun) {
            Retry retry = (Retry)GovernanceGatewayFilterFactory.this.retryHandler.getActuator(governanceRequest);
            if (retry != null) {
                toRun = toRun.transform((Function)RetryOperator.of((Retry)retry)).doOnSuccess(v -> {
                    if (exchange.getResponse().getRawStatusCode() != null && retry.context().onResult((Object)exchange.getResponse().getRawStatusCode())) {
                        exchange.getResponse().setStatusCode(null);
                        ServerWebExchangeUtils.reset((ServerWebExchange)exchange);
                        throw new RetryException();
                    }
                }).retryWhen(reactor.util.retry.Retry.withThrowable((Function)reactor.retry.Retry.anyOf((Class[])new Class[]{RetryException.class})));
            }
            return toRun;
        }

        private Mono<Void> addBulkhead(GovernanceRequest governanceRequest, Mono<Void> toRun) {
            Bulkhead bulkhead = (Bulkhead)GovernanceGatewayFilterFactory.this.bulkheadHandler.getActuator(governanceRequest);
            if (bulkhead != null) {
                toRun = toRun.transform((Function)BulkheadOperator.of((Bulkhead)bulkhead)).onErrorResume(BulkheadFullException.class, t -> {
                    LOGGER.warn("bulkhead is full and does not permit further calls by policy : {}", (Object)t.getMessage());
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.TOO_MANY_REQUESTS, "bulkhead is full and does not permit further calls.", (Throwable)t));
                });
            }
            return toRun;
        }

        private Mono<Void> addCircuitBreaker(ServerWebExchange exchange, GovernanceRequest governanceRequest, Mono<Void> toRun) {
            CircuitBreaker circuitBreaker = (CircuitBreaker)GovernanceGatewayFilterFactory.this.circuitBreakerHandler.getActuator(governanceRequest);
            if (circuitBreaker != null) {
                toRun = toRun.transform((Function)CircuitBreakerOperator.of((CircuitBreaker)circuitBreaker)).doOnSuccess(v -> {
                    if (exchange.getResponse().getStatusCode() != null && Response.Status.Family.familyOf((int)exchange.getResponse().getStatusCode().value()) == Response.Status.Family.SERVER_ERROR) {
                        exchange.getResponse().setStatusCode(null);
                        ServerWebExchangeUtils.reset((ServerWebExchange)exchange);
                        throw CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)circuitBreaker);
                    }
                }).onErrorResume(CallNotPermittedException.class, t -> {
                    LOGGER.warn("circuitBreaker is open by policy : {}", (Object)t.getMessage());
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.TOO_MANY_REQUESTS, "bulkhead is full and does not permit further calls.", (Throwable)t));
                });
            }
            return toRun;
        }

        private Mono<Void> addRateLimiter(GovernanceRequest governanceRequest, Mono<Void> toRun) {
            RateLimiter rateLimiter = (RateLimiter)GovernanceGatewayFilterFactory.this.rateLimitingHandler.getActuator(governanceRequest);
            if (rateLimiter != null) {
                toRun = toRun.transform((Function)RateLimiterOperator.of((RateLimiter)rateLimiter)).onErrorResume(RequestNotPermitted.class, t -> {
                    LOGGER.warn("the request is rate limit by policy : {}", (Object)t.getMessage());
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.TOO_MANY_REQUESTS, "rate limited.", (Throwable)t));
                });
            }
            return toRun;
        }

        private GovernanceRequest createGovernanceRequest(ServerWebExchange exchange) {
            GovernanceRequest request = new GovernanceRequest();
            request.setHeaders(exchange.getRequest().getHeaders().toSingleValueMap());
            request.setMethod(exchange.getRequest().getMethodValue());
            request.setUri(exchange.getRequest().getURI().getPath());
            return request;
        }
    }
}

