/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.services;

import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLBASE64Codec;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.mdfromhtml.services.MDfromHTMLResponseCodes;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

/*
 * Exception performing whole class analysis ignored.
 */
public class MDfromHTMLServiceUtil
implements Serializable {
    public static String HTTP_RESPONSE = "Response";
    public static String HTTP_RETURN_CODE = "ReturnCode";
    public static final String AUTHORIZATION = "Authorization";
    public static final String AUTHORIZATION_ADMIN_USER = "MDfromHTMLadmin";
    public static final String AUTHORIZATION_CREDENTIALS = "YnNuYWRtaW46YnNuaXNmdW4=";
    public static final byte[] AUTHORIZATION_CREDENTIALS_DECODED = "MDfromHTMLadmin:MDfromHTMLisfun".getBytes();
    public static final String AUTHORIZATION_PREFIX = "Basic ";
    public static final String AUTHORIZATION_LOGIN = "Basic YnNuYWRtaW46YnNuaXNmdW4=";
    public static final String AUTHORIZATION_SESSION_PREFIX = "MDfromHTMLadmin:";
    public static final int AUTHORIZATION_SESSION_ID_OFFSET = "MDfromHTMLadmin:".length();
    static boolean debug = false;
    public static final String HTTP_HEADER_SESSION_ID = "X-Session-ID";
    public static final String HTTP_HEADER_USER_ID = "X-User-ID";
    private static final long serialVersionUID = -3804636662225945449L;
    public static final String SESSION_COOKIE_APPL_NAME = "MDfromHTML";
    public static final String SESSION_COOKIE_DOMAIN = null;
    public static final int SESSION_COOKIE_MAX_AGE = 86400;
    public static final String SESSION_COOKIE_NAME = "session";
    public static final String SESSION_COOKIE_PATH = null;
    public static final boolean SESSION_COOKIE_SECURE = false;
    public static final int SESSION_COOKIE_VERSION = 1;
    public static final String USER_COOKIE_APPL_NAME = "MDfromHTMLUser";
    public static final String USER_COOKIE_DOMAIN = null;
    public static final int USER_COOKIE_MAX_AGE = 86400;
    public static final String USER_COOKIE_NAME = "user";
    public static final String USER_COOKIE_PATH = null;
    public static final boolean USER_COOKIE_SECURE = false;
    public static final int USER_COOKIE_VERSION = 1;

    public static Response getErrorResponse(String errorMessage, MDfromHTMLResponseCodes MDfromHTMLResponseCodes2) {
        if (MDfromHTMLResponseCodes2 == null) {
            MDfromHTMLResponseCodes2 = MDfromHTMLResponseCodes.MDfromHTML_UNEXPECTED_ERROR;
        }
        JSONObject errorContentsObj = new JSONObject();
        errorContentsObj.put("code", (Object)MDfromHTMLResponseCodes2.label());
        errorContentsObj.put("description", (Object)MDfromHTMLResponseCodes2.description());
        errorContentsObj.put("code", (Object)MDfromHTMLResponseCodes2.code());
        errorContentsObj.put("src", (Object)"MDfromHTML");
        errorContentsObj.put("type", (Object)MDfromHTMLResponseCodes2.label());
        if (!MDfromHTMLUtils.isUndefined((String)errorMessage)) {
            errorContentsObj.put("detail", (Object)errorMessage);
        }
        JSONObject errorObj = new JSONObject();
        errorObj.put("error", (Object)errorContentsObj);
        JSONObject ildErrorObj = errorObj;
        Response resp = Response.status((Response.Status)MDfromHTMLResponseCodes2.respCode()).header("Access-Control-Allow-Credentials", (Object)"true").header("Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization").header("Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD").header("Access-Control-Allow-Origin", (Object)"*").header("Access_Control_Max_Age", (Object)43200).entity((Object)ildErrorObj.toString()).type("application/json").build();
        return resp;
    }

    public static Response getErrorResponse(Throwable exception, MDfromHTMLResponseCodes responseCodes) {
        if (responseCodes == null) {
            responseCodes = MDfromHTMLResponseCodes.MDfromHTML_UNEXPECTED_ERROR;
        }
        JSONObject errorContentsObj = new JSONObject();
        errorContentsObj.put("code", (Object)responseCodes.label());
        errorContentsObj.put("description", (Object)responseCodes.description());
        errorContentsObj.put("code", (Object)responseCodes.code());
        errorContentsObj.put("src", (Object)"MDfromHTML");
        errorContentsObj.put("type", (Object)responseCodes.label());
        if (exception != null) {
            errorContentsObj.put("detail", (Object)exception.getLocalizedMessage());
        }
        ArrayList<String> errorStack = new ArrayList<String>();
        if (exception != null) {
            StackTraceElement[] stElements;
            Stack<Throwable> chainStack = new Stack<Throwable>();
            Throwable tTrigger = new Throwable(exception.toString());
            tTrigger.setStackTrace(exception.getStackTrace());
            errorStack.add("Caused by: " + tTrigger.getMessage());
            StackTraceElement[] stackTraceElementArray = stElements = tTrigger.getStackTrace();
            int n = stElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stElt = stackTraceElementArray[n2];
                errorStack.add("  " + stElt.toString());
                ++n2;
            }
            chainStack.push(tTrigger);
            Throwable tCause = exception.getCause();
            while (tCause != null) {
                Throwable tNew = new Throwable(tCause.getMessage());
                tNew.setStackTrace(tCause.getStackTrace());
                chainStack.push(tNew);
                errorStack.add("Caused by: " + tCause.getMessage());
                StackTraceElement[] stackTraceElementArray2 = stElements = tCause.getStackTrace();
                int n3 = stElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    StackTraceElement stElt = stackTraceElementArray2[n4];
                    errorStack.add("  " + stElt.toString());
                    ++n4;
                }
                tCause = tCause.getCause();
            }
            Throwable tChild = (Throwable)chainStack.pop();
            try {
                Throwable tParent = (Throwable)chainStack.pop();
                while (tParent != null) {
                    tParent.initCause(tChild);
                    tChild = tParent;
                    tParent = (Throwable)chainStack.pop();
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        JSONArray errorStackArray = new JSONArray();
        for (String errorStackMsg : errorStack) {
            errorStackArray.add((Object)errorStackMsg);
        }
        errorContentsObj.put("stackTrace", (Object)errorStackArray);
        JSONObject errorObj = new JSONObject();
        errorObj.put("error", (Object)errorContentsObj);
        JSONObject ildErrorObj = errorObj;
        if (debug) {
            try {
                System.out.println(ildErrorObj.serialize(true));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Response resp = Response.status((Response.Status)responseCodes.respCode()).header("Access-Control-Allow-Credentials", (Object)"true").header("Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization").header("Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD").header("Access-Control-Allow-Origin", (Object)"*").header("Access_Control_Max_Age", (Object)43200).entity((Object)ildErrorObj.toString()).type("application/json").build();
        return resp;
    }

    public static Response getResponse(JSONObject jsonMessage) {
        JSONObject respObj = jsonMessage;
        Response resp = Response.status((Response.Status)MDfromHTMLResponseCodes.MDfromHTML_OKAY.respCode()).header("Access-Control-Allow-Credentials", (Object)"true").header("Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization").header("Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD").header("Access-Control-Allow-Origin", (Object)"*").header("Access_Control_Max_Age", (Object)43200).entity((Object)respObj.toString()).type("application/json").build();
        return resp;
    }

    public static Response getSessionResponse(JSONObject jsonMessage) {
        JSONObject respObj = jsonMessage;
        String session = "session";
        Response resp = Response.status((Response.Status)MDfromHTMLResponseCodes.MDfromHTML_OKAY.respCode()).header("Access-Control-Allow-Credentials", (Object)"true").header("Access-Control-Allow-Headers", (Object)"origin, content-type, accept, authorization").header("Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD").header("Access-Control-Allow-Origin", (Object)"*").header("Access_Control_Max_Age", (Object)43200).header("Authorization", (Object)("Basic " + MDfromHTMLBASE64Codec.encode((byte[])("MDfromHTMLadmin:" + session).getBytes()))).entity((Object)respObj.toString()).type("application/json").cookie(new NewCookie[]{NewCookie.valueOf((String)("session=" + session + ";Max-Age=" + 86400 + ";Secure"))}).build();
        return resp;
    }

    static String readResponse(HttpURLConnection con) throws IOException {
        String inputLine;
        int responseCode = con.getResponseCode();
        BufferedReader in = null;
        StringBuffer response = new StringBuffer();
        in = responseCode < 200 || responseCode > 299 ? new BufferedReader(new InputStreamReader(con.getErrorStream())) : new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public static String sendRESTDelete(URL url, JSONObject json) throws Exception {
        try {
            return MDfromHTMLServiceUtil.sendRESTDelete((URL)url, (String)json.serialize(), (String)"Mozilla/5.0");
        }
        catch (Exception e) {
            throw new IOException("Can't serialize json object", e);
        }
    }

    public static String sendRESTDelete(URL url, String deleteContent, String userAgent) throws Exception {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("DELETE");
            if (MDfromHTMLUtils.isUndefined((String)userAgent)) {
                con.setRequestProperty("User-Agent", "Mozilla/5.0");
            } else {
                con.setRequestProperty("User-Agent", userAgent);
            }
            con.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setInstanceFollowRedirects(true);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(deleteContent);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            String response = MDfromHTMLServiceUtil.readResponse((HttpURLConnection)con);
            if (responseCode < 200 || responseCode > 299) {
                throw new Exception(String.valueOf(HTTP_RETURN_CODE) + "=" + responseCode + "," + HTTP_RESPONSE + "=" + response);
            }
            return response;
        }
        catch (Exception e1) {
            throw new IOException("Can not open connection to " + url.toExternalForm(), e1);
        }
    }

    public static String sendRESTGet(URL url) throws Exception {
        return MDfromHTMLServiceUtil.sendRESTGet((URL)url, (String)"Mozilla/5.0");
    }

    public static String sendRESTGet(URL url, String userAgent) throws Exception {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            if (MDfromHTMLUtils.isUndefined((String)userAgent)) {
                con.setRequestProperty("User-Agent", "Mozilla/5.0");
            } else {
                con.setRequestProperty("User-Agent", userAgent);
            }
            con.setInstanceFollowRedirects(true);
            String response = "";
            try {
                int responseCode = con.getResponseCode();
                response = MDfromHTMLServiceUtil.readResponse((HttpURLConnection)con);
                if (responseCode < 200 || responseCode > 299) {
                    throw new Exception(String.valueOf(HTTP_RETURN_CODE) + "=" + responseCode + "," + HTTP_RESPONSE + "=" + response);
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            return response;
        }
        catch (Exception e) {
            throw new IOException("Can not open connection to " + url.toExternalForm(), e);
        }
    }

    public static String sendRESTGetJSON(String urlString, JSONObject queryJSON) throws Exception {
        URL url;
        String queryString = "";
        if (queryJSON != null) {
            try {
                queryString = queryJSON.serialize();
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
        if (queryString.length() > 0) {
            if (!urlString.endsWith("/")) {
                urlString = String.valueOf(urlString) + "/";
            }
            try {
                urlString = String.valueOf(urlString) + URLEncoder.encode(queryString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Exception(e);
            }
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new Exception("\"" + urlString + "\" creates a malformed URL", e);
        }
        return MDfromHTMLServiceUtil.sendRESTGetJSON((URL)url, (String)"Mozilla/5.0");
    }

    public static String sendRESTGetJSON(URL url) throws Exception {
        return MDfromHTMLServiceUtil.sendRESTGetJSON((URL)url, (String)"Mozilla/5.0");
    }

    public static String sendRESTGetJSON(URL url, String userAgent) throws Exception {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            if (MDfromHTMLUtils.isUndefined((String)userAgent)) {
                con.setRequestProperty("User-Agent", "Mozilla/5.0");
            } else {
                con.setRequestProperty("User-Agent", userAgent);
            }
            con.setRequestProperty("Content_Type", "application/json; charset=utf-8");
            con.setInstanceFollowRedirects(true);
            String response = "";
            try {
                int responseCode = con.getResponseCode();
                response = MDfromHTMLServiceUtil.readResponse((HttpURLConnection)con);
                if (responseCode < 200 || responseCode > 299) {
                    throw new Exception(String.valueOf(HTTP_RETURN_CODE) + "=" + responseCode + "," + HTTP_RESPONSE + "=" + response);
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            return response;
        }
        catch (Exception e) {
            throw new IOException("Can not open connection to " + url.toExternalForm(), e);
        }
    }

    public static String sendRESTPatch(URL url, JSONObject json) throws Exception {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("PATCH");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            con.setRequestProperty("Content_Type", "application/json; charset=utf-8");
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setInstanceFollowRedirects(true);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(json.toString());
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            String response = MDfromHTMLServiceUtil.readResponse((HttpURLConnection)con);
            if (responseCode < 200 || responseCode > 299) {
                throw new Exception(String.valueOf(HTTP_RETURN_CODE) + "=" + responseCode + "," + HTTP_RESPONSE + "=" + response);
            }
            return response;
        }
        catch (Exception e1) {
            throw new IOException("Can not open connection to " + url.toExternalForm(), e1);
        }
    }

    public static String sendRESTPatch(URL url, String patchContent) throws Exception {
        return MDfromHTMLServiceUtil.sendRESTPatch((URL)url, (String)patchContent, (String)"Mozilla/5.0");
    }

    public static String sendRESTPatch(URL url, String patchContent, String userAgent) throws Exception {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("PATCH");
            if (MDfromHTMLUtils.isUndefined((String)userAgent)) {
                con.setRequestProperty("User-Agent", "Mozilla/5.0");
            } else {
                con.setRequestProperty("User-Agent", userAgent);
            }
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setInstanceFollowRedirects(true);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(patchContent);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            String response = MDfromHTMLServiceUtil.readResponse((HttpURLConnection)con);
            if (responseCode < 200 || responseCode > 299) {
                throw new Exception(String.valueOf(HTTP_RETURN_CODE) + "=" + responseCode + "," + HTTP_RESPONSE + "=" + response);
            }
            return response;
        }
        catch (Exception e1) {
            throw new IOException("Can not open connection to " + url.toExternalForm(), e1);
        }
    }

    public static String sendRESTPost(URL url, JSONObject json) throws Exception {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            con.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setInstanceFollowRedirects(true);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(json.toString());
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            String response = MDfromHTMLServiceUtil.readResponse((HttpURLConnection)con);
            if (responseCode < 200 || responseCode > 299) {
                throw new Exception(String.valueOf(HTTP_RETURN_CODE) + "=" + responseCode + "," + HTTP_RESPONSE + "=" + response);
            }
            return response;
        }
        catch (Exception e1) {
            throw new IOException("Can not open connection to " + url.toExternalForm(), e1);
        }
    }

    public static String sendRESTPost(URL url, String postContent) throws Exception {
        return MDfromHTMLServiceUtil.sendRESTPost((URL)url, (String)postContent, (String)"Mozilla/5.0");
    }

    public static String sendRESTPost(URL url, String postContent, String userAgent) throws Exception {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            if (MDfromHTMLUtils.isUndefined((String)userAgent)) {
                con.setRequestProperty("User-Agent", "Mozilla/5.0");
            } else {
                con.setRequestProperty("User-Agent", userAgent);
            }
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setInstanceFollowRedirects(true);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(postContent);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            String response = MDfromHTMLServiceUtil.readResponse((HttpURLConnection)con);
            if (responseCode < 200 || responseCode > 299) {
                throw new Exception(String.valueOf(HTTP_RETURN_CODE) + "=" + responseCode + "," + HTTP_RESPONSE + "=" + response);
            }
            return response;
        }
        catch (Exception e1) {
            throw new IOException("Can not open connection to " + url.toExternalForm(), e1);
        }
    }

    public static String sendRESTPut(URL url, JSONObject json) throws Exception {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("PUT");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            con.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setInstanceFollowRedirects(true);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(json.toString());
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            String response = MDfromHTMLServiceUtil.readResponse((HttpURLConnection)con);
            if (responseCode < 200 || responseCode > 299) {
                throw new Exception(String.valueOf(HTTP_RETURN_CODE) + "=" + responseCode + "," + HTTP_RESPONSE + "=" + response);
            }
            return response;
        }
        catch (Exception e1) {
            throw new IOException("Can not open connection to " + url.toExternalForm(), e1);
        }
    }

    public static String sendRESTPut(URL url, String putContent) throws Exception {
        return MDfromHTMLServiceUtil.sendRESTPut((URL)url, (String)putContent, (String)"Mozilla/5.0");
    }

    public static String sendRESTPut(URL url, String putContent, String userAgent) throws Exception {
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("PUT");
            if (MDfromHTMLUtils.isUndefined((String)userAgent)) {
                con.setRequestProperty("User-Agent", "Mozilla/5.0");
            } else {
                con.setRequestProperty("User-Agent", userAgent);
            }
            con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            con.setInstanceFollowRedirects(true);
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(putContent);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            String response = MDfromHTMLServiceUtil.readResponse((HttpURLConnection)con);
            if (responseCode < 200 || responseCode > 299) {
                throw new Exception(String.valueOf(HTTP_RETURN_CODE) + "=" + responseCode + "," + HTTP_RESPONSE + "=" + response);
            }
            return response;
        }
        catch (Exception e1) {
            throw new Exception("Can not open connection to " + url.toExternalForm(), e1);
        }
    }
}

