/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.services;

import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.mdfromhtml.services.MDfromHTMLResponseCodes;
import com.mdfromhtml.services.MDfromHTMLServiceUtil;
import com.mdfromhtml.services.Patch;
import com.mdfromhtml.services.ServicesManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/")
public class MDfromHTMLWebServices
implements Serializable {
    public static final String ACTION = "action";
    public static final String ACTION_COMMAND = "actionCommand";
    public static final String ACTION_TYPE = "actionType";
    public static final String ACTIONS = "actions";
    public static final String ACTIVITIES = "activities";
    public static final String ACTIVITY = "activity";
    public static final String ACTIVITY_GRAPH = "activityGraph";
    public static final String ACTIVITY_ID = "activityId";
    public static final String ARRAY = "array";
    public static final String BODY = "body";
    public static final String CHILDREN = "children";
    public static final String COLS = "Cols";
    public static final String COMPLETE = "complete";
    public static final String CONSTANT = "constant";
    static final boolean debug = true;
    public static final String DELETE = "delete";
    public static final String DETAILS = "details";
    public static final String ERRANT_JSON_STRING = "JSON Generation Error: []";
    public static final String GET = "get";
    public static final String GOAL = "goal";
    public static final String GOALS = "goals";
    public static final String INPUTS = "inputs";
    public static final String JSON_REQUEST = "jsonRequest";
    public static final String NAME = "name";
    public static final String OBJID = "id";
    public static final String OPTOINS = "options";
    public static final String OUTPUTS = "outputs";
    public static final String PARAMETERS = "parameters";
    public static final String PARENT_ID = "parentId";
    public static final String PATCH = "patch";
    public static final String PATH = "path";
    public static final String PLAN = "plan";
    public static final String PLANNING_STAGE = "planningStage";
    public static final String POST = "post";
    public static final String PRECONDITIONS = "preconditions";
    public static final String PUB_VERB = "pubVerb";
    public static final String PUBLISH = "publish";
    public static final String PUT = "put";
    public static final String QUERIES = "queries";
    public static final String QUERY = "query";
    public static final String QUERY_NAME = "queryName";
    public static final String QUERY_RESULT = "queryResult";
    public static final String REL_INCOMING = "rel_incoming";
    public static final String REL_OUTGOING = "rel_outgoing";
    public static final String RESPONSE = "response";
    public static final String RESPONSE_TOKEN = "responseToken";
    public static final String RESULTS = "results";
    public static final String RETURN = "return";
    public static final String RETURN_VALUES = "returnValues";
    public static final String ROWS = "Rows";
    public static final String SCHEMA = "schema";
    public static final String SERVICE_URI_STEM = "serviceURIStem";
    public static final String STATUS = "status";
    public static final String TOPIC = "topic";
    public static final String TYPE = "type";
    public static final String USER_ID = "userId";
    public static final String VALUE = "value";
    public static final String WAITING = "waiting";
    @Inject
    public ServicesManager _servicesManager;

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{topic}/{type}")
    public Response doDeleteV1(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="topic") String topic, @PathParam(value="type") String type, InputStream jsonRequest) {
        JSONObject request = null;
        try {
            request = JSONObject.parse((InputStream)jsonRequest);
        }
        catch (IOException e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_INVALID_JSON_GET_REQUEST);
        }
        try {
            JSONObject serviceLogic;
            URI uri = uriInfo.getAbsolutePath();
            String path = uri.getPath();
            String requestType = topic;
            if (!MDfromHTMLUtils.isUndefined((String)type)) {
                requestType = String.valueOf(requestType) + "/" + type;
            }
            if ((serviceLogic = (JSONObject)ServicesManager.deleteRequests.get((Object)requestType)) == null) {
                return MDfromHTMLServiceUtil.getErrorResponse((String)("No DELETE service registered for \"" + requestType + "\" for path \"" + path + "\""), (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_CLASS_NOT_FOUND);
            }
            JSONObject actionResponses = new JSONObject();
            JSONArray actions = (JSONArray)serviceLogic.get((Object)ACTIONS);
            for (JSONObject action : actions) {
                ServicesManager.performAction((String)DELETE, (JSONObject)request, (JSONObject)action, (JSONObject)actionResponses);
            }
            return MDfromHTMLServiceUtil.getResponse((JSONObject)actionResponses);
        }
        catch (Exception e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_UNEXPECTED_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{topic}/{jsonRequest}")
    public Response doGetV1(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="topic") String topic, @PathParam(value="jsonRequest") String jsonRequest) {
        JSONObject request = new JSONObject();
        if (jsonRequest.startsWith("{") && jsonRequest.endsWith("}")) {
            try {
                request = JSONObject.parse((String)jsonRequest);
            }
            catch (IOException e) {
                return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_INVALID_JSON_GET_REQUEST);
            }
        }
        try {
            URI uri = uriInfo.getAbsolutePath();
            String path = uri.getPath();
            JSONObject serviceLogic = (JSONObject)ServicesManager.getRequests.get((Object)topic);
            if (serviceLogic == null) {
                return MDfromHTMLServiceUtil.getErrorResponse((String)("No GET service registered for \"" + topic + "\" for path \"" + path + "\""), (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_CLASS_NOT_FOUND);
            }
            JSONObject actionResponses = new JSONObject();
            JSONArray actions = (JSONArray)serviceLogic.get((Object)ACTIONS);
            for (JSONObject action : actions) {
                ServicesManager.performAction((String)GET, (JSONObject)request, (JSONObject)action, (JSONObject)actionResponses);
            }
            return MDfromHTMLServiceUtil.getResponse((JSONObject)actionResponses);
        }
        catch (Exception e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_SESSION_ID_NOT_FOUND);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{topic}/{type}/{jsonRequest}")
    public Response doGetV1(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="topic") String topic, @PathParam(value="type") String type, @PathParam(value="jsonRequest") String jsonRequest) {
        JSONObject request = null;
        try {
            request = JSONObject.parse((String)jsonRequest);
        }
        catch (IOException e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_INVALID_JSON_GET_REQUEST);
        }
        try {
            URI uri = uriInfo.getAbsolutePath();
            String path = uri.getPath();
            JSONObject serviceLogic = (JSONObject)ServicesManager.getRequests.get((Object)(String.valueOf(topic) + "/" + type));
            if (serviceLogic == null) {
                return MDfromHTMLServiceUtil.getErrorResponse((String)("No GET service registered for \"" + topic + "/" + type + "\" for path \"" + path + "\""), (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_CLASS_NOT_FOUND);
            }
            JSONObject actionResponses = new JSONObject();
            JSONArray actions = (JSONArray)serviceLogic.get((Object)ACTIONS);
            for (JSONObject action : actions) {
                ServicesManager.performAction((String)GET, (JSONObject)request, (JSONObject)action, (JSONObject)actionResponses);
            }
            return MDfromHTMLServiceUtil.getResponse((JSONObject)actionResponses);
        }
        catch (Exception e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_UNEXPECTED_ERROR);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{topic}")
    public Response doGetV1NoParams(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="topic") String topic) {
        JSONObject request = new JSONObject();
        try {
            URI uri = uriInfo.getAbsolutePath();
            String path = uri.getPath();
            JSONObject serviceLogic = (JSONObject)ServicesManager.getRequests.get((Object)topic);
            if (serviceLogic == null) {
                return MDfromHTMLServiceUtil.getErrorResponse((String)("No GET service registered for \"" + topic + "\" for path \"" + path + "\""), (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_CLASS_NOT_FOUND);
            }
            JSONObject actionResponses = new JSONObject();
            JSONArray actions = (JSONArray)serviceLogic.get((Object)ACTIONS);
            for (JSONObject action : actions) {
                ServicesManager.performAction((String)GET, (JSONObject)request, (JSONObject)action, (JSONObject)actionResponses);
            }
            return MDfromHTMLServiceUtil.getResponse((JSONObject)actionResponses);
        }
        catch (Exception e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_UNEXPECTED_ERROR);
        }
    }

    @Patch.PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{topic}/{type}")
    public Response doPatchV1(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="topic") String topic, @PathParam(value="type") String type, InputStream jsonRequest) {
        JSONObject request = null;
        try {
            request = JSONObject.parse((InputStream)jsonRequest);
        }
        catch (IOException e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_INVALID_JSON_GET_REQUEST);
        }
        try {
            JSONObject serviceLogic;
            URI uri = uriInfo.getAbsolutePath();
            String path = uri.getPath();
            String requestType = topic;
            if (!MDfromHTMLUtils.isUndefined((String)type)) {
                requestType = String.valueOf(requestType) + "/" + type;
            }
            if ((serviceLogic = (JSONObject)ServicesManager.putRequests.get((Object)requestType)) == null) {
                return MDfromHTMLServiceUtil.getErrorResponse((String)("No PATCH service registered for \"" + requestType + "\" for path \"" + path + "\""), (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_CLASS_NOT_FOUND);
            }
            JSONObject actionResponses = new JSONObject();
            JSONArray actions = (JSONArray)serviceLogic.get((Object)ACTIONS);
            for (JSONObject action : actions) {
                ServicesManager.performAction((String)PATCH, (JSONObject)request, (JSONObject)action, (JSONObject)actionResponses);
            }
            return MDfromHTMLServiceUtil.getResponse((JSONObject)actionResponses);
        }
        catch (Exception e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_UNEXPECTED_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{topic}/{type}")
    public Response doPostV1(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="topic") String topic, @PathParam(value="type") String type, InputStream jsonRequest) {
        JSONObject request = null;
        try {
            request = JSONObject.parse((InputStream)jsonRequest);
        }
        catch (IOException e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_INVALID_JSON_GET_REQUEST);
        }
        try {
            JSONObject serviceLogic;
            URI uri = uriInfo.getAbsolutePath();
            String path = uri.getPath();
            String requestType = topic;
            if (!MDfromHTMLUtils.isUndefined((String)type)) {
                requestType = String.valueOf(requestType) + "/" + type;
            }
            if ((serviceLogic = (JSONObject)ServicesManager.postRequests.get((Object)requestType)) == null) {
                return MDfromHTMLServiceUtil.getErrorResponse((String)("No POST service registered for \"" + requestType + "\" for path \"" + path + "\""), (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_CLASS_NOT_FOUND);
            }
            JSONObject actionResponses = new JSONObject();
            JSONArray actions = (JSONArray)serviceLogic.get((Object)ACTIONS);
            for (JSONObject action : actions) {
                ServicesManager.performAction((String)POST, (JSONObject)request, (JSONObject)action, (JSONObject)actionResponses);
            }
            return MDfromHTMLServiceUtil.getResponse((JSONObject)actionResponses);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_UNEXPECTED_ERROR);
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{topic}/{type}")
    public Response doPutV1(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="topic") String topic, @PathParam(value="type") String type, InputStream jsonRequest) {
        JSONObject request = null;
        try {
            request = JSONObject.parse((InputStream)jsonRequest);
        }
        catch (IOException e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_INVALID_JSON_GET_REQUEST);
        }
        try {
            JSONObject serviceLogic;
            URI uri = uriInfo.getAbsolutePath();
            String path = uri.getPath();
            String requestType = topic;
            if (!MDfromHTMLUtils.isUndefined((String)type)) {
                requestType = String.valueOf(requestType) + "/" + type;
            }
            if ((serviceLogic = (JSONObject)ServicesManager.putRequests.get((Object)requestType)) == null) {
                return MDfromHTMLServiceUtil.getErrorResponse((String)("No PUT service registered for \"" + requestType + "\" for path \"" + path + "\""), (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_CLASS_NOT_FOUND);
            }
            JSONObject actionResponses = new JSONObject();
            JSONArray actions = (JSONArray)serviceLogic.get((Object)ACTIONS);
            for (JSONObject action : actions) {
                ServicesManager.performAction((String)PUT, (JSONObject)request, (JSONObject)action, (JSONObject)actionResponses);
            }
            return MDfromHTMLServiceUtil.getResponse((JSONObject)actionResponses);
        }
        catch (Exception e) {
            return MDfromHTMLServiceUtil.getErrorResponse((Throwable)e, (MDfromHTMLResponseCodes)MDfromHTMLResponseCodes.MDfromHTML_UNEXPECTED_ERROR);
        }
    }
}

