/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.services;

import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLConstants;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.mdfromhtml.services.ParameterUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.ManagedBean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;

@Singleton
@ManagedBean
public class ServicesManager
implements Serializable {
    public static boolean debug = false;
    public static JSONObject deleteRequests = new JSONObject();
    public static JSONObject getRequests = new JSONObject();
    public static JSONObject postRequests = new JSONObject();
    public static JSONObject putRequests = new JSONObject();
    protected static int responseToken = 0;
    private static final long serialVersionUID = -2206805773040898651L;

    static {
        if (debug) {
            System.out.println("Initializing Service");
        }
        try {
            JSONObject services = MDfromHTMLUtils.loadJSONFile((String)(String.valueOf(MDfromHTMLConstants.MDfromHTML_DIR_PROPERTIES) + "MDfromHTML_RESTServicesSchema.json"));
            JSONObject schema = (JSONObject)services.get((Object)"schema");
            if (schema == null) {
                throw new Exception("Request is missing schema object.");
            }
            JSONObject MDfromHTMLSchema = (JSONObject)schema.get((Object)"MDfromHTML");
            if (MDfromHTMLSchema == null) {
                throw new Exception("Request is missing MDfromHTML object.");
            }
            JSONObject requests = (JSONObject)MDfromHTMLSchema.get((Object)"requests");
            if (requests == null || requests.size() == 0) {
                throw new Exception("Can not find requests for the MDfromHTML schema in MDfromHTML_RESTServicesSchema.json");
            }
            getRequests = (JSONObject)requests.get((Object)"get");
            if (getRequests == null) {
                throw new Exception("Can not find get requests for the MDfromHTML schema in MDfromHTML_RESTServicesSchema.json");
            }
            putRequests = (JSONObject)requests.get((Object)"put");
            if (putRequests == null) {
                throw new Exception("Can not find put requests for the MDfromHTML schema in MDfromHTML_RESTServicesSchema.json");
            }
            postRequests = (JSONObject)requests.get((Object)"post");
            if (postRequests == null) {
                throw new Exception("Can not find post requests for the MDfromHTML schema in MDfromHTML_RESTServicesSchema.json");
            }
            deleteRequests = (JSONObject)requests.get((Object)"delete");
            if (deleteRequests == null) {
                throw new Exception("Can not find delete requests for the MDfromHTML schema in MDfromHTML_RESTServicesSchema.json");
            }
        }
        catch (Exception e) {
            throw new Error("Can not initialize ServicesManager due to errors:  " + e.getMessage(), e);
        }
    }

    protected static Set<String> getPublishTopics(JSONObject reqType) throws Exception {
        HashSet<String> retSet = new HashSet<String>();
        if (reqType == null) {
            throw new Exception("null request type");
        }
        Set keys = reqType.keySet();
        for (Object key : keys) {
            JSONArray actions;
            JSONObject request = (JSONObject)reqType.get(key);
            if (request == null) {
                throw new Exception("Can not get reqeust for key=" + key);
            }
            if (debug) {
                System.out.println("Processing request \"" + key + "\"");
            }
            if ((actions = (JSONArray)request.get((Object)"actions")) == null) {
                throw new Exception("Can not find actions in request for key=" + key);
            }
            for (JSONObject action : actions) {
                JSONArray pubArray = (JSONArray)action.get((Object)"publish");
                if (pubArray == null) continue;
                for (JSONObject pubObj : pubArray) {
                    Object topicName;
                    if (pubObj == null || (topicName = pubObj.get((Object)"topic")) == null) continue;
                    retSet.add(topicName.toString());
                }
            }
        }
        return retSet;
    }

    public static synchronized int getResponseToken() {
        return ++responseToken;
    }

    public static void main(String ... args) {
        System.out.println("ServicesManager");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void performAction(String verb, JSONObject request, JSONObject action, JSONObject actionResponse) throws Exception {
        String className;
        if (request == null) {
            throw new Exception("null request received.");
        }
        if (debug) {
            System.out.println("Request: " + request.toString());
        }
        if (action == null) {
            throw new Exception("null action received.");
        }
        if (debug) {
            System.out.println("Action: " + action.toString());
        }
        if (actionResponse == null) {
            throw new Exception("null actionResponse received.");
        }
        if (debug) {
            System.out.println("Action Response: " + actionResponse.toString());
        }
        if ((className = (String)action.get((Object)"class")) == null) {
            throw new Exception("Action is missing a class name.");
        }
        if (debug) {
            System.out.println("Loading class " + className);
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (!debug) throw new Exception("Can not load class \"" + className + "\"", e);
            System.err.println("Can not load class \"" + className + "\"");
            throw new Exception("Can not load class \"" + className + "\"", e);
        }
        String methodName = (String)action.get((Object)"method");
        JSONArray paramArray = (JSONArray)action.get((Object)"params");
        Method method = null;
        StringBuffer sb = new StringBuffer();
        String retKey = (String)action.get((Object)"return");
        if (paramArray != null) {
            ArrayList<String> paramDefs = new ArrayList<String>();
            try {
                Object object;
                block37: {
                    Iterator iterator;
                    StringBuffer sbData;
                    List paramData;
                    ArrayList paramClasses = new ArrayList();
                    Iterator it = paramArray.iterator();
                    block12: while (true) {
                        Object paramClassName;
                        if (!it.hasNext()) {
                            paramData = ParameterUtils.getParameterData((JSONObject)request, (String)className, (String)methodName, (String[])paramDefs.toArray(new String[0]));
                            if (methodName == null) return;
                            StringBuffer sbCls = new StringBuffer();
                            try {
                                paramClassName = paramClasses.iterator();
                                while (true) {
                                    if (!paramClassName.hasNext()) {
                                        if (debug) {
                                            System.out.print("Loading method " + className + "." + methodName + "(");
                                            System.out.print(sbCls);
                                            System.out.println(")");
                                        }
                                        method = cls.getMethod(methodName, paramClasses.toArray(new Class[0]));
                                        break block12;
                                    }
                                    Class clazz = (Class)paramClassName.next();
                                    sbCls.append(",");
                                    sbCls.append(clazz.getName());
                                }
                            }
                            catch (Exception exception) {
                                if (!debug) throw new Exception(String.valueOf(className) + ":" + methodName + ": Can not find method named \"" + methodName + "\" with parameters " + sb.substring(0, sb.length() - 1) + " in class " + cls.getName());
                                System.err.println(String.valueOf(className) + ":" + methodName + ": Can not find method named \"" + methodName + "\" with parameters " + sbCls.substring(0, sbCls.length() - 1) + " in class " + cls.getName());
                                throw new Exception(String.valueOf(className) + ":" + methodName + ": Can not find method named \"" + methodName + "\" with parameters " + sb.substring(0, sb.length() - 1) + " in class " + cls.getName());
                            }
                        }
                        String param = it.next().toString();
                        paramDefs.add(param);
                        String[] stringArray = param.split(":");
                        if (stringArray.length == 1) {
                            paramClasses.add(String.class);
                            sb.append(String.class.getName());
                            continue;
                        }
                        if (stringArray.length != 2) {
                            throw new Exception(String.valueOf(className) + ":" + methodName + ": Malformed parameter definition. Should either be a single String or a String:ClassName. \"" + param + "\"");
                        }
                        paramClassName = param.split(":")[1].toString();
                        sb.append((String)paramClassName);
                        sb.append(",");
                        Class<?> paramCls = null;
                        if (debug) {
                            System.out.println(String.valueOf(className) + ":" + methodName + ": Loading Parameter class " + (String)paramClassName);
                        }
                        try {
                            paramCls = Class.forName((String)paramClassName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new Exception(String.valueOf(className) + ":" + methodName + ": Can not load class named \"" + (String)paramClassName + "\"", e);
                        }
                        paramClasses.add(paramCls);
                    }
                    method.setAccessible(true);
                    Object var15_23 = null;
                    try {
                        object = method.invoke(null, paramData.toArray(new Object[0]));
                        break block37;
                    }
                    catch (Exception e) {
                        sbData = new StringBuffer();
                        iterator = paramData.iterator();
                    }
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw new Exception(String.valueOf(className) + ":" + methodName + ": Error invoking method \"" + methodName + "\" with parameters " + sbData.substring(0, sbData.length() - 1) + "   Cause: " + e.getCause(), e);
                        }
                        Object obj = iterator.next();
                        if (obj != null) {
                            sbData.append(obj.toString());
                        } else {
                            sbData.append("null");
                        }
                        sbData.append(",");
                    }
                }
                if (retKey == null) return;
                if (!(object instanceof JSONObject)) {
                    actionResponse.put(retKey, object);
                    return;
                }
                if (((JSONObject)object).get((Object)retKey) != null) {
                    actionResponse.put(retKey, ((JSONObject)object).get((Object)retKey));
                    return;
                }
                actionResponse.put(retKey, object);
                return;
            }
            catch (Exception e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
        }
        try {
            method = cls.getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Object retVal = method.invoke(null, new Object[0]);
            if (retKey == null) return;
            if (!(retVal instanceof JSONObject)) {
                actionResponse.put(retKey, retVal);
                return;
            }
            if (((JSONObject)retVal).get((Object)retKey) != null) {
                actionResponse.put(retKey, ((JSONObject)retVal).get((Object)retKey));
                return;
            }
            actionResponse.put(retKey, retVal);
            return;
        }
        catch (Exception e) {
            throw new Exception("Can not find method named \"" + methodName + "\" in class " + cls.getName());
        }
    }

    @PreDestroy
    public void cleanup() {
    }

    @PostConstruct
    public void startup() {
        if (debug) {
            System.out.println("Creating Connection Pool");
        }
        if (debug) {
            System.out.println("Opening IPC");
        }
    }
}

