/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.forms.form.renderer.AbstractFormFieldRenderer;
import com.itextpdf.forms.form.renderer.FormFieldValueNonTrimmingTextRenderer;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTextFieldRenderer
extends AbstractFormFieldRenderer {
    protected PdfFont font;

    AbstractTextFieldRenderer(IFormField modelElement) {
        super(modelElement);
    }

    IRenderer createParagraphRenderer(String defaultValue) {
        if (defaultValue.isEmpty()) {
            defaultValue = "\u00a0";
        }
        Text text = new Text(defaultValue);
        FormFieldValueNonTrimmingTextRenderer nextRenderer = new FormFieldValueNonTrimmingTextRenderer(text);
        text.setNextRenderer((IRenderer)nextRenderer);
        return ((Paragraph)new Paragraph(text).setMargin(0.0f)).createRendererSubTree();
    }

    void applyDefaultFieldProperties(PdfFormField inputField) {
        inputField.getWidgets().get(0).setHighlightMode(PdfAnnotation.HIGHLIGHT_NONE);
        TransparentColor color = this.getPropertyAsTransparentColor(21);
        if (color != null) {
            inputField.setColor(color.getColor());
        }
        inputField.setJustification((TextAlignment)this.getProperty(70));
        this.applyBorderProperty(inputField.getFirstFormAnnotation());
        Background background = (Background)this.getProperty(6);
        if (background != null) {
            inputField.getFirstFormAnnotation().setBackgroundColor(background.getColor());
        }
    }

    float getHeightRowsBased(List<LineRenderer> lines, Rectangle bBox, int rows) {
        float averageLineHeight = bBox.getHeight() / (float)lines.size();
        return averageLineHeight * (float)rows;
    }

    void updatePdfFont(ParagraphRenderer renderer) {
        if (renderer != null) {
            Object retrievedFont;
            List lines = renderer.getLines();
            if (lines != null) {
                for (LineRenderer line : lines) {
                    for (IRenderer child : line.getChildRenderers()) {
                        retrievedFont = child.getProperty(20);
                        if (!(retrievedFont instanceof PdfFont)) continue;
                        this.font = (PdfFont)retrievedFont;
                        return;
                    }
                }
            }
            if ((retrievedFont = renderer.getProperty(20)) instanceof PdfFont) {
                this.font = (PdfFont)retrievedFont;
            }
        }
    }

    float approximateFontSize(LayoutContext layoutContext, float lFontSize, float rFontSize) {
        IRenderer flatRenderer = this.createFlatRenderer().setParent((IRenderer)this);
        Float areaWidth = this.retrieveWidth(layoutContext.getArea().getBBox().getWidth());
        Float areaHeight = this.retrieveHeight();
        if (areaWidth == null || areaHeight == null) {
            return -1.0f;
        }
        flatRenderer.setProperty(24, (Object)UnitValue.createPointValue((float)12.0f));
        LayoutContext newLayoutContext = new LayoutContext(new LayoutArea(1, new Rectangle(areaWidth.floatValue(), areaHeight.floatValue())));
        if (flatRenderer.layout(newLayoutContext).getStatus() == 1) {
            return -1.0f;
        }
        int numberOfIterations = 6;
        return this.calculateFittingFontSize(flatRenderer, lFontSize, rFontSize, newLayoutContext, 6);
    }

    float calculateFittingFontSize(IRenderer renderer, float lFontSize, float rFontSize, LayoutContext newLayoutContext, int numberOfIterations) {
        for (int i = 0; i < numberOfIterations; ++i) {
            float mFontSize = (lFontSize + rFontSize) / 2.0f;
            renderer.setProperty(24, (Object)UnitValue.createPointValue((float)mFontSize));
            LayoutResult result = renderer.layout(newLayoutContext);
            if (result.getStatus() == 1) {
                lFontSize = mFontSize;
                continue;
            }
            rFontSize = mFontSize;
        }
        return lFontSize;
    }

    float updateHtmlColsSizeBasedWidth(float width) {
        if (BoxSizingPropertyValue.BORDER_BOX == this.getProperty(105)) {
            Rectangle dummy = new Rectangle(width, 0.0f);
            this.applyBorderBox(dummy, true);
            this.applyPaddings(dummy, true);
            return dummy.getWidth();
        }
        return width;
    }

    void adjustNumberOfContentLines(List<LineRenderer> lines, Rectangle bBox, int rows) {
        if (lines.size() != rows) {
            float rowsHeight = this.getHeightRowsBased(lines, bBox, rows);
            AbstractTextFieldRenderer.adjustNumberOfContentLines(lines, bBox, rows, rowsHeight);
        }
    }

    void adjustNumberOfContentLines(List<LineRenderer> lines, Rectangle bBox, float height) {
        float averageLineHeight = bBox.getHeight() / (float)lines.size();
        if (averageLineHeight > 1.0E-4f) {
            int visibleLinesNumber = (int)Math.ceil(height / averageLineHeight);
            AbstractTextFieldRenderer.adjustNumberOfContentLines(lines, bBox, visibleLinesNumber, height);
        }
    }

    float getLowestChildBottom(IRenderer renderer, float value) {
        float lowestChildBottom = value;
        for (IRenderer child : renderer.getChildRenderers()) {
            lowestChildBottom = this.getLowestChildBottom(child, lowestChildBottom);
            if (child.getOccupiedArea() == null || !(child.getOccupiedArea().getBBox().getBottom() < lowestChildBottom)) continue;
            lowestChildBottom = child.getOccupiedArea().getBBox().getBottom();
        }
        return lowestChildBottom;
    }

    private static void adjustNumberOfContentLines(List<LineRenderer> lines, Rectangle bBox, int linesNumber, float height) {
        bBox.moveUp(bBox.getHeight() - height);
        bBox.setHeight(height);
        if (lines.size() > linesNumber) {
            ArrayList<LineRenderer> subList = new ArrayList<LineRenderer>(lines.subList(0, linesNumber));
            lines.clear();
            lines.addAll(subList);
        }
    }
}

