/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.io.font.cmap.AbstractCMap;
import com.itextpdf.io.font.cmap.CMapCidToCodepoint;
import com.itextpdf.io.font.cmap.CMapObject;
import com.itextpdf.io.util.IntHashtable;

public class CMapCodepointToCid
extends AbstractCMap {
    private final IntHashtable map;

    public CMapCodepointToCid() {
        this.map = new IntHashtable();
    }

    public CMapCodepointToCid(CMapCidToCodepoint reverseMap) {
        this.map = reverseMap.getReversMap();
    }

    @Override
    void addChar(String mark, CMapObject code) {
        if (code.isNumber()) {
            byte[] ser = CMapCodepointToCid.decodeStringToByte(mark);
            int byteCode = 0;
            for (byte b : ser) {
                byteCode <<= 8;
                byteCode += b & 0xFF;
            }
            this.map.put(byteCode, (Integer)code.getValue());
        }
    }

    public int lookup(int codepoint) {
        return this.map.get(codepoint);
    }
}

