/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.filters;

import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.MemoryLimitsAwareFilter;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import java.io.ByteArrayOutputStream;

public class ASCII85DecodeFilter
extends MemoryLimitsAwareFilter {
    @Override
    public byte[] decode(byte[] b, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) {
        ByteArrayOutputStream outputStream = this.enableMemoryLimitsAwareHandler(streamDictionary);
        b = ASCII85DecodeFilter.ASCII85Decode(b, outputStream);
        return b;
    }

    public static byte[] ASCII85Decode(byte[] in) {
        return ASCII85DecodeFilter.ASCII85Decode(in, new ByteArrayOutputStream());
    }

    private static byte[] ASCII85Decode(byte[] in, ByteArrayOutputStream out) {
        int r;
        int ch;
        int state = 0;
        int[] chn = new int[5];
        for (int k = 0; k < in.length && (ch = in[k] & 0xFF) != 126; ++k) {
            if (PdfTokenizer.isWhitespace((int)ch)) continue;
            if (ch == 122 && state == 0) {
                out.write(0);
                out.write(0);
                out.write(0);
                out.write(0);
                continue;
            }
            if (ch < 33 || ch > 117) {
                throw new PdfException("Illegal character in ASCII85Decode.");
            }
            chn[state] = ch - 33;
            if (++state != 5) continue;
            state = 0;
            int r2 = 0;
            for (int j = 0; j < 5; ++j) {
                r2 = r2 * 85 + chn[j];
            }
            out.write((byte)(r2 >> 24));
            out.write((byte)(r2 >> 16));
            out.write((byte)(r2 >> 8));
            out.write((byte)r2);
        }
        if (state == 2) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + 614125 + 7225 + 85;
            out.write((byte)(r >> 24));
        } else if (state == 3) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85 + 7225 + 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
        } else if (state == 4) {
            r = chn[0] * 85 * 85 * 85 * 85 + chn[1] * 85 * 85 * 85 + chn[2] * 85 * 85 + chn[3] * 85 + 85;
            out.write((byte)(r >> 24));
            out.write((byte)(r >> 16));
            out.write((byte)(r >> 8));
        }
        return out.toByteArray();
    }
}

