/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.geom;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Rectangle
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8025677415569233446L;
    private static float EPS = 1.0E-4f;
    protected float x;
    protected float y;
    protected float width;
    protected float height;

    public Rectangle(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(float width, float height) {
        this(0.0f, 0.0f, width, height);
    }

    public Rectangle(Rectangle rect) {
        this(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static Rectangle getCommonRectangle(Rectangle ... rectangles) {
        float ury = -3.4028235E38f;
        float llx = Float.MAX_VALUE;
        float lly = Float.MAX_VALUE;
        float urx = -3.4028235E38f;
        for (Rectangle rectangle : rectangles) {
            if (rectangle == null) continue;
            Rectangle rec = rectangle.clone();
            if (rec.getY() < lly) {
                lly = rec.getY();
            }
            if (rec.getX() < llx) {
                llx = rec.getX();
            }
            if (rec.getY() + rec.getHeight() > ury) {
                ury = rec.getY() + rec.getHeight();
            }
            if (!(rec.getX() + rec.getWidth() > urx)) continue;
            urx = rec.getX() + rec.getWidth();
        }
        return new Rectangle(llx, lly, urx - llx, ury - lly);
    }

    public static Rectangle getRectangleOnRotatedPage(Rectangle rect, PdfPage page) {
        Rectangle resultRect = rect;
        int rotation = page.getRotation();
        if (0 != rotation) {
            Rectangle pageSize = page.getPageSize();
            switch (rotation / 90 % 4) {
                case 1: {
                    resultRect = new Rectangle(pageSize.getWidth() - resultRect.getTop(), resultRect.getLeft(), resultRect.getHeight(), resultRect.getWidth());
                    break;
                }
                case 2: {
                    resultRect = new Rectangle(pageSize.getWidth() - resultRect.getRight(), pageSize.getHeight() - resultRect.getTop(), resultRect.getWidth(), resultRect.getHeight());
                    break;
                }
                case 3: {
                    resultRect = new Rectangle(resultRect.getLeft(), pageSize.getHeight() - resultRect.getRight(), resultRect.getHeight(), resultRect.getWidth());
                    break;
                }
            }
        }
        return resultRect;
    }

    public static Rectangle calculateBBox(List<Point> points) {
        ArrayList<Double> xs = new ArrayList<Double>();
        ArrayList<Double> ys = new ArrayList<Double>();
        for (Point point : points) {
            xs.add(point.getX());
            ys.add(point.getY());
        }
        double left = (Double)Collections.min(xs);
        double bottom = (Double)Collections.min(ys);
        double right = (Double)Collections.max(xs);
        double top = (Double)Collections.max(ys);
        return new Rectangle((float)left, (float)bottom, (float)(right - left), (float)(top - bottom));
    }

    public Rectangle getIntersection(Rectangle rect) {
        Rectangle result = null;
        float llx = Math.max(this.x, rect.x);
        float lly = Math.max(this.y, rect.y);
        float urx = Math.min(this.getRight(), rect.getRight());
        float ury = Math.min(this.getTop(), rect.getTop());
        float width = urx - llx;
        float height = ury - lly;
        if (Float.compare(width, 0.0f) >= 0 && Float.compare(height, 0.0f) >= 0) {
            if (Float.compare(width, 0.0f) < 0) {
                width = 0.0f;
            }
            if (Float.compare(height, 0.0f) < 0) {
                height = 0.0f;
            }
            result = new Rectangle(llx, lly, width, height);
        }
        return result;
    }

    public boolean contains(Rectangle rect) {
        float llx = this.getX();
        float lly = this.getY();
        float urx = llx + this.getWidth();
        float ury = lly + this.getHeight();
        float rllx = rect.getX();
        float rlly = rect.getY();
        float rurx = rllx + rect.getWidth();
        float rury = rlly + rect.getHeight();
        return llx - EPS <= rllx && lly - EPS <= rlly && rurx <= urx + EPS && rury <= ury + EPS;
    }

    public boolean overlaps(Rectangle rect) {
        return !(this.getX() + this.getWidth() < rect.getX() || this.getY() + this.getHeight() < rect.getY() || this.getX() > rect.getX() + rect.getWidth() || this.getY() > rect.getY() + rect.getHeight());
    }

    public Rectangle setBbox(float llx, float lly, float urx, float ury) {
        float temp;
        if (llx > urx) {
            temp = llx;
            llx = urx;
            urx = temp;
        }
        if (lly > ury) {
            temp = lly;
            lly = ury;
            ury = temp;
        }
        this.x = llx;
        this.y = lly;
        this.width = urx - llx;
        this.height = ury - lly;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public Rectangle setX(float x) {
        this.x = x;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Rectangle setY(float y) {
        this.y = y;
        return this;
    }

    public float getWidth() {
        return this.width;
    }

    public Rectangle setWidth(float width) {
        this.width = width;
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    public Rectangle setHeight(float height) {
        this.height = height;
        return this;
    }

    public Rectangle increaseHeight(float extra) {
        this.height += extra;
        return this;
    }

    public Rectangle decreaseHeight(float extra) {
        this.height -= extra;
        return this;
    }

    public float getLeft() {
        return this.x;
    }

    public float getRight() {
        return this.x + this.width;
    }

    public float getTop() {
        return this.y + this.height;
    }

    public float getBottom() {
        return this.y;
    }

    public Rectangle moveDown(float move) {
        this.y -= move;
        return this;
    }

    public Rectangle moveUp(float move) {
        this.y += move;
        return this;
    }

    public Rectangle moveRight(float move) {
        this.x += move;
        return this;
    }

    public Rectangle moveLeft(float move) {
        this.x -= move;
        return this;
    }

    public Rectangle applyMargins(float topIndent, float rightIndent, float bottomIndent, float leftIndent, boolean reverse) {
        this.x += leftIndent * (float)(reverse ? -1 : 1);
        this.width -= (leftIndent + rightIndent) * (float)(reverse ? -1 : 1);
        this.y += bottomIndent * (float)(reverse ? -1 : 1);
        this.height -= (topIndent + bottomIndent) * (float)(reverse ? -1 : 1);
        return this;
    }

    public boolean intersectsLine(float x1, float y1, float x2, float y2) {
        double rx1 = this.getX();
        double ry1 = this.getY();
        double rx2 = rx1 + (double)this.getWidth();
        double ry2 = ry1 + (double)this.getHeight();
        return rx1 <= (double)x1 && (double)x1 <= rx2 && ry1 <= (double)y1 && (double)y1 <= ry2 || rx1 <= (double)x2 && (double)x2 <= rx2 && ry1 <= (double)y2 && (double)y2 <= ry2 || Rectangle.linesIntersect(rx1, ry1, rx2, ry2, x1, y1, x2, y2) || Rectangle.linesIntersect(rx2, ry1, rx1, ry2, x1, y1, x2, y2);
    }

    public String toString() {
        return "Rectangle: " + this.getWidth() + 'x' + this.getHeight();
    }

    public Rectangle clone() {
        try {
            return (Rectangle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equalsWithEpsilon(Rectangle that) {
        return this.equalsWithEpsilon(that, EPS);
    }

    public boolean equalsWithEpsilon(Rectangle that, float eps) {
        float dx = Math.abs(this.x - that.x);
        float dy = Math.abs(this.y - that.y);
        float dw = Math.abs(this.width - that.width);
        float dh = Math.abs(this.height - that.height);
        return dx < eps && dy < eps && dw < eps && dh < eps;
    }

    private static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double AvB = (x2 -= x1) * (y3 -= y1) - (x3 -= x1) * (y2 -= y1);
        double AvC = x2 * (y4 -= y1) - (x4 -= x1) * y2;
        if (AvB == 0.0 && AvC == 0.0) {
            if (x2 != 0.0) {
                return x4 * x3 <= 0.0 || x3 * x2 >= 0.0 && (x2 > 0.0 ? x3 <= x2 || x4 <= x2 : x3 >= x2 || x4 >= x2);
            }
            if (y2 != 0.0) {
                return y4 * y3 <= 0.0 || y3 * y2 >= 0.0 && (y2 > 0.0 ? y3 <= y2 || y4 <= y2 : y3 >= y2 || y4 >= y2);
            }
            return false;
        }
        double BvC = x3 * y4 - x4 * y3;
        return AvB * AvC <= 0.0 && BvC * (AvB + BvC - AvC) <= 0.0;
    }

    public static List<Rectangle> createBoundingRectanglesFromQuadPoint(PdfArray quadPoints) throws PdfException {
        ArrayList<Rectangle> boundingRectangles = new ArrayList<Rectangle>();
        if (quadPoints.size() % 8 != 0) {
            throw new PdfException("The QuadPoint Array length is not a multiple of 8.");
        }
        for (int i = 0; i < quadPoints.size(); i += 8) {
            float[] quadPointEntry = Arrays.copyOfRange(quadPoints.toFloatArray(), i, i + 8);
            PdfArray quadPointEntryFA = new PdfArray(quadPointEntry);
            boundingRectangles.add(Rectangle.createBoundingRectangleFromQuadPoint(quadPointEntryFA));
        }
        return boundingRectangles;
    }

    public static Rectangle createBoundingRectangleFromQuadPoint(PdfArray quadPoints) throws PdfException {
        if (quadPoints.size() % 8 != 0) {
            throw new PdfException("The QuadPoint Array length is not a multiple of 8.");
        }
        float llx = Float.MAX_VALUE;
        float lly = Float.MAX_VALUE;
        float urx = -3.4028235E38f;
        float ury = -3.4028235E38f;
        for (int j = 0; j < 8; j += 2) {
            float x = quadPoints.getAsNumber(j).floatValue();
            float y = quadPoints.getAsNumber(j + 1).floatValue();
            if (x < llx) {
                llx = x;
            }
            if (x > urx) {
                urx = x;
            }
            if (y < lly) {
                lly = y;
            }
            if (!(y > ury)) continue;
            ury = y;
        }
        return new Rectangle(llx, lly, urx - llx, ury - lly);
    }
}

