/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;

public class PdfPopupAnnotation
extends PdfAnnotation {
    private static final long serialVersionUID = -8892617787951569855L;
    protected PdfAnnotation parent;

    public PdfPopupAnnotation(Rectangle rect) {
        super(rect);
    }

    protected PdfPopupAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.Popup;
    }

    public PdfDictionary getParentObject() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Parent);
    }

    public PdfAnnotation getParent() {
        if (this.parent == null) {
            this.parent = PdfPopupAnnotation.makeAnnotation(this.getParentObject());
        }
        return this.parent;
    }

    public PdfPopupAnnotation setParent(PdfAnnotation parent) {
        this.parent = parent;
        return (PdfPopupAnnotation)this.put(PdfName.Parent, (PdfObject)parent.getPdfObject());
    }

    public boolean getOpen() {
        return PdfBoolean.TRUE.equals(((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.Open));
    }

    public PdfPopupAnnotation setOpen(boolean open) {
        return (PdfPopupAnnotation)this.put(PdfName.Open, PdfBoolean.valueOf(open));
    }
}

