/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import java.util.Arrays;

public class LineTo
extends AbstractPathShape {
    static final int ARGUMENT_SIZE = 2;

    public LineTo() {
        this(false);
    }

    public LineTo(boolean relative) {
        super(relative);
    }

    @Override
    public void draw(PdfCanvas canvas) {
        float x = CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[0]);
        float y = CssDimensionParsingUtils.parseAbsoluteLength((String)this.coordinates[1]);
        canvas.lineTo((double)x, (double)y);
    }

    @Override
    public void setCoordinates(String[] inputCoordinates, Point startPoint) {
        if (inputCoordinates.length != 2) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"(x y)+ parameters are expected for lineTo operator. Got: {0}", (Object[])new Object[]{Arrays.toString(inputCoordinates)}));
        }
        this.coordinates = new String[]{inputCoordinates[0], inputCoordinates[1]};
        if (this.isRelative()) {
            this.coordinates = this.copier.makeCoordinatesAbsolute(this.coordinates, new double[]{startPoint.x, startPoint.y});
        }
    }
}

