package com.jcloud.jcq.sdk.consumer;

import com.jcloud.jcq.sdk.LifeCycle;
import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.consumer.MessageListener;
import com.jcloud.jcq.common.filter.FilterExpression;

/**
 * 消费者接口
 *
 * @author wanglitao
 */
public interface Consumer extends LifeCycle {
    /**
     * 订阅topic
     *
     * @param topic topic
     * @param messageListener messageListener
     * @param filterExpression filterExpression
     * @throws ClientException ClientException
     */
    void subscribeTopic(final String topic, final MessageListener messageListener, final FilterExpression filterExpression) throws ClientException;

    /**
     * 取消订阅topic
     *
     * @param topic topic
     * @throws ClientException ClientException
     */
    void unsubscribeTopic(final String topic) throws ClientException;
}
