package com.jcloud.jcq.sdk.consumer;

import com.jcloud.jcq.common.consumer.ConsumeFromWhere;
import com.jcloud.jcq.sdk.producer.ProducerConfig;

/**
 * 消费者配置
 *
 * @author wanglitao
 */
public class ConsumerConfig {
    /**
     * 消费组Id
     */
    private String consumerGroupId = null;
    /**
     * 元数据服务器地址
     */
    private String metaServerAddress = null;
    /**
     * 请求服务端失败最大重试次数
     */
    protected int maxRetryTimes = 2;
    /**
     * 默认的起始消费位置
     */
    private ConsumeFromWhere defaultConsumePosition = ConsumeFromWhere.HEAD;
    /**
     * 建议服务端每次推送的最大消息条数
     */
    private int maxBatchSizePerPush = 32;
    /**
     * 消费线程池的核心线程数量
     */
    private int consumePoolCoreSize = 4;
    /**
     * 消费客户端可以缓存多少批次尚未消费的消息
     */
    private int messageBufferSize = 1024;
    /**
     * ack线程池的核心线程数量
     */
    private int ackPoolCoreSize = 2;
    /**
     * 消费客户端可以缓存多少批次尚未ack的消息
     */
    private int ackBufferSize = 1024;
    /**
     * 消费失败最大重试次数
     */
    private int consumeMaxRetryTimes = 2;
    /**
     * 是否开启消息轨迹功能
     */
    private boolean enableMessageTrace = false;


    public int getRemoteCallRetryWaitTime() {
        return remoteCallRetryWaitTime;
    }

    public void setRemoteCallRetryWaitTime(int remoteCallRetryWaitTime) {
        this.remoteCallRetryWaitTime = remoteCallRetryWaitTime;
    }

    /**
     * 调用服务端忙需要减速的情况下， 本地sleep的时长， 单位(ms)
     */
    private int remoteCallRetryWaitTime = 100;

    public int getRefreshRouteRetryWaitTime() {
        return refreshRouteRetryWaitTime;
    }

    public void setRefreshRouteRetryWaitTime(int refreshRouteRetryWaitTime) {
        this.refreshRouteRetryWaitTime = refreshRouteRetryWaitTime;
    }

    /**
     * 从meta server更新topic路由信息遇到限速，本地sleep的时长， 单位(ms)
     */
    private int refreshRouteRetryWaitTime = 200;

    private ConsumerConfig() {
    }

    public String getConsumerGroupId() {
        return consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public String getMetaServerAddress() {
        return metaServerAddress;
    }

    public void setMetaServerAddress(String metaServerAddress) {
        this.metaServerAddress = metaServerAddress;
    }

    public int getMaxRetryTimes() {
        return maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public ConsumeFromWhere getDefaultConsumePosition() {
        return defaultConsumePosition;
    }

    public void setDefaultConsumePosition(ConsumeFromWhere defaultConsumePosition) {
        this.defaultConsumePosition = defaultConsumePosition;
    }

    public int getMaxBatchSizePerPush() {
        return maxBatchSizePerPush;
    }

    public void setMaxBatchSizePerPush(int maxBatchSizePerPush) {
        this.maxBatchSizePerPush = maxBatchSizePerPush;
    }

    public int getConsumePoolCoreSize() {
        return consumePoolCoreSize;
    }

    public void setConsumePoolCoreSize(int consumePoolCoreSize) {
        this.consumePoolCoreSize = consumePoolCoreSize;
    }

    public int getMessageBufferSize() {
        return messageBufferSize;
    }

    public void setMessageBufferSize(int messageBufferSize) {
        this.messageBufferSize = messageBufferSize;
    }

    public int getAckPoolCoreSize() {
        return ackPoolCoreSize;
    }

    public void setAckPoolCoreSize(int ackPoolCoreSize) {
        this.ackPoolCoreSize = ackPoolCoreSize;
    }

    public int getAckBufferSize() {
        return ackBufferSize;
    }

    public void setAckBufferSize(int ackBufferSize) {
        this.ackBufferSize = ackBufferSize;
    }

    public int getConsumeMaxRetryTimes() {
        return consumeMaxRetryTimes;
    }

    public void setConsumeMaxRetryTimes(int consumeMaxRetryTimes) {
        this.consumeMaxRetryTimes = consumeMaxRetryTimes;
    }

    public boolean isEnableMessageTrace() {
        return enableMessageTrace;
    }

    public void setEnableMessageTrace(boolean enableMessageTrace) {
        this.enableMessageTrace = enableMessageTrace;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "ConsumerConfig{" +
                ", consumerGroupId='" + consumerGroupId + '\'' +
                ", metaServerAddress='" + metaServerAddress + '\'' +
                ", maxRetryTimes=" + maxRetryTimes +
                ", defaultConsumePosition=" + defaultConsumePosition +
                ", maxBatchSizePerPush=" + maxBatchSizePerPush +
                ", consumePoolCoreSize=" + consumePoolCoreSize +
                ", messageBufferSize=" + messageBufferSize +
                ", ackPoolCoreSize=" + ackPoolCoreSize +
                ", ackBufferSize=" + ackBufferSize +
                ", consumeMaxRetryTimes=" + consumeMaxRetryTimes +
                ", enableMessageTrace=" + enableMessageTrace +
                '}';
    }

    public static class Builder {
        private ConsumerConfig consumerConfig;

        public Builder() {
            this.consumerConfig = new ConsumerConfig();
        }

        public Builder consumerGroupId(String consumerGroupId) {
            consumerConfig.setConsumerGroupId(consumerGroupId);
            return this;
        }

        public Builder metaServerAddress(String metaServerAddress) {
            consumerConfig.setMetaServerAddress(metaServerAddress);
            return this;
        }

        public Builder maxRetryTimes(int maxRetryTimes) {
            consumerConfig.setMaxRetryTimes(maxRetryTimes);
            return this;
        }

        public Builder defaultConsumePosition(ConsumeFromWhere defaultConsumePosition) {
            consumerConfig.setDefaultConsumePosition(defaultConsumePosition);
            return this;
        }

        public Builder maxBatchSizePerPush(int maxBatchSizePerPush) {
            consumerConfig.setMaxBatchSizePerPush(maxBatchSizePerPush);
            return this;
        }

        public Builder consumePoolCoreSize(int consumePoolCoreSize) {
            consumerConfig.setConsumePoolCoreSize(consumePoolCoreSize);
            return this;
        }

        public Builder messageBufferSize(int messageBufferSize) {
            consumerConfig.setMessageBufferSize(messageBufferSize);
            return this;
        }

        public Builder ackPoolCoreSize(int ackPoolCoreSize) {
            consumerConfig.setAckPoolCoreSize(ackPoolCoreSize);
            return this;
        }

        public Builder ackBufferSize(int ackBufferSize) {
            consumerConfig.setAckBufferSize(ackBufferSize);
            return this;
        }

        public Builder consumeMaxRetryTimes(int consumeMaxRetryTimes) {
            consumerConfig.setConsumeMaxRetryTimes(consumeMaxRetryTimes);
            return this;
        }

        public Builder enableMessageTrace(boolean enableMessageTrace) {
            consumerConfig.setEnableMessageTrace(enableMessageTrace);
            return this;
        }

        public Builder remoteCallRetryWaitTime(int remoteCallRetryWaitTime) {
            consumerConfig.setRemoteCallRetryWaitTime(remoteCallRetryWaitTime);
            return this;
        }

        public Builder refreshRouteRetryWaitTime(int refreshRouteRetryWaitTime) {
            consumerConfig.setRefreshRouteRetryWaitTime(refreshRouteRetryWaitTime);
            return this;
        }
        // 通过property设置通信层最大长度, DefaultCommunicationClient初始化会用到
        public Builder communicationFrameMaxLength(int frameMaxLength) {
            System.setProperty("communication.frame.max.length", String.valueOf(frameMaxLength));
            return this;
        }
        public ConsumerConfig build() {
            return consumerConfig;
        }
    }
}
