package com.jcloud.jcq.sdk.consumer;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.common.filter.FilterExpression;
import com.jcloud.jcq.common.message.AckAction;
import com.jcloud.jcq.sdk.LifeCycle;
import com.jcloud.jcq.sdk.consumer.async.AsyncAckCallback;
import com.jcloud.jcq.sdk.consumer.async.AsyncPullCallback;
import com.jcloud.jcq.sdk.consumer.model.AckResult;
import com.jcloud.jcq.sdk.consumer.model.PullResult;

/**
 * 拉取型消费者接口
 *
 * @author wanglitao
 */
public interface PullConsumer extends LifeCycle {
    /**
     * 同步拉取消息
     *
     * @param topic topic
     * @param filterExpression 消息过滤表达式，为null时表示不进行过滤
     * @return PullResult
     * @throws ClientException ClientException
     */
    public PullResult pullMessage(final String topic, final FilterExpression filterExpression) throws ClientException;

    /**
     * 异步拉取消息
     *
     * @param topic topic
     * @param filterExpression 消息过滤表达式，为null时表示不进行过滤
     * @param callback callback
     * @throws ClientException ClientException
     */
    public void pullMessageAsync(final String topic, final FilterExpression filterExpression, final AsyncPullCallback callback) throws ClientException;

    /**
     * 同步ack消息
     *
     * @param topic topic
     * @param ackIndex ackIndex
     * @param ackAction ackAction
     * @return AckResult
     * @throws ClientException ClientException
     */
    public AckResult ackMessage(final String topic, final String ackIndex, final AckAction ackAction) throws ClientException;

    /**
     * 异步ack消息
     *
     * @param topic topic
     * @param ackIndex ackIndex
     * @param ackAction ackAction
     * @param callback callback
     * @throws ClientException ClientException      
     */
    public void ackMessageAsync(final String topic, final String ackIndex, final AckAction ackAction, final AsyncAckCallback callback) throws ClientException;
}
