package com.jcloud.jcq.sdk.consumer;

import com.jcloud.jcq.common.consumer.ConsumeFromWhere;
import com.jcloud.jcq.sdk.producer.ProducerConfig;

/**
 * 拉取型消费者配置
 *
 * @author wanglitao
 */
public class PullConsumerConfig {
    /**
     * 消费组Id
     */
    private String consumerGroupId = null;
    /**
     * 元数据服务器地址
     */
    private String metaServerAddress = null;
    /**
     * 请求服务端失败最大重试次数
     */
    protected int maxRetryTimes = 2;
    /**
     * 默认的起始消费位置
     */
    private ConsumeFromWhere defaultConsumePosition = ConsumeFromWhere.HEAD;
    /**
     * 建议服务端每次拉取返回的最大消息条数
     */
    private int maxBatchSizePerPull = 32;
    /**
     * 是否开启消息轨迹功能
     */
    private boolean enableMessageTrace = false;


    public int getRemoteCallRetryWaitTime() {
        return remoteCallRetryWaitTime;
    }

    public void setRemoteCallRetryWaitTime(int remoteCallRetryWaitTime) {
        this.remoteCallRetryWaitTime = remoteCallRetryWaitTime;
    }

    /**
     * 调用服务端忙需要减速的情况下， 本地sleep的时长， 单位(ms)
     */
    private int remoteCallRetryWaitTime = 100;

    public int getRefreshRouteRetryWaitTime() {
        return refreshRouteRetryWaitTime;
    }

    public void setRefreshRouteRetryWaitTime(int refreshRouteRetryWaitTime) {
        this.refreshRouteRetryWaitTime = refreshRouteRetryWaitTime;
    }

    /**
     * 从meta server更新topic路由信息遇到限速，本地sleep的时长， 单位(ms)
     */
    private int refreshRouteRetryWaitTime = 200;

    private PullConsumerConfig() {
    }

    public String getConsumerGroupId() {
        return consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public String getMetaServerAddress() {
        return metaServerAddress;
    }

    public void setMetaServerAddress(String metaServerAddress) {
        this.metaServerAddress = metaServerAddress;
    }

    public int getMaxRetryTimes() {
        return maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public ConsumeFromWhere getDefaultConsumePosition() {
        return defaultConsumePosition;
    }

    public void setDefaultConsumePosition(ConsumeFromWhere defaultConsumePosition) {
        this.defaultConsumePosition = defaultConsumePosition;
    }

    public int getMaxBatchSizePerPull() {
        return maxBatchSizePerPull;
    }

    public void setMaxBatchSizePerPull(int maxBatchSizePerPull) {
        this.maxBatchSizePerPull = maxBatchSizePerPull;
    }

    public boolean isEnableMessageTrace() {
        return enableMessageTrace;
    }

    public void setEnableMessageTrace(boolean enableMessageTrace) {
        this.enableMessageTrace = enableMessageTrace;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "PullConsumerConfig{" +
                "consumerGroupId='" + consumerGroupId + '\'' +
                ", metaServerAddress='" + metaServerAddress + '\'' +
                ", maxRetryTimes=" + maxRetryTimes +
                ", defaultConsumePosition=" + defaultConsumePosition +
                ", maxBatchSizePerPull=" + maxBatchSizePerPull +
                ", enableMessageTrace=" + enableMessageTrace +
                '}';
    }

    public static class Builder {
        private PullConsumerConfig pullConsumerConfig;

        public Builder() {
            this.pullConsumerConfig = new PullConsumerConfig();
        }

        public Builder consumerGroupId(String consumerGroupId) {
            pullConsumerConfig.setConsumerGroupId(consumerGroupId);
            return this;
        }

        public Builder metaServerAddress(String metaServerAddress) {
            pullConsumerConfig.setMetaServerAddress(metaServerAddress);
            return this;
        }

        public Builder maxRetryTimes(int maxRetryTimes) {
            pullConsumerConfig.setMaxRetryTimes(maxRetryTimes);
            return this;
        }

        public Builder defaultConsumePosition(ConsumeFromWhere defaultConsumePosition) {
            pullConsumerConfig.setDefaultConsumePosition(defaultConsumePosition);
            return this;
        }

        public Builder maxBatchSizePerPull(int maxBatchSizePerPull) {
            pullConsumerConfig.setMaxBatchSizePerPull(maxBatchSizePerPull);
            return this;
        }

        public Builder enableMessageTrace(boolean enableMessageTrace) {
            pullConsumerConfig.setEnableMessageTrace(enableMessageTrace);
            return this;
        }

        public Builder remoteCallRetryWaitTime(int remoteCallRetryWaitTime) {
            pullConsumerConfig.setRemoteCallRetryWaitTime(remoteCallRetryWaitTime);
            return this;
        }

        public Builder refreshRouteRetryWaitTime(int refreshRouteRetryWaitTime) {
            pullConsumerConfig.setRefreshRouteRetryWaitTime(refreshRouteRetryWaitTime);
            return this;
        }
        // 通过property设置通信层最大长度, DefaultCommunicationClient初始化会用到
        public Builder communicationFrameMaxLength(int frameMaxLength) {
            System.setProperty("communication.frame.max.length", String.valueOf(frameMaxLength));
            return this;
        }
        public PullConsumerConfig build() {
            return pullConsumerConfig;
        }
    }
}
