package com.jcloud.jcq.sdk.consumer.impl;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.consumer.MessageListener;
import com.jcloud.jcq.client.consumer.SubscribeConsumer;
import com.jcloud.jcq.common.filter.FilterExpression;
import com.jcloud.jcq.sdk.consumer.Consumer;

/**
 * 消费者默认实现类.
 *
 * @author wanglitao
 */
public class DefaultConsumerImpl implements Consumer {
    /**
     * 原生client中的consumer引用
     */
    private SubscribeConsumer consumer;

    public DefaultConsumerImpl(SubscribeConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public void subscribeTopic(String topic, MessageListener messageListener, FilterExpression filterExpression) throws ClientException {
        consumer.subscribeTopic(topic, messageListener, filterExpression);
    }

    @Override
    public void unsubscribeTopic(String topic) throws ClientException {
        consumer.unsubscribeTopic(topic);
    }

    @Override
    public void start() throws ClientException {
        consumer.start();
    }

    @Override
    public void shutdown() throws ClientException {
        consumer.shutdown();
    }
}
