package com.jcloud.jcq.sdk.producer;

import com.jcloud.jcq.sdk.LifeCycle;
import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.sdk.producer.model.SendBatchResult;
import com.jcloud.jcq.sdk.producer.model.SendResult;
import com.jcloud.jcq.protocol.Message;

import java.util.List;

/**
 * 全局顺序消息生产者接口
 *
 * @author wanglitao
 */
public interface GlobalOrderProducer extends LifeCycle {
    /**
     * 同步单条消息发送
     *
     * @param message message
     * @return SendResult
     * @throws ClientException ClientException
     */
    SendResult sendMessage(final Message message) throws ClientException;

    /**
     * 同步批量消息发送
     *
     * @param messages message
     * @return SendBatchResult
     * @throws ClientException ClientException
     */
    SendBatchResult sendBatchMessage(final List<Message> messages) throws ClientException;
}
