package com.jcloud.jcq.sdk.producer;

import com.jcloud.jcq.sdk.LifeCycle;
import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.sdk.producer.async.AsyncSendBatchCallback;
import com.jcloud.jcq.sdk.producer.async.AsyncSendCallback;
import com.jcloud.jcq.sdk.producer.model.SendBatchResult;
import com.jcloud.jcq.sdk.producer.model.SendResult;
import com.jcloud.jcq.protocol.Message;

import java.util.List;

/**
 * 普通消息生产者接口
 *
 * @author wanglitao
 */
public interface Producer extends LifeCycle {
    /**
     * 同步单条消息发送
     *
     * @param message message
     * @return SendResult
     * @throws ClientException ClientException
     */
    SendResult sendMessage(final Message message) throws ClientException;

    /**
     * 异步单条消息发送
     *
     * @param message message
     * @param callback callback
     * @throws ClientException ClientException
     */
    void sendMessageAsync(final Message message, AsyncSendCallback callback) throws ClientException;

    /**
     * 同步批量消息发送
     *
     * @param messages message
     * @return SendBatchResult
     * @throws ClientException ClientException
     */
    SendBatchResult sendBatchMessage(final List<Message> messages) throws ClientException;

    /**
     * 异步批量消息发送
     *
     * @param messages message
     * @param callback callback
     * @throws ClientException ClientException
     */
    void sendBatchMessageAsync(final List<Message> messages, AsyncSendBatchCallback callback) throws ClientException;
}
