package com.jcloud.jcq.sdk.producer;


/**
 * 生产者配置.
 *
 * @author wanglitao
 */
public class ProducerConfig {
    /**
     * 元数据服务器地址
     */
    private String metaServerAddress = null;
    /**
     * 请求服务端失败最大重试次数
     */
    protected int maxRetryTimes = 2;
    /**
     * 是否开启客户端消息压缩功能，默认开启
     */
    private boolean enableCompress = true;
    /**
     * 是否开启消息轨迹功能
     */
    private boolean enableMessageTrace = false;

    /**
     * 是否开启客户端info级别发消息输出，默认开启。如果关闭将按debug级别输出。
     */
    private boolean showInfoLevelSendMsgLog = true;

    public int getRemoteCallRetryWaitTime() {
        return remoteCallRetryWaitTime;
    }

    public void setRemoteCallRetryWaitTime(int remoteCallRetryWaitTime) {
        this.remoteCallRetryWaitTime = remoteCallRetryWaitTime;
    }

    /**
     * 调用服务端忙需要减速的情况下， 本地sleep的时长， 单位(ms)
     */
    private int remoteCallRetryWaitTime = 100;

    public int getRefreshRouteRetryWaitTime() {
        return refreshRouteRetryWaitTime;
    }

    public void setRefreshRouteRetryWaitTime(int refreshRouteRetryWaitTime) {
        this.refreshRouteRetryWaitTime = refreshRouteRetryWaitTime;
    }

    public int getMaxMsgSize() {
        return maxMsgSize;
    }

    public void setMaxMsgSize(int maxMsgSize) {
        this.maxMsgSize = maxMsgSize;
    }

    /**
     * 单条消息最大长度，默认256k
     */
    private int maxMsgSize = 256 * 1024;

    public int getSendTimeout() {
        return sendTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    /**
     * 请求服务端的超时时间，单位毫秒，取值<=0时以通信层设置为准
     */
    private int sendTimeout = 0;

    /**
     * 从meta server更新topic路由信息遇到限速，本地sleep的时长， 单位(ms)
     */
    private int refreshRouteRetryWaitTime = 200;
    private ProducerConfig() {
    }

    public String getMetaServerAddress() {
        return metaServerAddress;
    }

    public void setMetaServerAddress(String metaServerAddress) {
        this.metaServerAddress = metaServerAddress;
    }

    public int getMaxRetryTimes() {
        return maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public boolean isEnableCompress() {
        return enableCompress;
    }

    public void setEnableCompress(boolean enableCompress) {
        this.enableCompress = enableCompress;
    }

    public boolean isEnableMessageTrace() {
        return enableMessageTrace;
    }

    public void setEnableMessageTrace(boolean enableMessageTrace) {
        this.enableMessageTrace = enableMessageTrace;
    }
    public boolean isShowInfoLevelSendMsgLog() {
        return showInfoLevelSendMsgLog;
    }

    public void setShowInfoLevelSendMsgLog(boolean showInfoLevelSendMsgLog) {
        this.showInfoLevelSendMsgLog = showInfoLevelSendMsgLog;
    }
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "ProducerConfig{" +
                "metaServerAddress='" + metaServerAddress + '\'' +
                ", maxRetryTimes=" + maxRetryTimes +
                ", enableCompress=" + enableCompress +
                ", enableMessageTrace=" + enableMessageTrace +
                '}';
    }

    public static class Builder {
        private ProducerConfig producerConfig;

        public Builder() {
            this.producerConfig = new ProducerConfig();
        }

        public Builder metaServerAddress(String metaServerAddress) {
            producerConfig.setMetaServerAddress(metaServerAddress);
            return this;
        }

        public Builder maxRetryTimes(int maxRetryTimes) {
            producerConfig.setMaxRetryTimes(maxRetryTimes);
            return this;
        }

        public Builder enableCompress(boolean enableCompress) {
            producerConfig.setEnableCompress(enableCompress);
            return this;
        }

        public Builder enableMessageTrace(boolean enableMessageTrace) {
            producerConfig.setEnableMessageTrace(enableMessageTrace);
            return this;
        }

        public Builder showInfoLevelSendMsgLog(boolean showInfoLevelSendMsgLog) {
            producerConfig.setShowInfoLevelSendMsgLog(showInfoLevelSendMsgLog);
            return this;
        }

        public Builder remoteCallRetryWaitTime(int remoteCallRetryWaitTime) {
            producerConfig.setRemoteCallRetryWaitTime(remoteCallRetryWaitTime);
            return this;
        }

        public Builder refreshRouteRetryWaitTime(int refreshRouteRetryWaitTime) {
            producerConfig.setRefreshRouteRetryWaitTime(refreshRouteRetryWaitTime);
            return this;
        }

        public Builder maxMsgSize(int maxMsgSize) {
            producerConfig.setMaxMsgSize(maxMsgSize);
            return this;
        }

        // 通过property设置通信层最大长度, DefaultCommunicationClient初始化会用到
        public Builder communicationFrameMaxLength(int frameMaxLength) {
            System.setProperty("communication.frame.max.length", String.valueOf(frameMaxLength));
            return this;
        }

        public Builder sendTimeout(int sendTimeout) {
            producerConfig.setSendTimeout(sendTimeout);
            return this;
        }
        public ProducerConfig build() {
            return producerConfig;
        }
    }
}
