package com.jcloud.jcq.sdk.producer.impl;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.producer.Producer;
import com.jcloud.jcq.sdk.producer.GlobalOrderProducer;
import com.jcloud.jcq.sdk.producer.model.ResultCode;
import com.jcloud.jcq.sdk.producer.model.SendBatchResult;
import com.jcloud.jcq.sdk.producer.model.SendResult;
import com.jcloud.jcq.protocol.Message;
import com.jcloud.jcq.protocol.client.SendMessageResponse;

import java.util.List;

/**
 * 全局顺序消息生产者默认实现类
 *
 * @author wanglitao
 */
public class DefaultGlobalOrderProducerImpl implements GlobalOrderProducer {
    /**
     * 原生client中的producer引用
     */
    private com.jcloud.jcq.client.producer.Producer producer;

    public DefaultGlobalOrderProducerImpl(Producer producer) {
        this.producer = producer;
    }

    @Override
    public synchronized SendResult sendMessage(Message message) throws ClientException {
        SendMessageResponse response = producer.sendMessage(message);
        return response.success() ?
                new SendResult(ResultCode.SUCCESS, response.getMessageIds().get(0),
                        response.getResponseCode(), response.getRemark()) :
                new SendResult(ResultCode.FAILED, null, response.getResponseCode(), response.getRemark());
    }

    @Override
    public synchronized SendBatchResult sendBatchMessage(List<Message> messages) throws ClientException {
        SendMessageResponse response = producer.sendMessage(messages);
        return response.success() ?
                new SendBatchResult(ResultCode.SUCCESS, response.getMessageIds(),
                        response.getResponseCode(), response.getRemark()) :
                new SendBatchResult(ResultCode.FAILED, null,
                        response.getResponseCode(), response.getRemark());
    }

    @Override
    public void start() throws ClientException {
        producer.start();
    }

    @Override
    public void shutdown() throws ClientException {
        producer.shutdown();
    }
}
