package com.jcloud.jcq.sdk.protocol;

import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.protocol.Request;
import com.jcloud.jcq.protocol.client.*;
import com.jcloud.jcq.protocol.broker.PushMessageRequest;

import java.util.HashMap;
import java.util.Map;

/**
 * 请求代码
 *
 * @author wanglitao
 */
public class RequestCode {
    private static final Map<Short, RequestInfo> CODE_TO_REQUEST_INFO = new HashMap<>();

    private RequestCode() {
    }

    static {
        CODE_TO_REQUEST_INFO.put((short) 100, new RequestInfo("HEART_BEAT", null));

        CODE_TO_REQUEST_INFO.put((short) 101, new RequestInfo("SEND_MESSAGE", SendMessageRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 102, new RequestInfo("PULL_MESSAGE", PullMessageRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 103, new RequestInfo("SUBSCRIBE_TOPIC", SubscribeTopicRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 104, new RequestInfo("ACK_MESSAGE", AckMessageRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 105, new RequestInfo("PUSH_MESSAGE", PushMessageRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 108, new RequestInfo("CONNECT_BROKER", ConnectBrokerRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 109, new RequestInfo("DISCONNECT_BROKER", DisconnectBrokerRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 110, new RequestInfo("UNSUBSCRIBE_TOPIC", UnsubscribeTopicRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 205, new RequestInfo("GET_TOPIC_ROUTE_INFO", GetTopicRouteInfoRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 206, new RequestInfo("GET_TOPIC_ROUTE_INFO_V2", GetTopicRouteInfoRequestV2.class));
        CODE_TO_REQUEST_INFO.put((short) 1101, new RequestInfo("UNREGISTER_CLIENT", UnregisterClientRequest.class));
        CODE_TO_REQUEST_INFO.put((short) 212, new RequestInfo("GET_TRACE_TOPIC_ROUTE_INFO", GetTraceTopicRouteInfoRequest.class));

        CODE_TO_REQUEST_INFO.put((short) -1, new RequestInfo("INVALID_REQUEST", null));

    }

    public static String getName(short code) {
        String name = CODE_TO_REQUEST_INFO.get(code).getRequestName();
        return StringUtils.isEmpty(name) ? String.valueOf(code) : name;
    }

    public static Class<? extends Request> getClass(short code) {
        return CODE_TO_REQUEST_INFO.get(code).getRequestClass();
    }

    //heartbeat相关
    public static final short HEART_BEAT = 100;

    //message相关
    public static final short SEND_MESSAGE = 101;
    public static final short PULL_MESSAGE = 102;
    public static final short SUBSCRIBE_TOPIC = 103;
    public static final short ACK_MESSAGE = 104;
    public static final short PUSH_MESSAGE = 105;
    public static final short CONNECT_BROKER = 108;
    public static final short DISCONNECT_BROKER = 109;
    public static final short UNSUBSCRIBE_TOPIC = 110;

    //元数据相关
    public static final short GET_TOPIC_ROUTE_INFO = 205;
    public static final short GET_TOPIC_ROUTE_INFO_V2 = 206;
    public static final short UNREGISTER_CLIENT = 1101;
    public static final short GET_TRACE_TOPIC_ROUTE_INFO = 212;

    public static final short INVALID_REQUEST = -1;

    private static class RequestInfo {
        private String requestName;
        private Class<? extends Request> requestClass;

        public RequestInfo(String requestCode, Class<? extends Request> requestClass) {
            this.requestName = requestCode;
            this.requestClass = requestClass;
        }

        public String getRequestName() {
            return requestName;
        }

        public Class<? extends Request> getRequestClass() {
            return requestClass;
        }
    }
}
