/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode;

import com.jfirer.baseutil.bytecode.annotation.AnnotationMetadata;
import com.jfirer.baseutil.bytecode.structure.AnnotationInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.RuntimeVisibleAnnotationsAttriInfo;
import com.jfirer.baseutil.bytecode.structure.FieldInfo;
import com.jfirer.baseutil.bytecode.structure.MethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ClassFile {
    private int minor_version;
    private int major_version;
    private int access_flags;
    private String this_class_name;
    private String super_class_name;
    private String[] interfaces;
    private FieldInfo[] fieldInfos;
    private MethodInfo[] methodInfos;
    private AttributeInfo[] attributeInfos;
    private List<AnnotationMetadata> annotations;

    void setAttributeInfos(AttributeInfo[] attributeInfos) {
        this.attributeInfos = attributeInfos;
    }

    void setSuper_class_name(String super_class_name) {
        if (super_class_name == null) {
            return;
        }
        if (super_class_name.indexOf(47) != -1) {
            super_class_name = super_class_name.replace('/', '.');
        }
        this.super_class_name = super_class_name;
    }

    public int getMinor_version() {
        return this.minor_version;
    }

    void setMinor_version(int minor_version) {
        this.minor_version = minor_version;
    }

    public int getMajor_version() {
        return this.major_version;
    }

    void setMajor_version(int major_version) {
        this.major_version = major_version;
    }

    public void setAccess_flags(int access_flags) {
        this.access_flags = access_flags;
    }

    public FieldInfo[] getFieldInfos() {
        return this.fieldInfos;
    }

    void setFieldInfos(FieldInfo[] fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    public List<AnnotationMetadata> getAnnotations(ClassLoader classLoader) {
        if (this.annotations != null) {
            return this.annotations;
        }
        RuntimeVisibleAnnotationsAttriInfo runtimeVisibleAnnotationsAttriInfo = null;
        for (AttributeInfo attributeInfo : this.attributeInfos) {
            if (!(attributeInfo instanceof RuntimeVisibleAnnotationsAttriInfo)) continue;
            runtimeVisibleAnnotationsAttriInfo = (RuntimeVisibleAnnotationsAttriInfo)attributeInfo;
            break;
        }
        if (runtimeVisibleAnnotationsAttriInfo == null || runtimeVisibleAnnotationsAttriInfo.getAnnotations().length == 0) {
            this.annotations = Collections.emptyList();
            return this.annotations;
        }
        this.annotations = new ArrayList<AnnotationMetadata>();
        for (AnnotationInfo info : runtimeVisibleAnnotationsAttriInfo.getAnnotations()) {
            this.annotations.add(info.getAnnotation(classLoader));
        }
        return this.annotations;
    }

    public MethodInfo[] getMethodInfos() {
        return this.methodInfos;
    }

    void setMethodInfos(MethodInfo[] methodInfos) {
        this.methodInfos = methodInfos;
    }

    public boolean isInterface() {
        return (this.access_flags & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.access_flags & 0x2000) != 0;
    }

    public boolean isAbstract() {
        return (this.access_flags & 0x400) != 0;
    }

    public boolean isEnum() {
        return (this.access_flags & 0x4000) != 0;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    void setInterfaces(String[] interfaces) {
        this.interfaces = new String[interfaces.length];
        for (int i = 0; i < this.interfaces.length; ++i) {
            String value = interfaces[i];
            if (value.indexOf(47) != -1) {
                value = value.replace('/', '.');
            }
            this.interfaces[i] = value;
        }
    }

    public String getSuperClassName() {
        return this.super_class_name;
    }

    public String getThis_class_name() {
        return this.this_class_name;
    }

    void setThis_class_name(String this_class_name) {
        if (this_class_name.indexOf(47) != -1) {
            this_class_name = this_class_name.replace('/', '.');
        }
        this.this_class_name = this_class_name;
    }

    public boolean hasInterface(Class<?> ckass) {
        String name = ckass.getName();
        for (String each : this.interfaces) {
            if (!each.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isSuperClass(Class<?> ckass) {
        return ckass.getName().equals(this.super_class_name);
    }

    public String toString() {
        return "ClassFile{minor_version=" + this.minor_version + ", major_version=" + this.major_version + ", access_flags=" + this.access_flags + ", this_class_name='" + this.this_class_name + '\'' + ", super_class_name='" + this.super_class_name + '\'' + ", interfaces=" + Arrays.toString(this.interfaces) + ", fieldInfos=" + Arrays.toString(this.fieldInfos) + ", methodInfos=" + Arrays.toString(this.methodInfos) + ", attributeInfos=" + Arrays.toString(this.attributeInfos) + ", annotations=" + this.annotations + '}';
    }
}

