/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode.structure.Attribute;

import com.jfirer.baseutil.bytecode.structure.AnnotationInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfirer.baseutil.bytecode.util.BinaryData;
import java.util.Arrays;

public class RuntimeVisibleParameterAnnotationsAttrInfo
extends AttributeInfo {
    private int num_parameters;
    private ParameterAnnotation[] parameterAnnotations;

    public RuntimeVisibleParameterAnnotationsAttrInfo(String name, int length) {
        super(name, length);
    }

    @Override
    protected void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
        this.num_parameters = binaryData.readByte();
        this.parameterAnnotations = new ParameterAnnotation[this.num_parameters];
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            this.parameterAnnotations[i] = new ParameterAnnotation();
            this.parameterAnnotations[i].resolve(binaryData, constantInfos);
        }
    }

    @Override
    public String toString() {
        return "RuntimeVisibleParameterAnnotationsAttrInfo{parameterAnnotations=" + Arrays.toString(this.parameterAnnotations) + '}';
    }

    class ParameterAnnotation {
        private int num_annotations;
        private AnnotationInfo[] annotationInfos;

        ParameterAnnotation() {
        }

        void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
            this.num_annotations = binaryData.readShort();
            this.annotationInfos = new AnnotationInfo[this.num_annotations];
            for (int i = 0; i < this.annotationInfos.length; ++i) {
                this.annotationInfos[i] = new AnnotationInfo();
                this.annotationInfos[i].resolve(binaryData, constantInfos);
            }
        }

        public String toString() {
            return "ParameterAnnotation{annotationInfos=" + Arrays.toString(this.annotationInfos) + '}';
        }
    }
}

