/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode.structure;

import com.jfirer.baseutil.bytecode.ClassFile;
import com.jfirer.baseutil.bytecode.ClassFileParser;
import com.jfirer.baseutil.bytecode.annotation.ValuePair;
import com.jfirer.baseutil.bytecode.structure.AnnotationInfo;
import com.jfirer.baseutil.bytecode.structure.ConstantValue;
import com.jfirer.baseutil.bytecode.structure.ElementValueType;
import com.jfirer.baseutil.bytecode.structure.EnumConstant;
import com.jfirer.baseutil.bytecode.structure.MethodInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.DoubleInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.FloatInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.IntegerInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.LongInfo;
import com.jfirer.baseutil.bytecode.structure.constantinfo.Utf8Info;
import com.jfirer.baseutil.bytecode.util.BinaryData;
import com.jfirer.baseutil.bytecode.util.BytecodeUtil;
import com.jfirer.baseutil.reflect.ReflectUtil;
import java.util.Arrays;

public class ElementValueInfo {
    private char tag;
    private ElementValueType elementValueType;
    private ConstantValue constantValue;
    private EnumConstant enumConstant;
    private String classname;
    private AnnotationInfo annotationInfo;
    private int num_values;
    private ElementValueInfo[] elementValueInfos;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
        this.tag = (char)binaryData.readByte();
        this.elementValueType = this.resolveType(this.tag);
        if (this.isPrimitive(this.elementValueType) || this.elementValueType == ElementValueType.STRING) {
            int const_value_index = binaryData.readShort();
            ConstantInfo constantInfo = constantInfos[const_value_index - 1];
            if (constantInfo instanceof IntegerInfo) {
                this.constantValue = new ConstantValue(this.elementValueType, ((IntegerInfo)constantInfo).getValue());
                return;
            } else if (constantInfo instanceof FloatInfo) {
                this.constantValue = new ConstantValue(this.elementValueType, ((FloatInfo)constantInfo).getValue());
                return;
            } else if (constantInfo instanceof LongInfo) {
                this.constantValue = new ConstantValue(this.elementValueType, ((LongInfo)constantInfo).getValue());
                return;
            } else if (constantInfo instanceof DoubleInfo) {
                this.constantValue = new ConstantValue(this.elementValueType, ((DoubleInfo)constantInfo).getValue());
                return;
            } else {
                if (this.elementValueType != ElementValueType.STRING) throw new IllegalArgumentException();
                this.constantValue = new ConstantValue(this.elementValueType, ((Utf8Info)constantInfo).getValue());
            }
            return;
        } else if (this.elementValueType == ElementValueType.ENUM) {
            int type_name_index = binaryData.readShort();
            int const_name_index = binaryData.readShort();
            String typeName = ((Utf8Info)constantInfos[type_name_index - 1]).getValue();
            String enumName = ((Utf8Info)constantInfos[const_name_index - 1]).getValue();
            this.enumConstant = new EnumConstant(typeName, enumName);
            return;
        } else if (this.elementValueType == ElementValueType.CLASS) {
            int class_info_index = binaryData.readShort();
            this.classname = ((Utf8Info)constantInfos[class_info_index - 1]).getValue();
            return;
        } else if (this.elementValueType == ElementValueType.ANNOTATION) {
            this.annotationInfo = new AnnotationInfo();
            this.annotationInfo.resolve(binaryData, constantInfos);
            return;
        } else {
            if (this.elementValueType != ElementValueType.ARRAY) return;
            this.num_values = binaryData.readShort();
            this.elementValueInfos = new ElementValueInfo[this.num_values];
            for (int i = 0; i < this.num_values; ++i) {
                this.elementValueInfos[i] = new ElementValueInfo();
                this.elementValueInfos[i].resolve(binaryData, constantInfos);
            }
        }
    }

    public boolean isPrimitive(ElementValueType type) {
        return type == ElementValueType.BYTE || type == ElementValueType.CHAR || type == ElementValueType.DOUBLE || type == ElementValueType.FLOAT || type == ElementValueType.INT || type == ElementValueType.LONG || type == ElementValueType.SHORT || type == ElementValueType.BOOLEAN;
    }

    ElementValueType resolveType(char c) {
        switch (c) {
            case 'B': {
                return ElementValueType.BYTE;
            }
            case 'C': {
                return ElementValueType.CHAR;
            }
            case 'D': {
                return ElementValueType.DOUBLE;
            }
            case 'F': {
                return ElementValueType.FLOAT;
            }
            case 'I': {
                return ElementValueType.INT;
            }
            case 'J': {
                return ElementValueType.LONG;
            }
            case 'S': {
                return ElementValueType.SHORT;
            }
            case 'Z': {
                return ElementValueType.BOOLEAN;
            }
            case 's': {
                return ElementValueType.STRING;
            }
            case 'e': {
                return ElementValueType.ENUM;
            }
            case 'c': {
                return ElementValueType.CLASS;
            }
            case '@': {
                return ElementValueType.ANNOTATION;
            }
            case '[': {
                return ElementValueType.ARRAY;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "ElementValueInfo{tag=" + this.tag + ", elementValueType=" + (Object)((Object)this.elementValueType) + ", constantValue=" + this.constantValue + ", enumConstant=" + this.enumConstant + ", classname='" + this.classname + '\'' + ", annotationInfo=" + this.annotationInfo + ", num_values=" + this.num_values + ", elementValueInfos=" + Arrays.toString(this.elementValueInfos) + '}';
    }

    public ElementValueType getElementValueType() {
        return this.elementValueType;
    }

    public ConstantValue getConstantValue() {
        return this.constantValue;
    }

    public EnumConstant getEnumConstant() {
        return this.enumConstant;
    }

    public String getClassname() {
        return this.classname;
    }

    public AnnotationInfo getAnnotationInfo() {
        return this.annotationInfo;
    }

    public int getNum_values() {
        return this.num_values;
    }

    public ElementValueInfo[] getElementValueInfos() {
        return this.elementValueInfos;
    }

    public ValuePair getValue(ClassLoader classLoader, MethodInfo methodInfo) {
        ValuePair valuePair = new ValuePair(methodInfo);
        valuePair.setElementValueType(this.elementValueType);
        switch (this.elementValueType) {
            case BYTE: {
                byte b = (byte)this.constantValue.getIntValue();
                valuePair.setB(b);
                break;
            }
            case CHAR: {
                char c = (char)this.constantValue.getIntValue();
                valuePair.setC(c);
                break;
            }
            case DOUBLE: {
                double doubleValue = this.constantValue.getDoubleValue();
                valuePair.setD(doubleValue);
                break;
            }
            case FLOAT: {
                float floatValue = this.constantValue.getFloatValue();
                valuePair.setF(floatValue);
                break;
            }
            case INT: {
                int intValue = this.constantValue.getIntValue();
                valuePair.setI(intValue);
                break;
            }
            case LONG: {
                long longValue = this.constantValue.getLongValue();
                valuePair.setL(longValue);
                break;
            }
            case SHORT: {
                short shortValue = (short)this.constantValue.getIntValue();
                valuePair.setS(shortValue);
                break;
            }
            case BOOLEAN: {
                boolean booleanValue = this.constantValue.getIntValue() > 0;
                valuePair.setBooleanValue(booleanValue);
                break;
            }
            case STRING: {
                String stringValue = this.constantValue.getStringValue();
                valuePair.setStringValue(stringValue);
                break;
            }
            case ENUM: {
                String typeName = this.enumConstant.getTypeName();
                String enumName = this.enumConstant.getEnumName();
                valuePair.setEnumTypeName(typeName.replace('/', '.'));
                valuePair.setEnumValueName(enumName);
                break;
            }
            case CLASS: {
                valuePair.setClassName(this.classname.substring(1, this.classname.length() - 1).replace('/', '.'));
                break;
            }
            case ANNOTATION: {
                valuePair.setAnnotation(this.annotationInfo.getAnnotation(classLoader));
                break;
            }
            case ARRAY: {
                if (this.num_values != 0) {
                    valuePair.setComponentType(this.elementValueInfos[0].getElementValueType());
                    ValuePair[] array = new ValuePair[this.num_values];
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = this.elementValueInfos[i].getValue(classLoader, methodInfo);
                    }
                    valuePair.setArray(array);
                    if (valuePair.getComponentType() == ElementValueType.ENUM) {
                        valuePair.setComponentEnumTypeName(this.elementValueInfos[0].getEnumConstant().getTypeName().replace('/', '.'));
                        break;
                    }
                    if (valuePair.getComponentType() != ElementValueType.ANNOTATION) break;
                    valuePair.setComponentAnnotationType(this.elementValueInfos[0].getAnnotationInfo().getType().replace('/', '.'));
                    break;
                }
                String methodInfoDescriptor = methodInfo.getDescriptor();
                int index = methodInfoDescriptor.indexOf(")");
                char c1 = methodInfoDescriptor.charAt(index + 2);
                ElementValueType componentType = null;
                switch (c1) {
                    case 'B': {
                        componentType = ElementValueType.BYTE;
                        break;
                    }
                    case 'C': {
                        componentType = ElementValueType.CHAR;
                        break;
                    }
                    case 'D': {
                        componentType = ElementValueType.DOUBLE;
                        break;
                    }
                    case 'F': {
                        componentType = ElementValueType.FLOAT;
                        break;
                    }
                    case 'I': {
                        componentType = ElementValueType.INT;
                        break;
                    }
                    case 'J': {
                        componentType = ElementValueType.LONG;
                        break;
                    }
                    case 'S': {
                        componentType = ElementValueType.SHORT;
                        break;
                    }
                    case 'Z': {
                        componentType = ElementValueType.BOOLEAN;
                        break;
                    }
                    case 'L': {
                        String reference = methodInfoDescriptor.substring(index + 3, methodInfoDescriptor.length() - 1);
                        if (reference.equals("java/lang/String")) {
                            componentType = ElementValueType.STRING;
                            break;
                        }
                        if (reference.equals("java/lang/Class")) {
                            componentType = ElementValueType.CLASS;
                            break;
                        }
                        byte[] bytes = BytecodeUtil.loadBytecode(classLoader, reference);
                        ClassFile classFile = new ClassFileParser(new BinaryData(bytes)).parse();
                        if (classFile.isAnnotation()) {
                            componentType = ElementValueType.ANNOTATION;
                            valuePair.setComponentAnnotationType(reference.replace('/', '.'));
                            break;
                        }
                        if (classFile.isEnum()) {
                            componentType = ElementValueType.ENUM;
                            valuePair.setComponentEnumTypeName(reference.replace('/', '.'));
                            break;
                        }
                        ReflectUtil.throwException(new IllegalArgumentException());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                valuePair.setComponentType(componentType);
                valuePair.setArray(new ValuePair[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return valuePair;
    }
}

