/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode.support;

import com.jfirer.baseutil.bytecode.annotation.AnnotationMetadata;
import com.jfirer.baseutil.bytecode.annotation.DefaultAnnotationMetadata;
import com.jfirer.baseutil.bytecode.annotation.SupportOverrideAttributeAnnotationMetadata;
import com.jfirer.baseutil.bytecode.support.AnnotationContext;
import com.jfirer.baseutil.bytecode.support.CacheableAnnotationContextFactory;
import com.jfirer.baseutil.bytecode.support.DefaultAnnotationContext;
import com.jfirer.baseutil.bytecode.util.BytecodeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class SupportOverrideAttributeAnnotationContextFactory
extends CacheableAnnotationContextFactory {
    private AnnotationContext castToSupportOverrideContext(List<AnnotationMetadata> annotationsOnClass) {
        LinkedList<AnnotationMetadata> cast = new LinkedList<AnnotationMetadata>();
        for (AnnotationMetadata each : annotationsOnClass) {
            SupportOverrideAttributeAnnotationMetadata castFrom = SupportOverrideAttributeAnnotationMetadata.castFrom((DefaultAnnotationMetadata)each);
            cast.add(castFrom);
        }
        return new DefaultAnnotationContext(cast);
    }

    @Override
    protected AnnotationContext build(Method method, ClassLoader classLoader) {
        List<AnnotationMetadata> annotationsOnMethod = BytecodeUtil.findAnnotationsOnMethod(method, classLoader);
        return this.castToSupportOverrideContext(annotationsOnMethod);
    }

    @Override
    protected AnnotationContext build(Field field, ClassLoader classLoader) {
        return this.castToSupportOverrideContext(BytecodeUtil.findAnnotationsOnField(field, classLoader));
    }

    @Override
    protected AnnotationContext build(String resourceName, ClassLoader classLoader) {
        List<AnnotationMetadata> annotationMetadataList = BytecodeUtil.findAnnotationsOnClass(resourceName, classLoader);
        return this.castToSupportOverrideContext(annotationMetadataList);
    }
}

