/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.bytecode.util;

import com.jfirer.baseutil.bytecode.ClassFile;
import com.jfirer.baseutil.bytecode.ClassFileParser;
import com.jfirer.baseutil.bytecode.annotation.AnnotationMetadata;
import com.jfirer.baseutil.bytecode.annotation.ClassNotExistAnnotationMetadata;
import com.jfirer.baseutil.bytecode.structure.AnnotationInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.CodeAttriInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.LocalVariableTableAttriInfo;
import com.jfirer.baseutil.bytecode.structure.Attribute.RuntimeVisibleAnnotationsAttriInfo;
import com.jfirer.baseutil.bytecode.structure.FieldInfo;
import com.jfirer.baseutil.bytecode.structure.MethodInfo;
import com.jfirer.baseutil.bytecode.util.BinaryData;
import com.jfirer.baseutil.reflect.ReflectUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class BytecodeUtil {
    public static byte[] loadBytecode(ClassLoader loader, String name) {
        try {
            loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
            InputStream resourceAsStream = loader.getResourceAsStream(name + ".class");
            if (resourceAsStream == null) {
                return null;
            }
            byte[] content = new byte[resourceAsStream.available()];
            resourceAsStream.read(content);
            resourceAsStream.close();
            return content;
        }
        catch (Exception e1) {
            ReflectUtil.throwException(e1);
            return null;
        }
    }

    public static ClassFile loadClassFile(ClassLoader classLoader, String resourceName) {
        InputStream resourceAsStream = classLoader.getResourceAsStream(resourceName + ".class");
        if (resourceAsStream == null) {
            return null;
        }
        try {
            byte[] content = new byte[resourceAsStream.available()];
            resourceAsStream.read(content);
            resourceAsStream.close();
            return new ClassFileParser(content).parse();
        }
        catch (Throwable e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    public static ClassFile loadClassFile(String resourceName) {
        return BytecodeUtil.loadClassFile(Thread.currentThread().getContextClassLoader(), resourceName);
    }

    public static String[] parseMethodParamNames(Method method) {
        ClassFile classFile = BytecodeUtil.getMethodDeclaringClassFile(method);
        String descriptor = BytecodeUtil.getMethodDescriptor(method);
        String methodName = method.getName();
        for (MethodInfo methodInfo : classFile.getMethodInfos()) {
            if (!methodInfo.getName().equals(methodName) || !methodInfo.getDescriptor().equals(descriptor)) continue;
            for (AttributeInfo attributeInfo : methodInfo.getAttributeInfos()) {
                if (!(attributeInfo instanceof CodeAttriInfo)) continue;
                for (AttributeInfo info : ((CodeAttriInfo)attributeInfo).getAttributeInfos()) {
                    if (!(info instanceof LocalVariableTableAttriInfo)) continue;
                    LocalVariableTableAttriInfo localVariableTableAttriInfo = (LocalVariableTableAttriInfo)info;
                    LocalVariableTableAttriInfo.LocalVariableTableEntry[] entries = localVariableTableAttriInfo.getEntries();
                    String[] names = new String[method.getParameterTypes().length];
                    if (Modifier.isStatic(method.getModifiers())) {
                        for (int i = 0; i < names.length; ++i) {
                            names[i] = entries[i].getName();
                        }
                    } else {
                        for (int i = 0; i < names.length; ++i) {
                            names[i] = entries[i + 1].getName();
                        }
                    }
                    return names;
                }
            }
        }
        return null;
    }

    private static ClassFile getMethodDeclaringClassFile(Method method) {
        String name = method.getDeclaringClass().getName().replace('.', '/');
        byte[] bytes = BytecodeUtil.loadBytecode(method.getDeclaringClass().getClassLoader(), name);
        return new ClassFileParser(new BinaryData(bytes)).parse();
    }

    private static ClassFile getFieldDeclaringClassFile(Field field) {
        String name = field.getDeclaringClass().getName().replace('.', '/');
        byte[] bytes = BytecodeUtil.loadBytecode(field.getDeclaringClass().getClassLoader(), name);
        return new ClassFileParser(new BinaryData(bytes)).parse();
    }

    private static String getName(Class<?> parameterType) {
        if (parameterType.isPrimitive()) {
            if (parameterType == Integer.TYPE) {
                return "I";
            }
            if (parameterType == Short.TYPE) {
                return "S";
            }
            if (parameterType == Long.TYPE) {
                return "J";
            }
            if (parameterType == Float.TYPE) {
                return "F";
            }
            if (parameterType == Double.TYPE) {
                return "D";
            }
            if (parameterType == Character.TYPE) {
                return "C";
            }
            if (parameterType == Byte.TYPE) {
                return "B";
            }
            if (parameterType == Boolean.TYPE) {
                return "Z";
            }
            if (parameterType == Void.TYPE) {
                return "V";
            }
            throw new IllegalArgumentException();
        }
        if (parameterType.isArray()) {
            return "[" + BytecodeUtil.getName(parameterType.getComponentType());
        }
        return "L" + parameterType.getName() + ";";
    }

    public static List<AnnotationMetadata> findAnnotationsOnClass(String name, ClassLoader classLoader) {
        name = name.replace('.', '/');
        byte[] bytecode = BytecodeUtil.loadBytecode(classLoader, name);
        ClassFile classFile = new ClassFileParser(new BinaryData(bytecode)).parse();
        LinkedList<AnnotationMetadata> list = new LinkedList<AnnotationMetadata>();
        for (AnnotationMetadata annotation : classFile.getAnnotations(classLoader)) {
            if (annotation.shouldIgnore() || annotation instanceof ClassNotExistAnnotationMetadata) continue;
            list.add(annotation);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<AnnotationMetadata> findAnnotationsOnField(Field field, ClassLoader classLoader) {
        ClassFile classFile = BytecodeUtil.getFieldDeclaringClassFile(field);
        String fieldName = field.getName();
        for (FieldInfo fieldInfo : classFile.getFieldInfos()) {
            if (!fieldInfo.getName().equals(fieldName)) continue;
            for (AttributeInfo attributeInfo : fieldInfo.getAttributeInfos()) {
                if (!(attributeInfo instanceof RuntimeVisibleAnnotationsAttriInfo)) continue;
                return BytecodeUtil.getAnnotationMetadata(classLoader, (RuntimeVisibleAnnotationsAttriInfo)attributeInfo);
            }
        }
        return Collections.emptyList();
    }

    public static List<AnnotationMetadata> findAnnotationsOnMethod(Method method, ClassLoader loader) {
        ClassFile classFile = BytecodeUtil.getMethodDeclaringClassFile(method);
        return BytecodeUtil.findAnnotationsOnMethod(method, loader, classFile);
    }

    private static List<AnnotationMetadata> findAnnotationsOnMethod(Method method, ClassLoader loader, ClassFile classFile) {
        String descriptor = BytecodeUtil.getMethodDescriptor(method);
        String methodName = method.getName();
        for (MethodInfo methodInfo : classFile.getMethodInfos()) {
            if (!methodInfo.getName().equals(methodName) || !methodInfo.getDescriptor().equals(descriptor)) continue;
            for (AttributeInfo attributeInfo : methodInfo.getAttributeInfos()) {
                if (!(attributeInfo instanceof RuntimeVisibleAnnotationsAttriInfo)) continue;
                return BytecodeUtil.getAnnotationMetadata(loader, (RuntimeVisibleAnnotationsAttriInfo)attributeInfo);
            }
        }
        return Collections.emptyList();
    }

    private static List<AnnotationMetadata> getAnnotationMetadata(ClassLoader loader, RuntimeVisibleAnnotationsAttriInfo attributeInfo) {
        LinkedList<AnnotationMetadata> list = new LinkedList<AnnotationMetadata>();
        RuntimeVisibleAnnotationsAttriInfo runtimeVisibleAnnotationsAttriInfo = attributeInfo;
        for (AnnotationInfo annotation : runtimeVisibleAnnotationsAttriInfo.getAnnotations()) {
            AnnotationMetadata annotationMetadata = annotation.getAnnotation(loader);
            if (annotationMetadata.shouldIgnore() || annotationMetadata instanceof ClassNotExistAnnotationMetadata) continue;
            list.add(annotationMetadata);
        }
        return Collections.unmodifiableList(list);
    }

    private static String getMethodDescriptor(Method method) {
        Class<?>[] parameterTypes;
        StringBuilder cache = new StringBuilder();
        cache.append('(');
        for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
            cache.append(BytecodeUtil.getName(parameterType));
        }
        cache.append(')').append(BytecodeUtil.getName(method.getReturnType()));
        return cache.toString().replace('.', '/');
    }
}

