/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.concurrent;

import com.jfirer.baseutil.reflect.UNSAFE;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public abstract class Sync<E> {
    private static final long tailOffset = UNSAFE.getFieldOffset("tail", Sync.class);
    private static final int WAITING = 1;
    private static final int CANCELED = 2;
    private volatile Node head;
    private volatile Node tail;

    public Sync() {
        this.head = this.tail = new Node();
    }

    public boolean hasWaiters() {
        return this.head != this.tail;
    }

    private Node enqueue() {
        Thread t = Thread.currentThread();
        Node insert = new Node();
        Node pred = this.tail;
        insert.prev = pred;
        if (UNSAFE.compareAndSwapObject(this, tailOffset, pred, insert)) {
            pred.relaxSetSuccessor(t);
            return insert;
        }
        do {
            pred = this.tail;
            insert.prev = pred;
        } while (!UNSAFE.compareAndSwapObject(this, tailOffset, pred, insert));
        pred.relaxSetSuccessor(t);
        return insert;
    }

    public void signal() {
        Node h = this.head;
        this.unparkSuccessor(h);
    }

    protected abstract E get();

    /*
     * Unable to fully structure code
     */
    public E take(long time, TimeUnit unit) {
        self = this.enqueue();
        pred = Node.access$000(self);
        nanos = unit.toNanos(time);
        t0 = System.nanoTime();
        block0: while (true) {
            if (pred != (h = this.head)) ** GOTO lbl22
            result = this.get();
            if (result == null) {
                if (nanos < 1000L) {
                    for (i = 0; i < 1000; ++i) {
                    }
                } else {
                    LockSupport.parkNanos(nanos);
                }
                if ((nanos -= System.nanoTime() - t0) < 0L) {
                    this.cancel(self);
                    return null;
                }
                t0 = System.nanoTime();
            } else {
                this.head = self;
                this.unparkSuccessor(self);
                return result;
lbl22:
                // 1 sources

                if (nanos < 1000L) {
                    for (i = 0; i < 1000; ++i) {
                    }
                } else {
                    LockSupport.parkNanos(nanos);
                }
                if ((nanos -= System.nanoTime() - t0) < 0L) {
                    this.cancel(self);
                    return null;
                }
                t0 = System.nanoTime();
            }
            if (Thread.currentThread().isInterrupted()) {
                this.cancel(self);
                return null;
            }
            if (Node.access$100(pred) != 2) continue;
            while (true) {
                if (pred != h && Node.access$100(pred = Node.access$000(pred)) == 2) ** break;
                continue block0;
            }
            break;
        }
    }

    public E take() {
        Node self = this.enqueue();
        Node pred = self.prev;
        do {
            Node h;
            if (pred == (h = this.head)) {
                E result = this.get();
                if (result == null) {
                    LockSupport.park();
                    continue;
                }
                this.head = self;
                this.unparkSuccessor(self);
                return result;
            }
            if (pred.status == 2) {
                while (pred != h && (pred = pred.prev).status == 2) {
                }
            } else {
                LockSupport.park();
            }
        } while (!Thread.currentThread().isInterrupted());
        this.cancel(self);
        return null;
    }

    private void unparkSuccessor(Node node) {
        Thread nextWaiter = node.successor;
        if (node != this.tail) {
            if (nextWaiter == null) {
                while ((nextWaiter = node.successor) == null) {
                }
            }
            LockSupport.unpark(nextWaiter);
        }
    }

    private void cancel(Node node) {
        node.status = 2;
        Node pred = node.prev;
        pred.successor = null;
        this.unparkSuccessor(node);
    }

    static class Node {
        private static final long statusOffset = UNSAFE.getFieldOffset("status", Node.class);
        private static final long successorOffset = UNSAFE.getFieldOffset("successor", Node.class);
        private Node prev;
        private volatile Thread successor;
        private volatile int status;

        public Node() {
            UNSAFE.putInt(this, statusOffset, 1);
        }

        public void relaxSetSuccessor(Thread next) {
            UNSAFE.putOrderedObject(this, successorOffset, next);
        }

        public void clean() {
            this.prev = null;
            UNSAFE.putObject(this, successorOffset, null);
        }
    }
}

