/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.encrypt;

import com.jfirer.baseutil.StringUtil;
import com.jfirer.baseutil.reflect.ReflectUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class Md5Util {
    private static Charset charset = Charset.forName("UTF-8");

    public static byte[] md5(byte[] array) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] result = md.digest(array);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    public static byte[] md5(ByteBuffer array) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(array);
            byte[] result = md.digest();
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    public static byte[] md5(byte[] array, int off, int length) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.digest(array, off, length);
            byte[] result = md.digest();
            return result;
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    public static byte[] md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] data = str.getBytes(charset);
            byte[] result = md.digest(data);
            return result;
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5(File file, long offset, long length) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] src = length > 0x100000L ? new byte[0x100000] : new byte[(int)length];
            randomAccessFile.seek(offset);
            if (randomAccessFile.length() < offset + length) {
                throw new IllegalArgumentException();
            }
            long index = 0L;
            while (index + (long)src.length < length) {
                randomAccessFile.read(src);
                md.update(src);
                index += (long)src.length;
            }
            if (length - index > 0L) {
                randomAccessFile.read(src, 0, (int)(length - index));
                md.update(src, 0, (int)(length - index));
            }
            String string = StringUtil.toHexString(md.digest());
            return string;
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            String string = null;
            return string;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String md5Str(String str) {
        return StringUtil.toHexString(Md5Util.md5(str));
    }

    public static String generateStorngPasswordHash(String password) {
        try {
            int iterations = 10;
            char[] chars = password.toCharArray();
            byte[] salt = Md5Util.getSalt();
            PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, 512);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] hash = skf.generateSecret(spec).getEncoded();
            return iterations + ":" + StringUtil.toHexString(salt) + ":" + StringUtil.toHexString(hash);
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    private static byte[] getSalt() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[16];
        sr.nextBytes(salt);
        return salt;
    }

    public static boolean validatePassword(String originalPassword, String storedPassword) {
        try {
            String[] parts = storedPassword.split(":");
            int iterations = Integer.parseInt(parts[0]);
            byte[] salt = StringUtil.hexStringToBytes(parts[1]);
            byte[] hash = StringUtil.hexStringToBytes(parts[2]);
            PBEKeySpec spec = new PBEKeySpec(originalPassword.toCharArray(), salt, iterations, hash.length * 8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] testHash = skf.generateSecret(spec).getEncoded();
            int diff = hash.length ^ testHash.length;
            for (int i = 0; i < hash.length && i < testHash.length; ++i) {
                diff |= hash[i] ^ testHash[i];
            }
            return diff == 0;
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return false;
        }
    }
}

