/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.encrypt;

import com.jfirer.baseutil.encrypt.Base64Tool;
import com.jfirer.baseutil.encrypt.EnDecrpt;
import com.jfirer.baseutil.exception.UnSupportException;
import com.jfirer.baseutil.reflect.ReflectUtil;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAUtil
implements EnDecrpt {
    private final String algorithms;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private Cipher decryptCipher;
    private Cipher encrptCipher;
    private Signature sign;
    private Signature check;

    public RSAUtil(String algorithms) {
        this.algorithms = algorithms;
    }

    public static void main(String[] args) throws IOException {
        new RSAUtil("SHA1WithRSA").buildKey();
    }

    @Override
    public void setPublicKey(byte[] publicKeyBytes) {
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("rsa");
            this.publicKey = keyFactory.generatePublic(x509KeySpec);
            this.encrptCipher = Cipher.getInstance("rsa");
            this.encrptCipher.init(1, this.publicKey);
            this.check = Signature.getInstance(this.algorithms);
            this.check.initVerify(this.publicKey);
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
        }
    }

    @Override
    public void setPrivateKey(byte[] privateKeyBytes) {
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("rsa");
            this.privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            this.decryptCipher = Cipher.getInstance("rsa");
            this.decryptCipher.init(2, this.privateKey);
            this.sign = Signature.getInstance(this.algorithms);
            this.sign.initSign(this.privateKey);
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
        }
    }

    @Override
    public void setKey(byte[] key) {
        throw new UnSupportException("rsa\u52a0\u5bc6\u65b9\u6cd5\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u5bf9\u79f0\u5bc6\u94a5");
    }

    @Override
    public byte[] encrypt(byte[] src) {
        try {
            return this.encrptCipher.doFinal(src);
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    @Override
    public byte[] decrypt(byte[] src) {
        try {
            return this.decryptCipher.doFinal(src);
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    @Override
    public byte[] sign(byte[] src) {
        try {
            this.sign.update(src);
            return this.sign.sign();
        }
        catch (SignatureException e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    @Override
    public boolean check(byte[] src, byte[] sign) {
        try {
            this.check.update(src);
            return this.check.verify(sign);
        }
        catch (SignatureException e) {
            ReflectUtil.throwException(e);
            return false;
        }
    }

    public KeyPair buildKey() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("rsa");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            System.out.println("\u516c\u94a5\u662f\uff1a" + Base64Tool.encode(publicKey.getEncoded()));
            System.out.println("\u79c1\u94a5\u662f\uff1a" + Base64Tool.encode(privateKey.getEncoded()));
            return keyPair;
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    public KeyPair buildKey(int length) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("rsa");
            keyPairGenerator.initialize(length);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }
}

