/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.baseutil.reflect;

import com.jfirer.baseutil.reflect.UNSAFE;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class ReflectUtil {
    public static Map<String, ? extends Enum<?>> getAllEnumInstances(Class<? extends Enum<?>> type) {
        try {
            Method method = Class.class.getDeclaredMethod("enumConstantDirectory", new Class[0]);
            method.setAccessible(true);
            return new HashMap((Map)method.invoke(type, new Object[0]));
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    public static Class<?> wrapPrimitive(Class<?> type) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.class) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException();
    }

    public static void throwException(Throwable t) {
        if (UNSAFE.isAvailable()) {
            if (t == null) {
                throw new NullPointerException("\u4f20\u5165\u7684\u53c2\u6570\u4e3anull");
            }
            UNSAFE.throwThrowable(t);
        } else {
            ReflectUtil.throwException0(t);
        }
    }

    private static <E extends Throwable> void throwException0(Throwable t) throws E {
        throw t;
    }
}

